/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.callouts.client;

import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.scheduler.callouts.client.CallOutRequestFrame;
import org.jallinone.scheduler.callouts.java.DetailCallOutRequestVO;
import org.jallinone.subjects.java.OrganizationVO;
import org.jallinone.subjects.java.PeopleVO;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.receive.java.ValueObjectImpl;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.util.client.ClientUtils;

public class CallOutSubjectController
extends CompanyFormController {
    private CallOutRequestFrame frame = null;

    public CallOutSubjectController(CallOutRequestFrame frame) {
        this.frame = frame;
    }

    public void afterInsertData(Form form) {
        int i = 1;
        while (i < this.frame.getTab().getTabCount()) {
            this.frame.getTab().setEnabledAt(i, false);
            ++i;
        }
        this.frame.getControlCompaniesCombo().setEnabled(true);
        this.frame.getControlSubjectType().setEnabled(true);
        if (this.frame.getActPanel().getMode() != 1) {
            this.frame.getActPanel().insert();
        }
        if (this.frame.getCalloutPanel().getMode() != 1) {
            this.frame.getCalloutPanel().insert();
        }
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        ValueObjectImpl vo;
        if (this.frame.getControlSubjectType().getValue().equals("A")) {
            vo = (OrganizationVO)newPersistentObject;
            vo.setCompanyCodeSys01REG04((String)this.frame.getControlCompaniesCombo().getValue());
            vo.setSubjectTypeREG04("O");
        } else {
            vo = (PeopleVO)newPersistentObject;
            vo.setCompanyCodeSys01REG04((String)this.frame.getControlCompaniesCombo().getValue());
            vo.setSubjectTypeREG04("N");
        }
        Response res = ClientUtils.getData((String)"insertSubject", (Object)newPersistentObject);
        if (!res.isError()) {
            this.frame.getTab().setEnabledAt(1, true);
            this.frame.getControlCompaniesCombo().setEnabled(false);
            this.frame.getControlSubjectType().setEnabled(false);
            this.frame.setButtonsEnabled(true);
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)this.frame.getCalloutPanel().getVOModel().getValueObject();
        GridParams gridParams = new GridParams();
        gridParams.getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01SCH03());
        gridParams.getOtherGridParams().put("SUBJECT_TYPE", vo.getSubjectTypeReg04SCH03());
        gridParams.getOtherGridParams().put("PROGRESSIVE_REG04", vo.getProgressiveReg04SCH03());
        Response res = ClientUtils.getData((String)"loadSubjectPerName", (Object)gridParams);
        if (res.isError()) {
            return res;
        }
        if (((VOListResponse)res).getRows().size() == 0) {
            return new ErrorResponse("reload non allowed");
        }
        return new VOResponse(((VOListResponse)res).getRows().get(0));
    }

    public void loadDataCompleted(boolean error) {
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)this.frame.getCalloutPanel().getVOModel().getValueObject();
        if (vo.getCallOutStateSCH03().equals("D") || vo.getCallOutStateSCH03().equals("I")) {
            if (this.frame.getPeoplePanel().getEditButton() != null) {
                this.frame.getPeoplePanel().getEditButton().setEnabled(false);
            }
            if (this.frame.getPeoplePanel().getReloadButton() != null) {
                this.frame.getPeoplePanel().getReloadButton().setEnabled(false);
            }
            if (this.frame.getPeoplePanel().getDeleteButton() != null) {
                this.frame.getPeoplePanel().getDeleteButton().setEnabled(false);
            }
            if (this.frame.getOrganizationPanel().getEditButton() != null) {
                this.frame.getOrganizationPanel().getEditButton().setEnabled(false);
            }
            if (this.frame.getOrganizationPanel().getReloadButton() != null) {
                this.frame.getOrganizationPanel().getReloadButton().setEnabled(false);
            }
            if (this.frame.getOrganizationPanel().getDeleteButton() != null) {
                this.frame.getOrganizationPanel().getDeleteButton().setEnabled(false);
            }
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updateSubject", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        return res;
    }
}

