/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.gantt.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jallinone.employees.java.GridEmployeeVO;
import org.jallinone.scheduler.gantt.client.EmployeeGanttController;
import org.jallinone.scheduler.gantt.client.EmployeeGanttFrame_controlFrom_focusAdapter;
import org.jallinone.scheduler.gantt.client.EmployeeGanttFrame_controlTo_focusAdapter;
import org.jallinone.scheduler.gantt.client.EmployeeGanttFrame_viewButton_actionAdapter;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.gantt.client.AppointmentChangeListener;
import org.openswing.swing.gantt.client.GanttControl;
import org.openswing.swing.gantt.client.GanttDataLocator;
import org.openswing.swing.gantt.client.ServerGanttDataLocator;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class EmployeeGanttFrame
extends InternalFrame {
    CodLookupControl controlEmpCode;
    DateControl controlFrom;
    TextControl controlName_1;
    TextControl controlName_2;
    DateControl controlTo;
    private EmployeeGanttController controller = null;
    LookupController empController;
    LookupServerDataLocator empDataLocator;
    JPanel filterPanel;
    GanttControl gantt = new GanttControl();
    private ServerGanttDataLocator ganttDataLocator;
    GridBagLayout gridBagLayout1;
    LabelControl labelEmp;
    LabelControl labelFrom;
    LabelControl labelTo;
    GenericButton viewButton;

    public EmployeeGanttFrame(EmployeeGanttController controller) {
        this.filterPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.labelFrom = new LabelControl();
        this.controlFrom = new DateControl();
        this.labelTo = new LabelControl();
        this.controlTo = new DateControl();
        this.ganttDataLocator = new ServerGanttDataLocator();
        this.viewButton = new GenericButton(new ImageIcon(ClientUtils.getImage((String)"gantt.gif")));
        this.empDataLocator = new LookupServerDataLocator();
        this.empController = new LookupController();
        this.labelEmp = new LabelControl();
        this.controlEmpCode = new CodLookupControl();
        this.controlName_1 = new TextControl();
        this.controlName_2 = new TextControl();
        this.controller = controller;
        try {
            this.jbInit();
            this.gantt.init(new String[]{ClientSettings.getInstance().getResources().getResource("scheduled activities")});
            this.gantt.setGridEnabled(false);
            this.gantt.setShowDescription(false);
            this.gantt.setEnableInsert(false);
            this.gantt.setEnableEdit(true);
            this.gantt.setEnableDelete(true);
            this.gantt.setGanttDataLocator((GanttDataLocator)this.ganttDataLocator);
            this.ganttDataLocator.setServerMethodName("loadEmployeeActivitiesOnGantt");
            this.gantt.addAppointmentChangeListener((AppointmentChangeListener)controller);
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.controlFrom.setValue((Object)cal.getTime());
            this.gantt.setStartDate(cal.getTime());
            cal.set(5, cal.get(5) + 6);
            this.controlTo.setValue((Object)cal.getTime());
            this.gantt.setEndDate(cal.getTime());
            this.gantt.setAutoLoadData(false);
            this.empDataLocator.setGridMethodName("loadEmployees");
            this.empDataLocator.setValidationMethodName("validateEmployeeCode");
            this.controlEmpCode.setLookupController(this.empController);
            this.controlEmpCode.setControllerMethodName("getEmployeesList");
            this.empController.setLookupDataLocator((LookupDataLocator)this.empDataLocator);
            this.empController.setFrameTitle("employees");
            this.empController.setLookupValueObjectClassName("org.jallinone.employees.java.GridEmployeeVO");
            this.empController.addLookup2ParentLink("employeeCodeSCH01", "employeeCodeSCH01");
            this.empController.setAllColumnVisible(false);
            this.empController.setVisibleColumn("employeeCodeSCH01", true);
            this.empController.setVisibleColumn("name_1REG04", true);
            this.empController.setVisibleColumn("name_2REG04", true);
            this.empController.setPreferredWidthColumn("name_1REG04", 150);
            this.empController.setPreferredWidthColumn("name_2REG04", 150);
            this.empController.setFramePreferedSize(new Dimension(430, 400));
            this.empController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    GridEmployeeVO empVO = (GridEmployeeVO)EmployeeGanttFrame.this.empController.getLookupVO();
                    EmployeeGanttFrame.this.gantt.getGanttParameters().put("SCHEDULED_EMPLOYEE", empVO);
                    EmployeeGanttFrame.this.controlEmpCode.setValue((Object)empVO.getEmployeeCodeSCH01());
                    EmployeeGanttFrame.this.controlName_1.setValue((Object)empVO.getName_1REG04());
                    EmployeeGanttFrame.this.controlName_2.setValue((Object)empVO.getName_2REG04());
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            this.gantt.getGanttParameters().put("START_DATE", this.controlFrom.getValue());
            this.gantt.getGanttParameters().put("END_DATE", this.controlTo.getValue());
            this.setSize(750, 500);
            this.setMinimumSize(new Dimension(750, 500));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void controlFrom_focusLost(FocusEvent e) {
        if (this.controlFrom.getValue() == null || this.controlFrom.getValue().equals(this.gantt.getStartDate())) {
            return;
        }
        this.gantt.setStartDate((Date)this.controlFrom.getValue());
    }

    void controlTo_focusLost(FocusEvent e) {
        if (this.controlTo.getValue() == null || this.controlTo.getValue().equals(this.gantt.getEndDate())) {
            return;
        }
        this.gantt.setEndDate((Date)this.controlTo.getValue());
    }

    public GanttControl getGantt() {
        return this.gantt;
    }

    private void jbInit() throws Exception {
        this.viewButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("reload data"));
        this.viewButton.addActionListener((ActionListener)new EmployeeGanttFrame_viewButton_actionAdapter(this));
        this.filterPanel.setLayout(this.gridBagLayout1);
        this.labelFrom.setText("from date");
        this.labelTo.setText("to date");
        this.labelEmp.setText("employeeCodeSCH01");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("gantt diagram"));
        this.controlFrom.addFocusListener((FocusListener)new EmployeeGanttFrame_controlFrom_focusAdapter(this));
        this.controlTo.addFocusListener((FocusListener)new EmployeeGanttFrame_controlTo_focusAdapter(this));
        this.controlEmpCode.setMaxCharacters(20);
        this.getContentPane().add((Component)this.gantt, "Center");
        this.getContentPane().add((Component)this.filterPanel, "North");
        this.filterPanel.add((Component)this.labelFrom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlFrom, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.labelTo, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlTo, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.viewButton, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.labelEmp, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlEmpCode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlName_1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlName_2, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.controlName_1.setEnabled(false);
        this.controlName_2.setEnabled(false);
    }

    void viewButton_actionPerformed(ActionEvent e) {
        if (this.controlFrom.getValue() == null || this.controlTo.getValue() == null) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("you must specify both dates"), ClientSettings.getInstance().getResources().getResource("Attention"), 0);
            return;
        }
        if (this.controlEmpCode.getValue() == null || this.controlEmpCode.getValue() == null) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("you must specify employee code"), ClientSettings.getInstance().getResources().getResource("Attention"), 0);
            return;
        }
        this.gantt.reloadData();
    }
}

