/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sqltool.java;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jallinone.sqltool.java.ColumnVO;
import org.openswing.swing.message.receive.java.ValueObjectImpl;

public class TableVO
extends ValueObjectImpl {
    private ArrayList columns = new ArrayList();
    private Hashtable columnsMapping;
    private boolean convertColumnHeaders;
    private Hashtable foreingKeys;
    private ArrayList mainTables = new ArrayList();
    private Hashtable primaryKeys = new Hashtable();
    private String sql;

    public TableVO(String sql, ArrayList mainTables, boolean convertColumnHeaders) {
        this.foreingKeys = new Hashtable();
        this.columnsMapping = new Hashtable();
        this.sql = sql;
        this.mainTables = mainTables;
        this.convertColumnHeaders = convertColumnHeaders;
    }

    public void addColumn(ColumnVO vo) {
        this.columns.add(vo);
        this.columnsMapping.put(vo.getColumnName(), vo.getAttributeName());
    }

    public void addPrimaryKeys(String tableName, ArrayList pks) {
        this.primaryKeys.put(tableName, pks);
    }

    public ArrayList getAllTables() {
        ArrayList list = new ArrayList();
        Enumeration en = this.primaryKeys.keys();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        return list;
    }

    public String getAttributeName(String columnName) {
        return (String)this.columnsMapping.get(columnName);
    }

    public ArrayList getColumns() {
        return this.columns;
    }

    public Hashtable getForeingKeys() {
        return this.foreingKeys;
    }

    public ArrayList getMainTables() {
        return this.mainTables;
    }

    public ArrayList getPrimaryKeys(String tableName) {
        return (ArrayList)this.primaryKeys.get(tableName);
    }

    public String getSql() {
        return this.sql;
    }

    public boolean isConvertColumnHeaders() {
        return this.convertColumnHeaders;
    }

    public boolean isPrimaryKey(String columnName) {
        if (columnName.indexOf(".") == -1) {
            return false;
        }
        ArrayList pks = this.getPrimaryKeys(columnName.substring(0, columnName.indexOf(".")));
        if (pks == null) {
            return false;
        }
        return pks.contains(columnName);
    }

    public void setForeingKeys(Hashtable foreingKeys) {
        this.foreingKeys = foreingKeys;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

