/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.subjects.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.subjects.client.SubjectHierarchiesFrame;
import org.jallinone.subjects.java.SubjectHierarchyVO;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.tree.client.TreeController;
import org.openswing.swing.util.client.ClientUtils;

public class SubjectHierarchiesController
extends CompanyGridController
implements TreeController {
    private SubjectHierarchiesFrame frame = null;
    private String functionId = null;
    private BigDecimal idGrid = null;
    private String subjectTypeREG08 = null;

    public SubjectHierarchiesController(String subjectTypeREG08, String functionId, String title, BigDecimal idGrid, boolean loadCurrentLevel) {
        this.subjectTypeREG08 = subjectTypeREG08;
        this.functionId = functionId;
        this.idGrid = idGrid;
        this.frame = new SubjectHierarchiesFrame(this, functionId, title, subjectTypeREG08, loadCurrentLevel);
        MDIFrame.add((InternalFrame)this.frame, (boolean)true);
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response res = ClientUtils.getData((String)"deleteSubjectHierarchy", (Object)persistentObjects);
        if (!res.isError()) {
            this.frame.getTreePanel().clearTree();
            this.frame.getSubjectsGrid().clearData();
        }
        return res;
    }

    public void doubleClick(DefaultMutableTreeNode node) {
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        SubjectHierarchyVO vo = (SubjectHierarchyVO)persistentObject;
        this.frame.getTreePanel().setCompanyCode(vo.getCompanyCodeSys01REG08());
        this.frame.getTreePanel().setProgressiveHIE02(vo.getProgressiveHie02REG08());
        this.frame.getTreePanel().getTreeDataLocator().getTreeNodeParams().put("SUBJECT_TYPE", vo.getSubjectTypeREG08());
        this.frame.getTreePanel().getTreeDataLocator().getTreeNodeParams().put("FUCTION_CODE", this.functionId);
        this.frame.getTreePanel().reloadTree();
    }

    public BigDecimal getIdGrid() {
        return this.idGrid;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        Response res;
        ValueObject newValueObject = (ValueObject)newValueObjects.get(0);
        SubjectHierarchyVO vo = (SubjectHierarchyVO)newValueObject;
        vo.setSubjectTypeREG08(this.subjectTypeREG08);
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
        ArrayList companiesList = bca.getCompaniesList(this.functionId);
        if (vo.getCompanyCodeSys01REG08() == null) {
            vo.setCompanyCodeSys01REG08(companiesList.get(0).toString());
        }
        if ((res = ClientUtils.getData((String)"insertSubjectHierarchy", (Object)((Object)vo))).isError()) {
            return res;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((VOResponse)res).getVo());
        return new VOListResponse(list, false, list.size());
    }

    public void leftClick(DefaultMutableTreeNode node) {
        HierarchyLevelVO vo = (HierarchyLevelVO)((Object)node.getUserObject());
        HierarchyLevelVO root = (HierarchyLevelVO)((Object)((DefaultMutableTreeNode)node.getRoot()).getUserObject());
        String subjectType = (String)this.frame.getTreePanel().getTreeDataLocator().getTreeNodeParams().get("SUBJECT_TYPE");
        this.frame.getSubjectsGrid().getOtherGridParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02HIE01());
        this.frame.getSubjectsGrid().getOtherGridParams().put("PROGRESSIVE_HIE01", vo.getProgressiveHIE01());
        this.frame.getSubjectsGrid().getOtherGridParams().put("ROOT_PROGRESSIVE_HIE01", root.getProgressiveHIE01());
        this.frame.getSubjectsGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", this.frame.getTreePanel().getCompanyCode());
        this.frame.getSubjectsGrid().getOtherGridParams().put("SUBJECT_TYPE", subjectType);
        this.frame.getSubjectsGrid().reloadData();
    }

    public boolean rightClick(DefaultMutableTreeNode node) {
        return true;
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updateSubjectHierarchies", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

