/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.system.companies.client;

import java.math.BigDecimal;
import org.jallinone.subjects.java.OrganizationVO;
import org.jallinone.subjects.java.SubjectPK;
import org.jallinone.system.companies.client.CompaniesGridFrame;
import org.jallinone.system.companies.client.CompanyDetailFrame;
import org.openswing.swing.form.client.FormController;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class CompanyController
extends FormController {
    private String companyCodeSys01REG04 = null;
    private CompanyDetailFrame detailFrame = null;
    private CompaniesGridFrame gridFrame = null;
    private BigDecimal progressiveREG04 = null;

    public CompanyController(CompaniesGridFrame gridFrame, String companyCodeSys01REG04, BigDecimal progressiveREG04) {
        this.gridFrame = gridFrame;
        this.companyCodeSys01REG04 = companyCodeSys01REG04;
        this.progressiveREG04 = progressiveREG04;
        this.detailFrame = new CompanyDetailFrame(this);
        MDIFrame.add((InternalFrame)this.detailFrame);
        this.detailFrame.setParentFrame(gridFrame);
        gridFrame.pushFrame(this.detailFrame);
        if (companyCodeSys01REG04 != null && progressiveREG04 != null) {
            this.detailFrame.getOrganizationPanel().setMode(0);
            this.detailFrame.getOrganizationPanel().executeReload();
        } else {
            this.detailFrame.getOrganizationPanel().insert();
        }
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        OrganizationVO vo = (OrganizationVO)persistentObject;
        SubjectPK pk = new SubjectPK(vo.getCompanyCodeSys01REG04(), vo.getProgressiveREG04());
        Response response = ClientUtils.getData((String)"deleteCompany", (Object)pk);
        if (!response.isError()) {
            this.gridFrame.reloadData();
        }
        return response;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"insertCompany", (Object)newPersistentObject);
        if (!response.isError()) {
            this.companyCodeSys01REG04 = ((OrganizationVO)newPersistentObject).getCompanyCodeSys01REG04();
            this.progressiveREG04 = ((OrganizationVO)newPersistentObject).getProgressiveREG04();
            this.gridFrame.reloadData();
        }
        return response;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadCompany", (Object)new SubjectPK(this.companyCodeSys01REG04, this.progressiveREG04));
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"updateCompany", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!response.isError()) {
            this.gridFrame.reloadData();
        }
        return response;
    }
}

