/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.system.customizations.client;

import java.util.ArrayList;
import org.jallinone.system.customizations.client.CustomFunctionFrame;
import org.jallinone.system.customizations.client.CustomFunctionsGridFrame;
import org.jallinone.system.customizations.java.CustomFunctionVO;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.form.client.FormController;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class CustomFunctionController
extends FormController {
    private CustomFunctionFrame frame = null;
    private CustomFunctionsGridFrame parentFrame = null;
    private CustomFunctionVO vo = null;

    public CustomFunctionController(CustomFunctionsGridFrame parentFrame, CustomFunctionVO vo) {
        this.parentFrame = parentFrame;
        this.vo = vo;
        this.frame = new CustomFunctionFrame(this);
        MDIFrame.add((InternalFrame)this.frame, (boolean)true);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (vo != null) {
            this.frame.getHeaderFormPanel().setMode(0);
            this.frame.getHeaderFormPanel().executeReload();
        } else {
            this.frame.getHeaderFormPanel().insert();
        }
    }

    public void afterEditData(Form form) {
        this.frame.getTablesList().setEnabled(true);
        this.frame.getShowQuery().setEnabled(false);
    }

    public void afterInsertData() {
        if (this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        this.frame.getGrid().getOtherGridParams().put("FUNCTION_CODE_SYS06", this.vo.getFunctionCodeSys06SYS16());
        this.frame.getGrid().reloadData();
        this.frame.getTablesList().setEnabled(false);
        this.frame.setButtonsEnabled(true);
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getGrid().clearData();
            this.frame.setButtonsEnabled(false);
            this.frame.clearList();
            this.frame.getShowQuery().setEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        CustomFunctionVO vo = (CustomFunctionVO)persistentObject;
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<String> pks = new ArrayList<String>();
        pks.add(this.vo.getFunctionCodeSys06SYS16());
        Response res = ClientUtils.getData((String)"deleteCustomFunctions", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getGrid().clearData();
            this.frame.clearList();
            this.frame.getShowQuery().setEnabled(false);
        }
        return res;
    }

    public CustomFunctionsGridFrame getParentFrame() {
        return this.parentFrame;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        this.vo = (CustomFunctionVO)newPersistentObject;
        String mainTables = "";
        Object[] sel = this.frame.getTablesList().getSelectedValues();
        if (sel != null) {
            int i = 0;
            while (i < sel.length) {
                mainTables = mainTables + sel[i] + (i < sel.length - 1 ? "," : "");
                ++i;
            }
        }
        this.vo.setMainTablesSYS16(mainTables);
        Response res = ClientUtils.getData((String)"insertCustomFunction", (Object)newPersistentObject);
        if (!res.isError()) {
            this.vo = (CustomFunctionVO)((Object)((VOResponse)res).getVo());
            this.frame.loadDataCompleted(false, this.vo);
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return new VOResponse((Object)this.vo);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.vo);
    }

    public void modeChanged(int currentMode) {
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        this.vo = (CustomFunctionVO)persistentObject;
        String mainTables = "";
        Object[] sel = this.frame.getTablesList().getSelectedValues();
        if (sel != null) {
            int i = 0;
            while (i < sel.length) {
                mainTables = mainTables + sel[i] + (i < sel.length - 1 ? "," : "");
                ++i;
            }
        }
        this.vo.setMainTablesSYS16(mainTables);
        Response res = ClientUtils.getData((String)"updateCustomFunction", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError()) {
            this.frame.getGrid().reloadData();
            this.frame.getTablesList().setEnabled(false);
            this.frame.getShowQuery().setEnabled(true);
        }
        return res;
    }
}

