/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.system.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ButtonCompanyAuthorizations
implements Serializable {
    private Hashtable authorizations = new Hashtable();

    public final void addButtonAuthorization(String functionId, String companyCode, boolean isInsertEnabled, boolean isEditEnabled, boolean isDeleteEnabled) {
        Hashtable<String, ButtonAuthorization> companies = (Hashtable<String, ButtonAuthorization>)this.authorizations.get(functionId);
        if (companies == null) {
            companies = new Hashtable<String, ButtonAuthorization>();
            this.authorizations.put(functionId, companies);
            companies.put(companyCode, new ButtonAuthorization(isInsertEnabled, isEditEnabled, isDeleteEnabled));
        } else {
            ButtonAuthorization ba = (ButtonAuthorization)companies.get(companyCode);
            if (ba == null) {
                companies.put(companyCode, new ButtonAuthorization(isInsertEnabled, isEditEnabled, isDeleteEnabled));
            } else {
                companies.put(companyCode, new ButtonAuthorization(ba.isInsertEnabled() || isInsertEnabled, ba.isEditEnabled() || isEditEnabled, ba.isDeleteEnabled() || isDeleteEnabled));
            }
        }
    }

    public final ArrayList getCompaniesList(String functionId) {
        ArrayList list = new ArrayList();
        Hashtable companies = (Hashtable)this.authorizations.get(functionId);
        if (companies != null) {
            Enumeration keys = companies.keys();
            while (keys.hasMoreElements()) {
                list.add(keys.nextElement());
            }
        }
        return list;
    }

    public final boolean isDeleteEnabled(String functionId, String companyCode) {
        if (functionId == null) {
            return false;
        }
        Hashtable companies = (Hashtable)this.authorizations.get(functionId);
        if (companies == null) {
            return false;
        }
        ButtonAuthorization auth = (ButtonAuthorization)companies.get(companyCode);
        if (auth == null) {
            return false;
        }
        return auth.isDeleteEnabled();
    }

    public final boolean isEditEnabled(String functionId, String companyCode) {
        if (functionId == null) {
            return false;
        }
        Hashtable companies = (Hashtable)this.authorizations.get(functionId);
        if (companies == null) {
            return false;
        }
        ButtonAuthorization auth = (ButtonAuthorization)companies.get(companyCode);
        if (auth == null) {
            return false;
        }
        return auth.isEditEnabled();
    }

    public final boolean isInsertEnabled(String functionId, String companyCode) {
        if (functionId == null) {
            return false;
        }
        Hashtable companies = (Hashtable)this.authorizations.get(functionId);
        if (companies == null) {
            return false;
        }
        ButtonAuthorization auth = (ButtonAuthorization)companies.get(companyCode);
        if (auth == null) {
            return false;
        }
        return auth.isInsertEnabled();
    }

    class ButtonAuthorization
    implements Serializable {
        private boolean isDeleteEnabled;
        private boolean isEditEnabled;
        private boolean isInsertEnabled;

        public ButtonAuthorization(boolean isInsertEnabled, boolean isEditEnabled, boolean isDeleteEnabled) {
            this.isInsertEnabled = isInsertEnabled;
            this.isEditEnabled = isEditEnabled;
            this.isDeleteEnabled = isDeleteEnabled;
        }

        public final boolean isDeleteEnabled() {
            return this.isDeleteEnabled;
        }

        public final boolean isEditEnabled() {
            return this.isEditEnabled;
        }

        public final boolean isInsertEnabled() {
            return this.isInsertEnabled;
        }
    }
}

