/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.system.permissions.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jallinone.system.permissions.java.RoleFunctionVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class RoleFunctionsController
extends GridController {
    private GridControl companiesGridControl = null;
    private GridControl functionsGridControl = null;

    public RoleFunctionsController(GridControl functionsGridControl, GridControl companiesGridControl) {
        this.functionsGridControl = functionsGridControl;
        this.companiesGridControl = companiesGridControl;
    }

    public boolean beforeEditGrid(GridControl grid) {
        Object progressiveSYS04 = this.functionsGridControl.getOtherGridParams().get("PROGRESSIVE_SYS04");
        if (progressiveSYS04 == null) {
            return false;
        }
        if (progressiveSYS04.equals(new BigDecimal(2.0))) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)grid), ClientSettings.getInstance().getResources().getResource("you cannot change the administrator role"), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return false;
        }
        return true;
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        if (this.functionsGridControl.getSelectedRow() != -1) {
            RoleFunctionVO vo = (RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(this.functionsGridControl.getSelectedRow());
            if (vo.getUseCompanyCodeSYS06().booleanValue()) {
                this.companiesGridControl.getOtherGridParams().put("PROGRESSIVE_SYS04", vo.getProgressiveSys04SYS07());
                this.companiesGridControl.getOtherGridParams().put("FUNCTION_CODE_SYS06", vo.getFunctionCodeSys06SYS07());
                this.companiesGridControl.reloadData();
            } else {
                this.companiesGridControl.clearData();
            }
        }
    }

    public boolean isCellEditable(GridControl grid, int row, String attributeName) {
        RoleFunctionVO vo = (RoleFunctionVO)grid.getVOListTableModel().getObjectForRow(row);
        if (vo.getUseCompanyCodeSYS06().booleanValue() && !attributeName.equals("canView")) {
            return false;
        }
        if (attributeName.equals("functionCodeSys06SYS07")) {
            return false;
        }
        return grid.isFieldEditable(row, attributeName);
    }

    public void loadDataCompleted(boolean error) {
        this.companiesGridControl.clearData();
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updateRoleFunctions", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        if (attributeName.equals("canInsSYS07") || attributeName.equals("canUpdSYS07") || attributeName.equals("canDelSYS07")) {
            if (((Boolean)newValue).booleanValue()) {
                ((RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(rowNumber)).setCanView(Boolean.TRUE);
            }
        } else if (attributeName.equals("canView")) {
            if (((Boolean)newValue).booleanValue()) {
                ((RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(rowNumber)).setCanInsSYS07(Boolean.TRUE);
                ((RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(rowNumber)).setCanUpdSYS07(Boolean.TRUE);
                ((RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(rowNumber)).setCanDelSYS07(Boolean.TRUE);
            } else {
                ((RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(rowNumber)).setCanInsSYS07(Boolean.FALSE);
                ((RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(rowNumber)).setCanUpdSYS07(Boolean.FALSE);
                ((RoleFunctionVO)this.functionsGridControl.getVOListTableModel().getObjectForRow(rowNumber)).setCanDelSYS07(Boolean.FALSE);
            }
        }
        return true;
    }
}

