/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.system.permissions.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.system.permissions.client.RolesFrame;
import org.jallinone.system.permissions.java.RoleVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class RolesController
extends GridController {
    private BigDecimal currentProgressiveSYS04 = null;
    private RolesFrame gridFrame = new RolesFrame(this);

    public RolesController() {
        MDIFrame.add((InternalFrame)this.gridFrame);
    }

    public boolean beforeCopyGrid(GridControl grid) {
        RoleVO vo = (RoleVO)grid.getVOListTableModel().getObjectForRow(grid.getSelectedRow());
        this.currentProgressiveSYS04 = vo.getProgressiveSYS04();
        return true;
    }

    public boolean beforeDeleteGrid(GridControl grid) {
        RoleVO vo = (RoleVO)grid.getVOListTableModel().getObjectForRow(grid.getSelectedRow());
        if (vo.getProgressiveSYS04().equals(new BigDecimal(2.0))) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)grid), ClientSettings.getInstance().getResources().getResource("you cannot delete the administrator role"), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return false;
        }
        return true;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response response = ClientUtils.getData((String)"deleteRole", persistentObjects.get(0));
        if (!response.isError()) {
            this.gridFrame.getFunctionsGridControl().clearData();
            this.gridFrame.getCompaniesGridControl().clearData();
        }
        return response;
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        DefaultMutableTreeNode selNode = this.gridFrame.getTreePanel().getSelectedNode();
        if (selNode != null) {
            this.gridFrame.getTreeFoldersController().leftClick(selNode);
        }
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        RoleVO vo = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (RoleVO)((Object)newValueObjects.get(i));
            vo.setProgressiveSYS04(this.currentProgressiveSYS04);
            ++i;
        }
        Response response = ClientUtils.getData((String)"insertRoles", (Object)newValueObjects);
        if (!response.isError()) {
            this.currentProgressiveSYS04 = null;
            List rows = ((VOListResponse)response).getRows();
            MDIFrame.getInstance();
            ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
            int i2 = 0;
            while (i2 < rows.size()) {
                vo = (RoleVO)((Object)rows.get(i2));
                applet.getAuthorizations().getUserRoles().put(vo.getProgressiveSYS04(), vo.getDescriptionSYS10());
                ++i2;
            }
        }
        return response;
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updateRoles", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

