/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.client;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.warehouse.client.WarehouseDetailFrame;
import org.jallinone.warehouse.client.WarehousesGridFrame;
import org.jallinone.warehouse.java.WarehousePK;
import org.jallinone.warehouse.java.WarehouseVO;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class WarehouseController
extends CompanyFormController {
    private String companyCodeSys01WAR01 = null;
    private WarehouseDetailFrame detailFrame = null;
    private WarehousesGridFrame gridFrame = null;
    private String warehouseCodeWAR01 = null;

    public WarehouseController(WarehousesGridFrame gridFrame, String companyCodeSys01WAR01, String warehouseCodeWAR01) {
        this.gridFrame = gridFrame;
        this.companyCodeSys01WAR01 = companyCodeSys01WAR01;
        this.warehouseCodeWAR01 = warehouseCodeWAR01;
        this.detailFrame = new WarehouseDetailFrame(this);
        MDIFrame.add((InternalFrame)this.detailFrame);
        this.detailFrame.setParentFrame(gridFrame);
        gridFrame.pushFrame(this.detailFrame);
        if (companyCodeSys01WAR01 != null && warehouseCodeWAR01 != null) {
            this.detailFrame.getWarehouseForm().setMode(0);
            this.detailFrame.getWarehouseForm().executeReload();
        } else {
            this.detailFrame.getWarehouseForm().insert();
        }
    }

    public void afterInsertData() {
        WarehouseVO vo = (WarehouseVO)this.detailFrame.getWarehouseForm().getVOModel().getValueObject();
        this.detailFrame.getHierarTreePanel().setCompanyCode(vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getHierarTreePanel().setProgressiveHIE02(vo.getProgressiveHie02WAR01());
        this.detailFrame.getHierarTreePanel().reloadTree();
        this.detailFrame.getAvailPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getAvailPanel().getGrid().getOtherGridParams().put("WAREHOUSE_CODE", vo.getWarehouseCodeWAR01());
        this.detailFrame.getAvailPanel().getGrid().getOtherGridParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02WAR01());
        this.detailFrame.getAvailPanel().setEnabled(true);
        this.detailFrame.getBookedItemsPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getBookedItemsPanel().getGrid().getOtherGridParams().put("WAREHOUSE_CODE", vo.getWarehouseCodeWAR01());
        this.detailFrame.getBookedItemsPanel().setEnabled(true);
        this.detailFrame.getOrderedItemsPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getOrderedItemsPanel().getGrid().getOtherGridParams().put("WAREHOUSE_CODE", vo.getWarehouseCodeWAR01());
        this.detailFrame.getBookedItemsPanel().setEnabled(true);
    }

    public void afterReloadData() {
    }

    public boolean beforeDeleteData(Form form) {
        boolean canDelete = super.beforeDeleteData(form);
        if (!canDelete) {
            return false;
        }
        WarehouseVO vo = (WarehouseVO)form.getVOModel().getValueObject();
        if (vo.getProgressiveSys04WAR01() == null) {
            return true;
        }
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        if (!applet.getAuthorizations().getUserRoles().containsKey(vo.getProgressiveSys04WAR01())) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)form), ClientSettings.getInstance().getResources().getResource("You are not allowed to delete data."), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return false;
        }
        return true;
    }

    public boolean beforeEditData(Form form) {
        boolean canEdit = super.beforeEditData(form);
        if (!canEdit) {
            return false;
        }
        WarehouseVO vo = (WarehouseVO)form.getVOModel().getValueObject();
        if (vo.getProgressiveSys04WAR01() == null) {
            this.detailFrame.getHierarTreePanel().setEnabled(true);
            return true;
        }
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        if (!applet.getAuthorizations().getUserRoles().containsKey(vo.getProgressiveSys04WAR01())) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)form), ClientSettings.getInstance().getResources().getResource("You are not allowed to edit data."), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return false;
        }
        this.detailFrame.getHierarTreePanel().setEnabled(true);
        return true;
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.detailFrame.getHierarTreePanel().clearTree();
            this.detailFrame.getHierarTreePanel().setEnabled(false);
            this.detailFrame.getAvailPanel().setEnabled(false);
            this.detailFrame.getAvailPanel().getGrid().clearData();
            this.detailFrame.getBookedItemsPanel().setEnabled(false);
            this.detailFrame.getBookedItemsPanel().getGrid().clearData();
            this.detailFrame.getOrderedItemsPanel().setEnabled(false);
            this.detailFrame.getOrderedItemsPanel().getGrid().clearData();
        }
        return ok;
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        WarehouseVO vo = (WarehouseVO)persistentObject;
        WarehousePK pk = new WarehousePK(vo.getCompanyCodeSys01WAR01(), vo.getWarehouseCodeWAR01());
        Response response = ClientUtils.getData((String)"deleteWarehouse", (Object)pk);
        if (!response.isError()) {
            this.gridFrame.reloadData();
        }
        return response;
    }

    public WarehousesGridFrame getGridFrame() {
        return this.gridFrame;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"insertWarehouse", (Object)newPersistentObject);
        if (!response.isError()) {
            this.companyCodeSys01WAR01 = ((WarehouseVO)newPersistentObject).getCompanyCodeSys01WAR01();
            this.warehouseCodeWAR01 = ((WarehouseVO)newPersistentObject).getWarehouseCodeWAR01();
        }
        return response;
    }

    public Response loadData(Class valueObjectClass) {
        int row = this.gridFrame.getGrid().getSelectedRow();
        if (row != -1) {
            WarehouseVO gridVO = (WarehouseVO)this.gridFrame.getGrid().getVOListTableModel().getObjectForRow(row);
            this.companyCodeSys01WAR01 = gridVO.getCompanyCodeSys01WAR01();
            this.warehouseCodeWAR01 = gridVO.getWarehouseCodeWAR01();
        }
        return ClientUtils.getData((String)"loadWarehouse", (Object)new WarehousePK(this.companyCodeSys01WAR01, this.warehouseCodeWAR01));
    }

    public void loadDataCompleted(boolean error) {
        WarehouseVO vo = (WarehouseVO)this.detailFrame.getWarehouseForm().getVOModel().getValueObject();
        this.detailFrame.getHierarTreePanel().setEnabled(false);
        this.detailFrame.getHierarTreePanel().setCompanyCode(vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getHierarTreePanel().setProgressiveHIE02(vo.getProgressiveHie02WAR01());
        this.detailFrame.getHierarTreePanel().reloadTree();
        this.detailFrame.getAvailPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getAvailPanel().getGrid().getOtherGridParams().put("WAREHOUSE_CODE", vo.getWarehouseCodeWAR01());
        this.detailFrame.getAvailPanel().getGrid().getOtherGridParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02WAR01());
        if (this.detailFrame.getHierarTreePanel().getSelectedNode() != null) {
            HierarchyLevelVO levelVO = (HierarchyLevelVO)((Object)this.detailFrame.getHierarTreePanel().getSelectedNode().getUserObject());
            this.detailFrame.getAvailPanel().getGrid().getOtherGridParams().put("PROGRESSIVE_HIE01", levelVO.getProgressiveHIE01());
        }
        this.detailFrame.getAvailPanel().setEnabled(true);
        this.detailFrame.getAvailPanel().getGrid().reloadData();
        this.detailFrame.getBookedItemsPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getBookedItemsPanel().getGrid().getOtherGridParams().put("WAREHOUSE_CODE", vo.getWarehouseCodeWAR01());
        this.detailFrame.getBookedItemsPanel().setEnabled(true);
        this.detailFrame.getBookedItemsPanel().getGrid().reloadData();
        this.detailFrame.getOrderedItemsPanel().getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01WAR01());
        this.detailFrame.getOrderedItemsPanel().getGrid().getOtherGridParams().put("WAREHOUSE_CODE", vo.getWarehouseCodeWAR01());
        this.detailFrame.getOrderedItemsPanel().setEnabled(true);
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"updateWarehouse", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!response.isError()) {
            // empty if block
        }
        return response;
    }
}

