/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.client;

import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.warehouse.client.WarehouseController;
import org.jallinone.warehouse.client.WarehousesGridFrame;
import org.jallinone.warehouse.java.WarehousePK;
import org.jallinone.warehouse.java.WarehouseVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class WarehousesController
extends CompanyGridController {
    private WarehousesGridFrame gridFrame = null;
    private ClientApplet mainClass = null;

    public WarehousesController(ClientApplet mainClass) {
        this.mainClass = mainClass;
        this.gridFrame = new WarehousesGridFrame(this);
        MDIFrame.add((InternalFrame)this.gridFrame);
    }

    public boolean beforeDeleteGrid(GridControl grid) {
        boolean canDelete = super.beforeDeleteGrid(grid);
        if (!canDelete) {
            return false;
        }
        WarehouseVO vo = (WarehouseVO)grid.getVOListTableModel().getObjectForRow(grid.getSelectedRow());
        if (vo.getProgressiveSys04WAR01() == null) {
            return true;
        }
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        if (!applet.getAuthorizations().getUserRoles().containsKey(vo.getProgressiveSys04WAR01())) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)grid), ClientSettings.getInstance().getResources().getResource("You are not allowed to delete data."), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return false;
        }
        return true;
    }

    public boolean beforeInsertGrid(GridControl grid) {
        if (super.beforeInsertGrid(grid)) {
            new WarehouseController(this.gridFrame, null, null);
        }
        return false;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        WarehouseVO vo = (WarehouseVO)((Object)persistentObjects.get(0));
        WarehousePK pk = new WarehousePK(vo.getCompanyCodeSys01WAR01(), vo.getWarehouseCodeWAR01());
        Response response = ClientUtils.getData((String)"deleteWarehouse", (Object)pk);
        return response;
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        new WarehouseController(this.gridFrame, ((WarehouseVO)persistentObject).getCompanyCodeSys01WAR01(), ((WarehouseVO)persistentObject).getWarehouseCodeWAR01());
    }
}

