/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.documents.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.warehouse.documents.client.InDeliveryNoteFrame;
import org.jallinone.warehouse.documents.client.InDeliveryNotesFrame;
import org.jallinone.warehouse.documents.java.DeliveryNotePK;
import org.jallinone.warehouse.documents.java.DetailDeliveryNoteVO;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class InDeliveryNoteController
extends CompanyFormController {
    private InDeliveryNoteFrame frame = null;
    private InDeliveryNotesFrame parentFrame = null;
    private DeliveryNotePK pk = null;

    public InDeliveryNoteController(InDeliveryNotesFrame parentFrame, DeliveryNotePK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new InDeliveryNoteFrame(this);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getHeaderFormPanel().setMode(0);
            this.frame.getHeaderFormPanel().executeReload();
        } else {
            this.frame.getHeaderFormPanel().insert();
        }
    }

    public void afterInsertData() {
        if (this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        this.frame.getRowsPanel().setParentVO(vo);
        this.frame.getRowsPanel().getGrid().getOtherGridParams().put("DELIVERY_NOTE_PK", this.pk);
        this.frame.getRowsPanel().getGrid().reloadData();
        this.frame.setButtonsEnabled(true);
    }

    public boolean beforeDeleteData(Form form) {
        if (!super.beforeDeleteData(form)) {
            return false;
        }
        DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC08().equals("D");
    }

    public boolean beforeEditData(Form form) {
        if (!super.beforeEditData(form)) {
            return false;
        }
        DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC08().equals("D");
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getRowsPanel().getGrid().clearData();
            this.frame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)persistentObject;
        Calendar cal = Calendar.getInstance();
        vo.setDocYearDOC08(new BigDecimal((double)cal.get(1)));
        vo.setDocDateDOC08(new Date(System.currentTimeMillis()));
        vo.setDeliveryDateDOC08(new Date(System.currentTimeMillis()));
        vo.setDocTypeDOC08("I");
        vo.setDocStateDOC08("O");
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<DeliveryNotePK> pks = new ArrayList<DeliveryNotePK>();
        DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)persistentObject;
        pks.add(this.pk);
        Response res = ClientUtils.getData((String)"deleteDeliveryNotes", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getRowsPanel().getGrid().clearData();
        }
        return res;
    }

    public InDeliveryNotesFrame getParentFrame() {
        return this.parentFrame;
    }

    public DeliveryNotePK getPk() {
        return this.pk;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"insertInDeliveryNote", (Object)newPersistentObject);
        if (!res.isError()) {
            DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)((Object)((VOResponse)res).getVo());
            this.pk = new DeliveryNotePK(vo.getCompanyCodeSys01DOC08(), vo.getDocTypeDOC08(), vo.getDocYearDOC08(), vo.getDocNumberDOC08());
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadInDeliveryNote", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updateInDeliveryNote", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError() && this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
            DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
            this.frame.getRowsPanel().setParentVO(vo);
        }
        return res;
    }
}

