/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.documents.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import org.jallinone.warehouse.documents.client.DeliveryNoteFooterPanel;
import org.jallinone.warehouse.documents.client.DeliveryNoteWarehousePanel;
import org.jallinone.warehouse.documents.client.InDeliveryNoteController;
import org.jallinone.warehouse.documents.client.InDeliveryNoteFrame_closeButton_actionAdapter;
import org.jallinone.warehouse.documents.client.InDeliveryNoteFrame_printButton_actionAdapter;
import org.jallinone.warehouse.documents.client.InDeliveryNoteIdPanel;
import org.jallinone.warehouse.documents.client.InDeliveryNoteRowsGridPanel;
import org.jallinone.warehouse.documents.java.DeliveryNotePK;
import org.jallinone.warehouse.documents.java.DetailDeliveryNoteVO;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.form.client.FormController;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class InDeliveryNoteFrame
extends InternalFrame {
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2;
    BorderLayout borderLayout3;
    BorderLayout borderLayout4;
    GenericButton closeButton;
    private InDeliveryNoteController controller = null;
    InDeliveryNoteIdPanel delNoteIdHeadPanel;
    DeleteButton deleteButton1;
    DeliveryNoteFooterPanel deliveryNoteFooterPanel;
    EditButton editButton1;
    FlowLayout flowLayout1;
    GridBagLayout gridBagLayout1;
    JPanel headerButtonsPanel;
    Form headerFormPanel;
    JPanel headerPanel;
    InsertButton insertButton1;
    JPanel linesPanel;
    JPanel mainPanel = new JPanel();
    GenericButton printButton;
    ReloadButton reloadButton1;
    InDeliveryNoteRowsGridPanel rowsPanel;
    SaveButton saveButton1;
    JTabbedPane tabbedPane;
    DeliveryNoteWarehousePanel warePanel;

    public InDeliveryNoteFrame(InDeliveryNoteController controller) {
        this.borderLayout2 = new BorderLayout();
        this.tabbedPane = new JTabbedPane();
        this.headerPanel = new JPanel();
        this.flowLayout1 = new FlowLayout();
        this.headerButtonsPanel = new JPanel();
        this.borderLayout3 = new BorderLayout();
        this.linesPanel = new JPanel();
        this.borderLayout4 = new BorderLayout();
        this.headerFormPanel = new Form();
        this.insertButton1 = new InsertButton();
        this.editButton1 = new EditButton();
        this.saveButton1 = new SaveButton();
        this.reloadButton1 = new ReloadButton();
        this.deleteButton1 = new DeleteButton();
        this.gridBagLayout1 = new GridBagLayout();
        this.delNoteIdHeadPanel = new InDeliveryNoteIdPanel(this.headerFormPanel);
        this.deliveryNoteFooterPanel = new DeliveryNoteFooterPanel(this.headerFormPanel);
        this.rowsPanel = new InDeliveryNoteRowsGridPanel(this, this.headerFormPanel);
        this.closeButton = new GenericButton(new ImageIcon(ClientUtils.getImage((String)"workflow.gif")));
        this.warePanel = new DeliveryNoteWarehousePanel(this.headerFormPanel);
        this.printButton = new GenericButton(new ImageIcon(ClientUtils.getImage((String)"printer.gif")));
        this.controller = controller;
        try {
            this.jbInit();
            this.setSize(750, 550);
            this.setMinimumSize(new Dimension(750, 550));
            this.setTitle(ClientSettings.getInstance().getResources().getResource("in delivery note"));
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void closeButton_actionPerformed(ActionEvent e) {
        if (JOptionPane.showConfirmDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("close delivery note?"), ClientSettings.getInstance().getResources().getResource("delivery note closure"), 0) == 0) {
            Response res = ClientUtils.getData((String)"closeDeliveryNote", (Object)this.headerFormPanel.getVOModel().getValueObject());
            if (!res.isError()) {
                this.headerFormPanel.setMode(0);
                this.headerFormPanel.executeReload();
                this.getOrders().reloadData();
            } else {
                JOptionPane.showConfirmDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
            }
        }
    }

    public void enabledConfirmButton() {
        this.closeButton.setEnabled(true);
    }

    public Form getHeaderFormPanel() {
        return this.headerFormPanel;
    }

    public GridControl getOrders() {
        return this.controller.getParentFrame().getGrid();
    }

    public InDeliveryNoteRowsGridPanel getRowsPanel() {
        return this.rowsPanel;
    }

    private void init() {
        HashSet<String> attributeNameToDisable = new HashSet<String>();
        attributeNameToDisable.add("warehouseCodeWar01DOC08");
        attributeNameToDisable.add("supplierCustomerCodeDOC08");
        this.headerFormPanel.addInputControlAttributesNotEditableOnState(attributeNameToDisable, "docStateDOC08", (Object)"B");
        attributeNameToDisable = new HashSet();
        attributeNameToDisable.add("warehouseCodeWar01DOC08");
        attributeNameToDisable.add("supplierCustomerCodeDOC08");
        attributeNameToDisable.add("carrierCodeReg09DOC08");
        attributeNameToDisable.add("docDateDOC08");
        attributeNameToDisable.add("deliveryDateDOC08");
        attributeNameToDisable.add("transportMotiveCodeReg20DOC08");
        attributeNameToDisable.add("noteDOC08");
        attributeNameToDisable.add("docRefDOC08");
        attributeNameToDisable.add("addressDOC08");
        attributeNameToDisable.add("cityDOC08");
        attributeNameToDisable.add("provinceDOC08");
        attributeNameToDisable.add("countryDOC08");
        attributeNameToDisable.add("zipDOC08");
        this.headerFormPanel.addInputControlAttributesNotEditableOnState(attributeNameToDisable, "docStateDOC08", (Object)"D");
    }

    private void jbInit() throws Exception {
        this.printButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("print document"));
        this.printButton.setEnabled(false);
        this.printButton.addActionListener((ActionListener)new InDeliveryNoteFrame_printButton_actionAdapter(this));
        this.headerFormPanel.setFunctionId("DOC08_IN");
        this.headerFormPanel.setFormController((FormController)this.controller);
        this.headerFormPanel.setVOClassName("org.jallinone.warehouse.documents.java.DetailDeliveryNoteVO");
        this.headerPanel.setLayout(this.borderLayout3);
        this.headerButtonsPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.mainPanel.setLayout(this.borderLayout2);
        this.getContentPane().setLayout(this.borderLayout1);
        this.linesPanel.setLayout(this.borderLayout4);
        this.insertButton1.setText("insertButton1");
        this.reloadButton1.setText("reloadButton1");
        this.deleteButton1.setText("deleteButton1");
        this.headerFormPanel.setLayout((LayoutManager)this.gridBagLayout1);
        this.headerFormPanel.setInsertButton(this.insertButton1);
        this.headerFormPanel.setEditButton(this.editButton1);
        this.headerFormPanel.setReloadButton(this.reloadButton1);
        this.headerFormPanel.setDeleteButton(this.deleteButton1);
        this.headerFormPanel.setSaveButton(this.saveButton1);
        this.closeButton.addActionListener((ActionListener)new InDeliveryNoteFrame_closeButton_actionAdapter(this));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.add((Component)this.headerPanel, "header");
        this.headerPanel.add((Component)this.headerButtonsPanel, "North");
        this.headerButtonsPanel.add((Component)this.insertButton1, null);
        this.headerButtonsPanel.add((Component)this.editButton1, null);
        this.headerButtonsPanel.add((Component)this.saveButton1, null);
        this.headerButtonsPanel.add((Component)this.reloadButton1, null);
        this.headerButtonsPanel.add((Component)this.deleteButton1, null);
        this.headerButtonsPanel.add((Component)this.closeButton, null);
        this.headerButtonsPanel.add((Component)this.printButton, null);
        this.tabbedPane.add((Component)this.linesPanel, "lines");
        this.linesPanel.add((Component)this.rowsPanel, "Center");
        this.headerPanel.add((Component)this.headerFormPanel, "Center");
        this.headerFormPanel.add((Component)this.delNoteIdHeadPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.headerFormPanel.add((Component)this.warePanel, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.headerFormPanel.add((Component)this.deliveryNoteFooterPanel, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.setTitleAt(0, ClientSettings.getInstance().getResources().getResource("header"));
        this.tabbedPane.setTitleAt(1, ClientSettings.getInstance().getResources().getResource("lines"));
        this.closeButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("delivery note closure"));
        this.closeButton.setEnabled(false);
    }

    public void loadDataCompleted(boolean error, DeliveryNotePK pk) {
        DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)this.headerFormPanel.getVOModel().getValueObject();
        this.rowsPanel.setParentVO(vo);
        this.rowsPanel.getGrid().getOtherGridParams().put("DELIVERY_NOTE_PK", pk);
        this.rowsPanel.getGrid().reloadData();
        if (vo.getDocStateDOC08().equals("D")) {
            this.closeButton.setEnabled(false);
            this.setButtonsEnabled(false);
            this.rowsPanel.setButtonsEnabled(false);
        }
        if (!vo.getDocStateDOC08().equals("B")) {
            this.closeButton.setEnabled(false);
        } else if (vo.getDocStateDOC08().equals("B")) {
            this.closeButton.setEnabled(true);
        }
        if (vo.getDocStateDOC08().equals("C") || vo.getDocStateDOC08().equals("D") || vo.getDocStateDOC08().equals("B")) {
            this.printButton.setEnabled(true);
        } else {
            this.printButton.setEnabled(false);
        }
        if (vo.getDocStateDOC08().equals("C") || vo.getDocStateDOC08().equals("D") || vo.getDocStateDOC08().equals("B")) {
            this.printButton.setEnabled(true);
        } else {
            this.printButton.setEnabled(false);
        }
    }

    void printButton_actionPerformed(ActionEvent e) {
        DetailDeliveryNoteVO vo = (DetailDeliveryNoteVO)this.headerFormPanel.getVOModel().getValueObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("COMPANY_CODE", vo.getCompanyCodeSys01DOC08());
        params.put("DOC_TYPE", vo.getDocTypeDOC08());
        params.put("DOC_YEAR", vo.getDocYearDOC08());
        params.put("DOC_NUMBER", vo.getDocNumberDOC08());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01DOC08());
        map.put("FUNCTION_CODE_SYS06", this.headerFormPanel.getFunctionId());
        map.put("EXPORT_PARAMS", params);
        Response res = ClientUtils.getData((String)"getJasperReport", map);
        if (!res.isError()) {
            JasperPrint print = (JasperPrint)((VOResponse)res).getVo();
            JRViewer viewer = new JRViewer(print);
            JFrame frame = new JFrame();
            frame.setSize(MDIFrame.getInstance().getSize());
            frame.setContentPane((Container)viewer);
            frame.setTitle(this.getTitle());
            frame.setIconImage(MDIFrame.getInstance().getIconImage());
            frame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("print document"), 0);
        }
    }

    public void setButtonsEnabled(boolean enabled) {
        this.rowsPanel.setButtonsEnabled(enabled);
    }
}

