/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.movements.client;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.warehouse.documents.client.SerialNumberDialog;
import org.jallinone.warehouse.movements.client.ManualMovementDetailFrame;
import org.jallinone.warehouse.tables.movements.java.MovementVO;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ManualMovementController
extends CompanyFormController {
    private ManualMovementDetailFrame detailFrame = new ManualMovementDetailFrame(this);

    public ManualMovementController() {
        MDIFrame.add((InternalFrame)this.detailFrame);
    }

    public void afterInsertData() {
        this.detailFrame.getManualMovForm().insert();
        JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource("manual movement correctly inserted"), ClientSettings.getInstance().getResources().getResource("manual movement"), 1);
        this.detailFrame.initControls();
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        if (this.detailFrame.isSerialNumbersRequired() && !this.promptSerialNumbers((MovementVO)newPersistentObject)) {
            return new ErrorResponse("insert not allowed until serial numbers are not defined");
        }
        return ClientUtils.getData((String)"insertManualMovement", (Object)newPersistentObject);
    }

    private boolean promptSerialNumbers(MovementVO vo) {
        ArrayList list = new ArrayList(vo.getDeltaQtyWAR02().intValue());
        vo.setSerialNumbers(list);
        list = new ArrayList(vo.getDeltaQtyWAR02().intValue());
        vo.setBarCodes(list);
        SerialNumberDialog d = new SerialNumberDialog(vo.getSerialNumbers(), vo.getBarCodes(), vo.getItemCodeItm01WAR02() + " - " + vo.getItemDescriptionSYS10());
        return true;
    }
}

