/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.servlet;

import com.sun.javaws.servlet.DownloadRequest;
import com.sun.javaws.servlet.DownloadResponse;
import com.sun.javaws.servlet.ErrorResponseException;
import com.sun.javaws.servlet.JarDiffHandler;
import com.sun.javaws.servlet.JnlpFileHandler;
import com.sun.javaws.servlet.JnlpResource;
import com.sun.javaws.servlet.Logger;
import com.sun.javaws.servlet.ResourceCatalog;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JnlpDownloadServlet
extends HttpServlet {
    private static ResourceBundle _resourceBundle = null;
    private static final String PARAM_JNLP_EXTENSION = "jnlp-extension";
    private static final String PARAM_JAR_EXTENSION = "jar-extension";
    private Logger _log = null;
    private JnlpFileHandler _jnlpFileHandler = null;
    private JarDiffHandler _jarDiffHandler = null;
    private ResourceCatalog _resourceCatalog = null;

    private DownloadResponse constructResponse(JnlpResource jnlpResource, DownloadRequest downloadRequest) throws IOException {
        DownloadResponse downloadResponse;
        String string = jnlpResource.getPath();
        if (jnlpResource.isJnlpFile()) {
            return this._jnlpFileHandler.getJnlpFile(jnlpResource, downloadRequest);
        }
        if (downloadRequest.getCurrentVersionId() != null && jnlpResource.isJarFile() && (downloadResponse = this._jarDiffHandler.getJarDiffEntry(this._resourceCatalog, downloadRequest, jnlpResource)) != null) {
            this._log.addInformational("servlet.log.info.jardiff.response");
            return downloadResponse;
        }
        return DownloadResponse.getFileDownloadResponse(jnlpResource.getResource(), jnlpResource.getMimeType(), jnlpResource.getLastModified(), jnlpResource.getReturnVersionId());
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequest(httpServletRequest, httpServletResponse);
    }

    public static synchronized ResourceBundle getResourceBundle() {
        if (_resourceBundle == null) {
            _resourceBundle = ResourceBundle.getBundle("com/sun/javaws/servlet/resources/strings");
        }
        return _resourceBundle;
    }

    private JnlpResource handleBasicDownload(DownloadRequest downloadRequest) throws ErrorResponseException, IOException {
        this._log.addDebug("Basic Protocol lookup");
        if (downloadRequest.getPath() == null || downloadRequest.getPath().endsWith("/")) {
            throw new ErrorResponseException(DownloadResponse.getNoContentResponse());
        }
        JnlpResource jnlpResource = new JnlpResource(this.getServletContext(), downloadRequest.getPath());
        if (!jnlpResource.exists()) {
            throw new ErrorResponseException(DownloadResponse.getNoContentResponse());
        }
        return jnlpResource;
    }

    private void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getRequestURI();
        if (httpServletRequest.getQueryString() != null) {
            string = String.valueOf(string) + "?" + httpServletRequest.getQueryString().trim();
        }
        DownloadRequest downloadRequest = new DownloadRequest(this.getServletContext(), httpServletRequest);
        if (this._log.isInformationalLevel()) {
            this._log.addInformational("servlet.log.info.request", string);
            this._log.addInformational("servlet.log.info.useragent", httpServletRequest.getHeader("User-Agent"));
        }
        if (this._log.isDebugLevel()) {
            this._log.addDebug(downloadRequest.toString());
        }
        try {
            this.validateRequest(downloadRequest);
            JnlpResource jnlpResource = this.locateResource(downloadRequest);
            this._log.addDebug("JnlpResource: " + jnlpResource);
            if (this._log.isInformationalLevel()) {
                this._log.addInformational("servlet.log.info.goodrequest", jnlpResource.getPath());
            }
            DownloadResponse downloadResponse = this.constructResponse(jnlpResource, downloadRequest);
            downloadResponse.sendRespond(httpServletResponse);
        }
        catch (ErrorResponseException errorResponseException) {
            if (this._log.isInformationalLevel()) {
                this._log.addInformational("servlet.log.info.badrequest", string);
            }
            if (this._log.isDebugLevel()) {
                this._log.addDebug("Response: " + errorResponseException.toString());
            }
            errorResponseException.getDownloadResponse().sendRespond(httpServletResponse);
        }
        catch (Throwable throwable) {
            this._log.addFatal("servlet.log.fatal.internalerror", throwable);
            httpServletResponse.sendError(500);
        }
    }

    private JnlpResource handleVersionRequest(DownloadRequest downloadRequest) throws IOException, ErrorResponseException {
        this._log.addDebug("Version-based/Extension based lookup");
        return this._resourceCatalog.lookupResource(downloadRequest);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._log = new Logger(servletConfig, JnlpDownloadServlet.getResourceBundle());
        this._log.addDebug("Initializing");
        JnlpResource.setDefaultExtensions(servletConfig.getInitParameter(PARAM_JNLP_EXTENSION), servletConfig.getInitParameter(PARAM_JAR_EXTENSION));
        this._jnlpFileHandler = new JnlpFileHandler(servletConfig.getServletContext(), this._log);
        this._jarDiffHandler = new JarDiffHandler(servletConfig.getServletContext(), this._log);
        this._resourceCatalog = new ResourceCatalog(servletConfig.getServletContext(), this._log);
    }

    private JnlpResource locateResource(DownloadRequest downloadRequest) throws IOException, ErrorResponseException {
        if (downloadRequest.getVersion() == null) {
            return this.handleBasicDownload(downloadRequest);
        }
        return this.handleVersionRequest(downloadRequest);
    }

    private void validateRequest(DownloadRequest downloadRequest) throws ErrorResponseException {
        String string = downloadRequest.getPath();
        if (string.endsWith("version.xml") || string.indexOf("__") != -1) {
            throw new ErrorResponseException(DownloadResponse.getNoContentResponse());
        }
    }
}

