/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.accounts.client;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jallinone.accounting.accounts.client.AccountsGridFrame;
import org.jallinone.accounting.accounts.java.AccountVO;
import org.jallinone.commons.client.CompanyGridController;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class AccountsController
extends CompanyGridController {
    private AccountsGridFrame gridFrame = new AccountsGridFrame(this);

    public AccountsController(String companyCodeSys01ACC01, String ledgerCode) {
        MDIFrame.add((InternalFrame)this.gridFrame);
        if (companyCodeSys01ACC01 != null && ledgerCode != null) {
            this.gridFrame.getControlCompaniesCombo().setValue((Object)companyCodeSys01ACC01);
            this.gridFrame.getControlLedgerCode().setValue((Object)ledgerCode);
            this.gridFrame.getControlLedgerCode().getLookupController().forceValidate();
        }
    }

    public AccountsController() {
        this(null, null);
    }

    public boolean beforeInsertGrid(GridControl grid) {
        boolean ok = super.beforeInsertGrid(grid);
        if (!ok) {
            return ok;
        }
        if (this.gridFrame.getControlCompaniesCombo().getValue() == null || this.gridFrame.getControlLedgerCode().getValue() == null || this.gridFrame.getControlLedgerCode().getValue().equals("")) {
            JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource("insert not allowed"), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return false;
        }
        return true;
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        AccountVO vo = (AccountVO)valueObject;
        vo.setCompanyCodeSys01ACC02(this.gridFrame.getControlCompaniesCombo().getValue().toString());
        vo.setLedgerCodeAcc01ACC02(this.gridFrame.getControlLedgerCode().getValue().toString());
        vo.setLedgerDescriptionACC02(this.gridFrame.getControlLedgerDescr().getValue().toString());
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        AccountVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (AccountVO)((Object)persistentObjects.get(i));
            if (!vo.getCanDelACC02().booleanValue()) {
                return new ErrorResponse("deleting not allowed");
            }
            ++i;
        }
        return ClientUtils.getData((String)"deleteAccounts", (Object)persistentObjects);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        return ClientUtils.getData((String)"insertAccounts", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updateAccounts", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

