/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.ledger.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CustomizedColumns;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;

public class LedgerGridFrame
extends InternalFrame {
    JPanel buttonsPanel = new JPanel();
    ComboColumn colAccountType;
    TextColumn colDescr;
    TextColumn colLedger;
    ComboBoxControl controlCompaniesCombo;
    DeleteButton deleteButton;
    EditButton editButton;
    ExportButton exportButton;
    GridControl grid;
    GridBagLayout gridBagLayout1;
    private ServerGridDataLocator gridDataLocator;
    InsertButton insertButton = new InsertButton();
    LabelControl labelCompany;
    NavigatorBar navigatorBar;
    ReloadButton reloadButton = new ReloadButton();
    SaveButton saveButton;

    public LedgerGridFrame(GridController controller) {
        this.deleteButton = new DeleteButton();
        this.navigatorBar = new NavigatorBar();
        this.grid = new GridControl();
        this.editButton = new EditButton();
        this.saveButton = new SaveButton();
        this.gridDataLocator = new ServerGridDataLocator();
        this.colLedger = new TextColumn();
        this.colDescr = new TextColumn();
        this.exportButton = new ExportButton();
        this.colAccountType = new ComboColumn();
        this.gridBagLayout1 = new GridBagLayout();
        this.labelCompany = new LabelControl();
        this.controlCompaniesCombo = new ComboBoxControl();
        this.grid.setController(controller);
        this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
        this.gridDataLocator.setServerMethodName("loadLedger");
        try {
            this.jbInit();
            this.setSize(600, 500);
            this.setMinimumSize(new Dimension(600, 500));
            MDIFrame.getInstance();
            ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("ACC01");
            Domain domain = new Domain("DOMAIN_ACC01");
            int i = 0;
            while (i < companiesList.size()) {
                if (applet.getAuthorizations().getCompanyBa().isInsertEnabled("ACC01", companiesList.get(i).toString())) {
                    domain.addDomainPair(companiesList.get(i), companiesList.get(i).toString());
                }
                ++i;
            }
            this.controlCompaniesCombo.setDomain(domain);
            this.controlCompaniesCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LedgerGridFrame.this.grid.getOtherGridParams().put("COMPANY_CODE_SYS01", LedgerGridFrame.this.controlCompaniesCombo.getValue());
                    }
                }
            });
            try {
                this.controlCompaniesCombo.getComboBox().setSelectedIndex(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            CustomizedColumns cust = new CustomizedColumns(ApplicationConsts.ID_LEDGER, this.grid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ComboBoxControl getControlCompaniesCombo() {
        return this.controlCompaniesCombo;
    }

    private void jbInit() throws Exception {
        this.grid.setMaxNumberOfRowsOnInsert(50);
        this.grid.setSelectionMode(2);
        this.saveButton.setExecuteAsThread(true);
        this.grid.setValueObjectClassName("org.jallinone.accounting.ledger.java.LedgerVO");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("ledger"));
        this.buttonsPanel.setLayout(this.gridBagLayout1);
        this.grid.setDeleteButton(this.deleteButton);
        this.grid.setEditButton(this.editButton);
        this.grid.setExportButton(this.exportButton);
        this.grid.setFunctionId("ACC01");
        this.grid.setMaxSortedColumns(3);
        this.grid.setInsertButton(this.insertButton);
        this.grid.setNavBar(this.navigatorBar);
        this.grid.setReloadButton(this.reloadButton);
        this.grid.setSaveButton(this.saveButton);
        this.colLedger.setMaxCharacters(20);
        this.colLedger.setTrimText(true);
        this.colLedger.setUpperCase(true);
        this.colLedger.setColumnFilterable(true);
        this.colLedger.setColumnName("ledgerCodeACC01");
        this.colLedger.setColumnSortable(true);
        this.colLedger.setEditableOnInsert(true);
        this.colLedger.setSortVersus("ASC");
        this.colLedger.setSortingOrder(1);
        this.colDescr.setColumnFilterable(false);
        this.colDescr.setColumnName("descriptionSYS10");
        this.colDescr.setColumnSortable(true);
        this.colDescr.setEditableOnEdit(true);
        this.colDescr.setEditableOnInsert(true);
        this.colDescr.setPreferredWidth(290);
        this.colAccountType.setColumnFilterable(true);
        this.colAccountType.setColumnName("accountTypeACC01");
        this.colAccountType.setDomainId("ACCOUNT_TYPE_ACC01");
        this.colAccountType.setColumnSortable(true);
        this.colAccountType.setEditableOnEdit(false);
        this.colAccountType.setEditableOnInsert(true);
        this.colAccountType.setPreferredWidth(180);
        this.labelCompany.setText("companyCode");
        this.getContentPane().add((Component)this.buttonsPanel, "North");
        this.buttonsPanel.add((Component)this.insertButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.editButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.saveButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.reloadButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.deleteButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.exportButton, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.navigatorBar, new GridBagConstraints(6, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.labelCompany, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 5), 0, 0));
        this.buttonsPanel.add((Component)this.controlCompaniesCombo, new GridBagConstraints(3, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.getContentPane().add((Component)this.grid, "Center");
        this.grid.getColumnContainer().add((Component)this.colLedger, null);
        this.grid.getColumnContainer().add((Component)this.colDescr, null);
        this.grid.getColumnContainer().add((Component)this.colAccountType, null);
    }

    public final void reloadData() {
        this.grid.reloadData();
    }
}

