/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.movements.client;

import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jallinone.accounting.movements.client.AccountingItemNoVatFrame;
import org.jallinone.accounting.movements.java.JournalHeaderVO;
import org.jallinone.accounting.movements.java.JournalRowVO;
import org.jallinone.commons.client.CompanyFormController;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.model.client.VOListTableModel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class AccountingItemNoVatController
extends CompanyFormController {
    private AccountingItemNoVatFrame detailFrame = new AccountingItemNoVatFrame(this);

    public AccountingItemNoVatController() {
        MDIFrame.add((InternalFrame)this.detailFrame, (boolean)true);
        this.detailFrame.getHeaderPanel().insert();
        this.detailFrame.getInsertButton1().setEnabled(true);
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        JournalHeaderVO vo = (JournalHeaderVO)persistentObject;
        vo.setItemDateACC05(new java.sql.Date(System.currentTimeMillis()));
        vo.setItemYearACC05(new BigDecimal((double)(new Date().getYear() + 1900)));
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        VOListTableModel gridModel = this.detailFrame.getGrid().getVOListTableModel();
        if (gridModel.getRowCount() < 2) {
            return new ErrorResponse("you must insert al least two rows");
        }
        if (this.detailFrame.getControlSbil().getValue() != null && ((BigDecimal)this.detailFrame.getControlSbil().getValue()).doubleValue() != 0.0) {
            return new ErrorResponse("there is a lack of balance between debit and credit amounts");
        }
        JournalHeaderVO vo = (JournalHeaderVO)newPersistentObject;
        int i = 0;
        while (i < gridModel.getRowCount()) {
            vo.addJournalRow((JournalRowVO)gridModel.getObjectForRow(i));
            ++i;
        }
        Response response = ClientUtils.getData((String)"insertJournalItem", (Object)((Object)vo));
        if (!response.isError()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this.detailFrame)), ClientSettings.getInstance().getResources().getResource("item created"), ClientSettings.getInstance().getResources().getResource("new item without vat"), 1);
            this.detailFrame.closeFrame();
        }
        return response;
    }
}

