/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.movements.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.jallinone.accounting.movements.client.AccountingItemNoVatFrame;
import org.jallinone.accounting.movements.java.JournalRowVO;
import org.jallinone.commons.client.CompanyFormController;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;

public class AccountingItemNoVatGridRowController
extends CompanyFormController {
    private AccountingItemNoVatFrame frame = null;
    private ArrayList vos = null;

    public AccountingItemNoVatGridRowController(AccountingItemNoVatFrame frame, ArrayList vos) {
        this.frame = frame;
        this.vos = vos;
    }

    public void afterInsertData() {
        this.frame.getInsertButton1().setEnabled(true);
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        JournalRowVO vo = (JournalRowVO)persistentObject;
        vo.setItemYearAcc05ACC06(new BigDecimal((double)(new Date().getYear() + 1900)));
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        JournalRowVO vo = (JournalRowVO)newPersistentObject;
        if (vo.getAccountCodeACC06() == null) {
            return new ErrorResponse("you must specify a code");
        }
        if (vo.getDebitAmountACC06() == null && vo.getCreditAmountACC06() == null) {
            return new ErrorResponse("you must specify a debit or credit amount");
        }
        this.vos.add(newPersistentObject);
        this.frame.getGrid().reloadData();
        this.updateTotals();
        return new VOResponse((Object)newPersistentObject);
    }

    public void modeChanged(int currentMode) {
        if (currentMode == 1) {
            this.frame.getControlCSA().getComboBox().setSelectedIndex(-1);
        } else if (currentMode == 2) {
            this.frame.updateCodes();
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        JournalRowVO vo = (JournalRowVO)persistentObject;
        if (vo.getAccountCodeACC06() == null) {
            return new ErrorResponse("you must specify a code");
        }
        if (vo.getDebitAmountACC06() == null && vo.getCreditAmountACC06() == null) {
            return new ErrorResponse("you must specify a debit or credit amount");
        }
        this.frame.getGrid().reloadData();
        this.updateTotals();
        return new VOResponse((Object)persistentObject);
    }

    private void updateTotals() {
        JournalRowVO vo = null;
        BigDecimal d = new BigDecimal(0.0);
        BigDecimal c = new BigDecimal(0.0);
        int i = 0;
        while (i < this.vos.size()) {
            vo = (JournalRowVO)((Object)this.vos.get(i));
            if (vo.getDebitAmountACC06() != null) {
                d = d.add(vo.getDebitAmountACC06());
            }
            if (vo.getCreditAmountACC06() != null) {
                c = c.add(vo.getCreditAmountACC06());
            }
            ++i;
        }
        this.frame.getControlTotDebit().setValue((Object)d);
        this.frame.getControlTotCredit().setValue((Object)c);
        this.frame.getControlSbil().setValue((Object)d.subtract(c));
    }
}

