/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.movements.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jallinone.accounting.movements.client.AccountingItemVatFrame;
import org.jallinone.accounting.movements.java.JournalHeaderVO;
import org.jallinone.accounting.movements.java.JournalHeaderWithVatVO;
import org.jallinone.accounting.movements.java.JournalRowVO;
import org.jallinone.accounting.movements.java.JournalRowWithVatVO;
import org.jallinone.accounting.movements.java.VatRowVO;
import org.jallinone.commons.client.CompanyFormController;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.model.client.VOListTableModel;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class AccountingItemVatController
extends CompanyFormController {
    private AccountingItemVatFrame detailFrame = new AccountingItemVatFrame(this);

    public AccountingItemVatController() {
        MDIFrame.add((InternalFrame)this.detailFrame, (boolean)true);
        this.detailFrame.getHeaderPanel().insert();
        this.detailFrame.getInsertButton1().setEnabled(true);
        this.detailFrame.getcontrolCS().getComboBox().setSelectedIndex(-1);
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        JournalHeaderVO vo = (JournalHeaderVO)persistentObject;
        vo.setItemDateACC05(new Date(System.currentTimeMillis()));
        vo.setItemYearACC05(new BigDecimal((double)(new java.util.Date().getYear() + 1900)));
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        VOListTableModel gridModel = this.detailFrame.getGrid().getVOListTableModel();
        if (gridModel.getRowCount() < 1) {
            return new ErrorResponse("you must insert al least one row");
        }
        JournalHeaderWithVatVO jhVO = (JournalHeaderWithVatVO)newPersistentObject;
        jhVO.getJournalRows().clear();
        JournalRowVO jrVO = null;
        JournalRowWithVatVO rowVatVO = null;
        VatRowVO vatVO = null;
        BigDecimal vatValue = null;
        BigDecimal totalValue = new BigDecimal(0.0);
        int i = 0;
        while (i < gridModel.getRowCount()) {
            rowVatVO = (JournalRowWithVatVO)gridModel.getObjectForRow(i);
            jrVO = new JournalRowVO();
            jrVO.setCompanyCodeSys01ACC06(jhVO.getCompanyCodeSys01ACC05());
            jrVO.setAccountCodeAcc02ACC06(rowVatVO.getAccountCodeAcc02ACC06());
            jrVO.setAccountCodeACC06(rowVatVO.getAccountCodeACC06());
            jrVO.setAccountCodeTypeACC06("A");
            if (jhVO.getAccountCodeTypeACC06().equals("C")) {
                jrVO.setCreditAmountACC06(rowVatVO.getTaxableIncome().setScale(this.detailFrame.getCurrencyDecimals(), 4));
            } else {
                jrVO.setDebitAmountACC06(rowVatVO.getTaxableIncome().setScale(this.detailFrame.getCurrencyDecimals(), 4));
            }
            jrVO.setItemYearAcc05ACC06(jhVO.getItemYearACC05());
            jrVO.setDescriptionACC06(rowVatVO.getDescriptionACC06());
            jhVO.addJournalRow(jrVO);
            totalValue = totalValue.add(rowVatVO.getTaxableIncome().setScale(this.detailFrame.getCurrencyDecimals(), 4));
            vatVO = new VatRowVO();
            vatVO.setCompanyCodeSys01ACC07(jhVO.getCompanyCodeSys01ACC05());
            vatVO.setRegisterCodeAcc04ACC07(jhVO.getRegisterCodeACC04());
            vatVO.setTaxableIncomeACC07(rowVatVO.getTaxableIncome().setScale(this.detailFrame.getCurrencyDecimals(), 4));
            vatVO.setVatCodeACC07(rowVatVO.getVatCodeREG01());
            vatVO.setVatDateACC07(new Date(System.currentTimeMillis()));
            vatVO.setVatDescriptionACC07(rowVatVO.getVatDescriptionREG01());
            vatValue = rowVatVO.getTaxableIncome().multiply(new BigDecimal(rowVatVO.getValueREG01().doubleValue() / 100.0 * (100.0 - rowVatVO.getDeductibleREG01().doubleValue()) / 100.0)).setScale(this.detailFrame.getCurrencyDecimals(), 4);
            vatVO.setVatValueACC07(vatValue);
            vatVO.setVatYearACC07(new BigDecimal((double)Calendar.getInstance().get(1)));
            jhVO.addVat(vatVO);
            totalValue = totalValue.add(vatValue);
            jrVO = new JournalRowVO();
            jrVO.setCompanyCodeSys01ACC06(jhVO.getCompanyCodeSys01ACC05());
            jrVO.setAccountCodeAcc02ACC06(jhVO.getAccountCodeAcc02ACC04());
            jrVO.setAccountCodeACC06(jhVO.getAccountCodeAcc02ACC04());
            jrVO.setAccountCodeTypeACC06("A");
            if (jhVO.getAccountCodeTypeACC06().equals("C")) {
                jrVO.setCreditAmountACC06(vatValue);
            } else {
                jrVO.setDebitAmountACC06(vatValue);
            }
            jrVO.setDescriptionACC06("");
            jrVO.setItemYearAcc05ACC06(jhVO.getItemYearACC05());
            jhVO.addJournalRow(jrVO);
            jrVO = new JournalRowVO();
            jrVO.setCompanyCodeSys01ACC06(jhVO.getCompanyCodeSys01ACC05());
            if (jhVO.getAccountCodeTypeACC06().equals("C")) {
                jrVO.setAccountCodeAcc02ACC06(jhVO.getCreditAccountCodeAcc02SAL07());
                jrVO.setAccountCodeACC06(jhVO.getCustomerCodeSAL07());
                jrVO.setAccountCodeTypeACC06("C");
                jrVO.setDebitAmountACC06(rowVatVO.getTaxableIncome().add(vatValue).setScale(this.detailFrame.getCurrencyDecimals(), 4));
            } else {
                jrVO.setAccountCodeAcc02ACC06(jhVO.getDebitAccountCodeAcc02PUR01());
                jrVO.setAccountCodeACC06(jhVO.getSupplierCodePUR01());
                jrVO.setAccountCodeTypeACC06("S");
                jrVO.setCreditAmountACC06(rowVatVO.getTaxableIncome().add(vatValue).setScale(this.detailFrame.getCurrencyDecimals(), 4));
            }
            jrVO.setDescriptionACC06("");
            jrVO.setItemYearAcc05ACC06(jhVO.getItemYearACC05());
            jhVO.addJournalRow(jrVO);
            ++i;
        }
        jhVO.setTotalValue(totalValue);
        Response response = ClientUtils.getData((String)"insertJournalItem", (Object)((Object)jhVO));
        if (!response.isError()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this.detailFrame)), ClientSettings.getInstance().getResources().getResource("item created"), ClientSettings.getInstance().getResources().getResource("new item with vat"), 1);
            this.detailFrame.closeFrame();
        }
        return response;
    }
}

