/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.accounting.movements.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import org.jallinone.accounting.movements.client.DebitCreditFilterFrame_printButton_actionAdapter;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class DebitCreditFilterFrame
extends InternalFrame {
    JPanel buttonsPanel;
    ComboBoxControl controlCompaniesCombo;
    DateControl controlFromDate;
    DateControl controlToDate;
    GridBagLayout gridBagLayout1;
    LabelControl labelCompanyCode;
    LabelControl labelFromDate;
    LabelControl labelToDate;
    JPanel mainPanel = new JPanel();
    GenericButton printButton;

    public DebitCreditFilterFrame() {
        this.buttonsPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.labelFromDate = new LabelControl();
        this.labelToDate = new LabelControl();
        this.controlFromDate = new DateControl();
        this.controlToDate = new DateControl();
        this.printButton = new GenericButton(new ImageIcon(ClientUtils.getImage((String)"printer.gif")));
        this.labelCompanyCode = new LabelControl();
        this.controlCompaniesCombo = new ComboBoxControl();
        try {
            this.jbInit();
            MDIFrame.getInstance();
            ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("ACC06_DEBIT_CREDIT");
            Domain domain = new Domain("DOMAIN_ACC06_DEBIT_CREDIT");
            int i = 0;
            while (i < companiesList.size()) {
                if (applet.getAuthorizations().getCompanyBa().isInsertEnabled("ACC06_DEBIT_CREDIT", companiesList.get(i).toString())) {
                    domain.addDomainPair(companiesList.get(i), companiesList.get(i).toString());
                }
                ++i;
            }
            this.controlCompaniesCombo.setDomain(domain);
            this.controlCompaniesCombo.getComboBox().setSelectedIndex(0);
            this.setSize(400, 200);
            MDIFrame.getInstance();
            MDIFrame.add((InternalFrame)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.printButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("print debit/credit"));
        this.printButton.addActionListener((ActionListener)new DebitCreditFilterFrame_printButton_actionAdapter(this));
        this.controlCompaniesCombo.setAttributeName("companyCodeSys01WAR01");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("print debit/credit"));
        this.buttonsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.labelFromDate.setText("from date");
        this.labelToDate.setText("to date");
        this.labelCompanyCode.setText("companyCodeSys01WAR01");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.buttonsPanel.add((Component)this.printButton, null);
        this.mainPanel.add((Component)this.labelCompanyCode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.labelFromDate, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.labelToDate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.controlCompaniesCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.controlFromDate, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.controlToDate, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(2, 0);
        this.controlFromDate.setValue((Object)cal.getTime());
        this.controlToDate.setValue((Object)new Date());
    }

    void printButton_actionPerformed(ActionEvent e) {
        if (this.controlFromDate.getValue() == null || this.controlToDate.getValue() == null) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("please set a from/to date"), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return;
        }
        if (this.controlCompaniesCombo.getValue() == null) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("please select a company"), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("COMPANY_CODE", this.controlCompaniesCombo.getValue());
        params.put("START_DATE", this.controlFromDate.getValue());
        params.put("END_DATE", this.controlToDate.getValue());
        params.put("ACCOUNT_TYPE", "P");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("COMPANY_CODE_SYS01", this.controlCompaniesCombo.getValue());
        map.put("FUNCTION_CODE_SYS06", "ACC06_DEBIT_CREDIT");
        map.put("EXPORT_PARAMS", params);
        Response res = ClientUtils.getData((String)"getJasperReport", map);
        if (!res.isError()) {
            JasperPrint print = (JasperPrint)((VOResponse)res).getVo();
            JRViewer viewer = new JRViewer(print);
            JFrame frame = new JFrame();
            frame.setSize(MDIFrame.getInstance().getSize());
            frame.setContentPane((Container)viewer);
            frame.setTitle(this.getTitle());
            frame.setIconImage(MDIFrame.getInstance().getIconImage());
            frame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("print debit/credit"), 0);
        }
    }
}

