/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.commons.client;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import netscape.javascript.JSObject;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.startup.client.StartupFrame;
import org.jallinone.system.java.ApplicationParametersVO;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.internationalization.java.ResourcesFactory;
import org.openswing.swing.internationalization.java.XMLResourcesFactory;
import org.openswing.swing.mdi.client.ClientFacade;
import org.openswing.swing.mdi.client.Clock;
import org.openswing.swing.mdi.client.GenericStatusPanel;
import org.openswing.swing.mdi.client.MDIController;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.TextResponse;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.permissions.client.LoginController;
import org.openswing.swing.permissions.client.LoginDialog;
import org.openswing.swing.table.profiles.client.FileGridProfileManager;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ClientApplet
extends ClientUtils
implements MDIController,
LoginController {
    protected ApplicationParametersVO authorizations = null;
    protected boolean calledAsApplet = true;
    private ApplicationClientFacade clientFacade = new ApplicationClientFacade(this);
    protected Hashtable domains = new Hashtable();
    protected String username = null;

    public void afterMDIcreation(MDIFrame frame) {
        Domain rolesDomain = new Domain("USERROLES");
        Enumeration en = this.authorizations.getUserRoles().keys();
        Object progressiveSYS04 = null;
        while (en.hasMoreElements()) {
            progressiveSYS04 = en.nextElement();
            rolesDomain.addDomainPair(progressiveSYS04, this.authorizations.getUserRoles().get(progressiveSYS04).toString());
        }
        this.domains.put(rolesDomain.getDomainId(), rolesDomain);
        GenericStatusPanel userPanel = new GenericStatusPanel();
        userPanel.setColumns(12);
        MDIFrame.addStatusComponent((JComponent)userPanel);
        userPanel.setText(this.username);
        MDIFrame.addStatusComponent((JComponent)new Clock());
    }

    public boolean authenticateUser(Map loginInfo) throws Exception {
        this.username = (String)loginInfo.get("username");
        String password = (String)loginInfo.get("password");
        if (this.username == null || password == null) {
            return false;
        }
        this.username = this.username.toUpperCase();
        loginInfo.put("username", this.username);
        loginInfo.put("password", password);
        Response response = ClientUtils.getData((String)"login", (Object)new String[]{this.username, password});
        if (response.isError()) {
            throw new Exception(response.getErrorMessage());
        }
        String languageId = ((TextResponse)response).getMessage();
        response = ClientUtils.getData((String)"getUserAuthorizations", (Object)new Object[0]);
        if (response.isError()) {
            throw new Exception(response.getErrorMessage());
        }
        this.authorizations = (ApplicationParametersVO)((Object)((VOResponse)response).getVo());
        Hashtable<String, String> xmlFiles = new Hashtable<String, String>();
        xmlFiles.put("EN", "Resources_en.xml");
        xmlFiles.put("IT", "Resources_it.xml");
        xmlFiles.put("ES", "Resources_es.xml");
        ClientSettings clientSettings = new ClientSettings((ResourcesFactory)new XMLResourcesFactory(xmlFiles, false), this.domains, this.authorizations.getBa(), true);
        ClientSettings.GRID_ACTIVE_CELL_BACKGROUND = new Color(205, 239, 255);
        ClientSettings.GRID_SELECTION_BACKGROUND = new Color(195, 229, 254);
        ClientSettings.PERC_TREE_FOLDER = "folder3.gif";
        ClientSettings.BACKGROUND = "background4.jpg";
        ClientSettings.TREE_BACK = "treeback2.jpg";
        ClientSettings.ICON_FILENAME = "appicon1.gif";
        ClientSettings.VIEW_BACKGROUND_SEL_COLOR = true;
        ClientSettings.VIEW_MANDATORY_SYMBOL = true;
        ClientSettings.LOCK_OFF = "unlock.gif";
        ClientSettings.LOCK_ON = "lock.gif";
        ClientSettings.FILTER_PANEL_ON_GRID = true;
        ClientSettings.GRID_PROFILE_MANAGER = new FileGridProfileManager();
        ClientSettings.ON_INVALID_CODE = 1;
        ClientSettings.FORCE_FOCUS_ON_LOOKUP_CONTROL = true;
        ClientSettings.ASK_BEFORE_CLOSE = true;
        ClientSettings.SHOW_FILTERING_CONDITIONS_IN_EXPORT = true;
        ClientSettings.SHOW_SORTING_ORDER = true;
        ClientSettings.LOOKUP_AUTO_COMPLETITION_WAIT_TIME = 1500L;
        ClientSettings.SHOW_FRAME_TITLE_IN_EXPORT = true;
        ClientSettings.getInstance().setLanguage(languageId);
        return true;
    }

    public String getAboutImage() {
        return "jAllInOne.jpg";
    }

    public String getAboutText() {
        return "JAllInOne ERP/CRM Application\n\nCopyright: Copyright (C) 2006 Mauro Carniel\nAuthor: Mauro Carniel\nDatabase release: 0.9.0.7\n\nThis application is free software; you can redistribute it and/or\nmodify it under the terms of the (LGPL) Lesser General Public\nLicense as published by the Free Software Foundation;\n\n                GNU LESSER GENERAL PUBLIC LICENSE\n                   Version 2.1, February 1999\n\nThis application is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\nLibrary General Public License for more details.\n";
    }

    public DefaultTreeModel getApplicationFunctions() {
        if (!this.authorizations.getLanguageId().equals(ClientSettings.getInstance().getResources().getLanguageId())) {
            Response response = ClientUtils.getData((String)"getUserAuthorizations", (Object)new Object[0]);
            if (response.isError()) {
                JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), response.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
            } else {
                this.authorizations = (ApplicationParametersVO)((Object)((VOResponse)response).getVo());
            }
        }
        return this.authorizations.getAppMenu();
    }

    public final ApplicationParametersVO getAuthorizations() {
        return this.authorizations;
    }

    public ClientFacade getClientFacade() {
        return this.clientFacade;
    }

    public int getExtendedState() {
        return 6;
    }

    public ArrayList getLanguages() {
        Response response = ClientUtils.getData((String)"getLanguages", (Object)new Object[0]);
        if (response.isError()) {
            JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), response.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
            return new ArrayList();
        }
        return new ArrayList(((VOListResponse)response).getRows());
    }

    public String getMDIFrameTitle() {
        return "JAllInOne";
    }

    public int getMaxAttempts() {
        return 3;
    }

    public final String getUsername() {
        return this.username;
    }

    protected void initApplication() {
        this.loadDomains();
        VOResponse response = null;
        try {
            response = (VOResponse)ClientUtils.getData((String)"databaseAlreadyExixts", (Object)new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (response.isError()) {
            JOptionPane.showMessageDialog(null, response.getErrorMessage(), "Error on checking database", 0);
            return;
        }
        if (((Boolean)response.getVo()).booleanValue()) {
            LoginDialog d = new LoginDialog(null, false, (LoginController)this);
        } else {
            new StartupFrame(this);
        }
    }

    protected void loadDomains() {
        Domain colTypeSYS12Domain = new Domain("COLUMN_TYPE");
        colTypeSYS12Domain.addDomainPair((Object)"S", "text");
        colTypeSYS12Domain.addDomainPair((Object)"D", "date");
        colTypeSYS12Domain.addDomainPair((Object)"N", "numeric");
        this.domains.put(colTypeSYS12Domain.getDomainId(), colTypeSYS12Domain);
        Domain languagesDomain = new Domain("LANGUAGES");
        languagesDomain.addDomainPair((Object)"EN", "english");
        languagesDomain.addDomainPair((Object)"IT", "italian");
        languagesDomain.addDomainPair((Object)"ES", "spanish");
        this.domains.put(languagesDomain.getDomainId(), languagesDomain);
        Domain subjectTypeDomain = new Domain("SUBJECT_TYPE");
        subjectTypeDomain.addDomainPair((Object)"M", "organization");
        subjectTypeDomain.addDomainPair((Object)"O", "organization contact");
        subjectTypeDomain.addDomainPair((Object)"C", "organization customer");
        subjectTypeDomain.addDomainPair((Object)"N", "private contact");
        subjectTypeDomain.addDomainPair((Object)"P", "private customer");
        subjectTypeDomain.addDomainPair((Object)"S", "supplier");
        this.domains.put(subjectTypeDomain.getDomainId(), subjectTypeDomain);
        Domain customerTypeDomain = new Domain("CUSTOMER_TYPE");
        customerTypeDomain.addDomainPair((Object)"C", "organization");
        customerTypeDomain.addDomainPair((Object)"P", "private");
        this.domains.put(customerTypeDomain.getDomainId(), customerTypeDomain);
        Domain contactTypeDomain = new Domain("CONTACT_TYPE");
        contactTypeDomain.addDomainPair((Object)"O", "organization");
        contactTypeDomain.addDomainPair((Object)"N", "private");
        this.domains.put(contactTypeDomain.getDomainId(), contactTypeDomain);
        Domain sexDomain = new Domain("SEX");
        sexDomain.addDomainPair((Object)"M", "male");
        sexDomain.addDomainPair((Object)"F", "female");
        this.domains.put(sexDomain.getDomainId(), sexDomain);
        Domain startDaysDomain = new Domain("START_DAY");
        startDaysDomain.addDomainPair((Object)"M", "end month");
        startDaysDomain.addDomainPair((Object)"I", "invoice date");
        this.domains.put(startDaysDomain.getDomainId(), startDaysDomain);
        Domain refDomain = new Domain("REFERENCE_TYPE");
        refDomain.addDomainPair((Object)"P", "phone");
        refDomain.addDomainPair((Object)"M", "mobile");
        refDomain.addDomainPair((Object)"F", "fax");
        refDomain.addDomainPair((Object)"W", "webSite");
        refDomain.addDomainPair((Object)"E", "email");
        refDomain.addDomainPair((Object)"I", "officeNr");
        refDomain.addDomainPair((Object)"O", "otherRef");
        this.domains.put(refDomain.getDomainId(), refDomain);
        Domain purchaseDocStateDomain = new Domain("DOC06_STATES");
        purchaseDocStateDomain.addDomainPair((Object)"O", "opened");
        purchaseDocStateDomain.addDomainPair((Object)"B", "header blocked");
        purchaseDocStateDomain.addDomainPair((Object)"C", "confirmed");
        purchaseDocStateDomain.addDomainPair((Object)"D", "closed");
        this.domains.put(purchaseDocStateDomain.getDomainId(), purchaseDocStateDomain);
        Domain deliveryNotesStateDomain = new Domain("DOC08_STATES");
        deliveryNotesStateDomain.addDomainPair((Object)"O", "opened");
        deliveryNotesStateDomain.addDomainPair((Object)"B", "header blocked");
        deliveryNotesStateDomain.addDomainPair((Object)"D", "closed");
        this.domains.put(deliveryNotesStateDomain.getDomainId(), deliveryNotesStateDomain);
        Domain docTypeDomain = new Domain("DOC_TYPE");
        docTypeDomain.addDomainPair((Object)"V", "purchase invoice");
        docTypeDomain.addDomainPair((Object)"L", "purchase invoice from delivery notes");
        docTypeDomain.addDomainPair((Object)"U", "purchase invoice from purchase document");
        docTypeDomain.addDomainPair((Object)"B", "debiting note");
        docTypeDomain.addDomainPair((Object)"H", "purchase generic document");
        docTypeDomain.addDomainPair((Object)"I", "sale invoice");
        docTypeDomain.addDomainPair((Object)"N", "sale invoice from delivery notes");
        docTypeDomain.addDomainPair((Object)"S", "sale invoice from sale document");
        docTypeDomain.addDomainPair((Object)"R", "credit note");
        docTypeDomain.addDomainPair((Object)"A", "sale generic document");
        this.domains.put(docTypeDomain.getDomainId(), docTypeDomain);
        Domain warItemTypeDomain = new Domain("WAR_ITEM_TYPE");
        warItemTypeDomain.addDomainPair((Object)"G", "good item");
        warItemTypeDomain.addDomainPair((Object)"D", "damaged item");
        this.domains.put(warItemTypeDomain.getDomainId(), warItemTypeDomain);
        Domain warQtySignDomain = new Domain("WAR_QTY_SIGN");
        warQtySignDomain.addDomainPair((Object)"+", "add");
        warQtySignDomain.addDomainPair((Object)"-", "substract");
        this.domains.put(warQtySignDomain.getDomainId(), warQtySignDomain);
        Domain saleDocStateDomain = new Domain("DOC01_STATES");
        saleDocStateDomain.addDomainPair((Object)"O", "opened");
        saleDocStateDomain.addDomainPair((Object)"B", "header blocked");
        saleDocStateDomain.addDomainPair((Object)"C", "confirmed");
        saleDocStateDomain.addDomainPair((Object)"D", "closed");
        this.domains.put(saleDocStateDomain.getDomainId(), saleDocStateDomain);
        Domain saleDocTypeDomain = new Domain("SALE_DOC_TYPE");
        saleDocTypeDomain.addDomainPair((Object)"O", "sale order");
        saleDocTypeDomain.addDomainPair((Object)"C", "sale contract");
        saleDocTypeDomain.addDomainPair((Object)"D", "desk selling");
        this.domains.put(saleDocTypeDomain.getDomainId(), saleDocTypeDomain);
        Domain invoiceDocTypeDomain = new Domain("INVOICE_TYPE");
        invoiceDocTypeDomain.addDomainPair((Object)"I", "manually created");
        invoiceDocTypeDomain.addDomainPair((Object)"N", "from deliv.note");
        invoiceDocTypeDomain.addDomainPair((Object)"S", "from sale doc.");
        this.domains.put(invoiceDocTypeDomain.getDomainId(), invoiceDocTypeDomain);
        Domain purInvoiceDocTypeDomain = new Domain("PURCHASE_INVOICE_TYPE");
        purInvoiceDocTypeDomain.addDomainPair((Object)"V", "manually created");
        purInvoiceDocTypeDomain.addDomainPair((Object)"L", "from deliv.note");
        purInvoiceDocTypeDomain.addDomainPair((Object)"U", "from purchase doc.");
        this.domains.put(purInvoiceDocTypeDomain.getDomainId(), purInvoiceDocTypeDomain);
        Domain accountTypeACC01Domain = new Domain("ACCOUNT_TYPE_ACC01");
        accountTypeACC01Domain.addDomainPair((Object)"P", "patrimonial");
        accountTypeACC01Domain.addDomainPair((Object)"E", "economic");
        this.domains.put(accountTypeACC01Domain.getDomainId(), accountTypeACC01Domain);
        Domain regTypeACC04Domain = new Domain("REGISTER_TYPE_ACC04");
        regTypeACC04Domain.addDomainPair((Object)"1", "selling");
        regTypeACC04Domain.addDomainPair((Object)"2", "retail");
        regTypeACC04Domain.addDomainPair((Object)"3", "purchase");
        regTypeACC04Domain.addDomainPair((Object)"4", "intracom. on selling");
        regTypeACC04Domain.addDomainPair((Object)"5", "intracom. on purchase");
        this.domains.put(regTypeACC04Domain.getDomainId(), regTypeACC04Domain);
        Domain accountTypeACC02Domain = new Domain("ACCOUNT_TYPE_ACC02");
        accountTypeACC02Domain.addDomainPair((Object)"D", "debits/proceedings");
        accountTypeACC02Domain.addDomainPair((Object)"C", "credits/costs");
        this.domains.put(accountTypeACC02Domain.getDomainId(), accountTypeACC02Domain);
        Domain accountCodeTypeACC05Domain = new Domain("ACCOUNT_CODE_TYPE_ACC05");
        accountCodeTypeACC05Domain.addDomainPair((Object)"A", "account");
        accountCodeTypeACC05Domain.addDomainPair((Object)"C", "customer");
        accountCodeTypeACC05Domain.addDomainPair((Object)"S", "supplier");
        this.domains.put(accountCodeTypeACC05Domain.getDomainId(), accountCodeTypeACC05Domain);
        Domain accountCodeTypeCSACC05Domain = new Domain("ACCOUNT_CODE_TYPE_CS_ACC05");
        accountCodeTypeCSACC05Domain.addDomainPair((Object)"C", "customer");
        accountCodeTypeCSACC05Domain.addDomainPair((Object)"S", "supplier");
        this.domains.put(accountCodeTypeCSACC05Domain.getDomainId(), accountCodeTypeCSACC05Domain);
        Domain dayOfWeekDomain = new Domain("DAY_OF_WEEK");
        dayOfWeekDomain.addDomainPair((Object)String.valueOf(1), "sunday");
        dayOfWeekDomain.addDomainPair((Object)String.valueOf(2), "monday");
        dayOfWeekDomain.addDomainPair((Object)String.valueOf(3), "tuesday");
        dayOfWeekDomain.addDomainPair((Object)String.valueOf(4), "wednesday");
        dayOfWeekDomain.addDomainPair((Object)String.valueOf(5), "thursday");
        dayOfWeekDomain.addDomainPair((Object)String.valueOf(6), "friday");
        dayOfWeekDomain.addDomainPair((Object)String.valueOf(7), "saturday");
        this.domains.put(dayOfWeekDomain.getDomainId(), dayOfWeekDomain);
        Domain callOutStateDomain = new Domain("CALL_OUT_STATE");
        callOutStateDomain.addDomainPair((Object)"O", "opened");
        callOutStateDomain.addDomainPair((Object)"B", "header blocked");
        callOutStateDomain.addDomainPair((Object)"D", "closed");
        callOutStateDomain.addDomainPair((Object)"I", "invoiced");
        this.domains.put(callOutStateDomain.getDomainId(), callOutStateDomain);
        Domain subjectType2Domain = new Domain("SUBJECT_TYPE_2");
        subjectType2Domain.addDomainPair((Object)"A", "organization");
        subjectType2Domain.addDomainPair((Object)"B", "private");
        this.domains.put(subjectType2Domain.getDomainId(), subjectType2Domain);
        Domain actPriorityDomain = new Domain("ACTIVITY_PRIORITY");
        actPriorityDomain.addDomainPair((Object)"V", "highest");
        actPriorityDomain.addDomainPair((Object)"H", "high");
        actPriorityDomain.addDomainPair((Object)"N", "normal");
        actPriorityDomain.addDomainPair((Object)"L", "low");
        actPriorityDomain.addDomainPair((Object)"T", "trivial");
        this.domains.put(actPriorityDomain.getDomainId(), actPriorityDomain);
        Domain actTypeDomain = new Domain("ACTIVITY_TYPE");
        actTypeDomain.addDomainPair((Object)"T", "generic task");
        actTypeDomain.addDomainPair((Object)"A", "appointment");
        actTypeDomain.addDomainPair((Object)"C", "call-out");
        actTypeDomain.addDomainPair((Object)"E", "send email");
        actTypeDomain.addDomainPair((Object)"F", "send fax");
        actTypeDomain.addDomainPair((Object)"M", "meeting");
        actTypeDomain.addDomainPair((Object)"P", "telephone call");
        actTypeDomain.addDomainPair((Object)"B", "absence");
        actTypeDomain.addDomainPair((Object)"H", "holiday");
        actTypeDomain.addDomainPair((Object)"I", "illness");
        this.domains.put(actTypeDomain.getDomainId(), actTypeDomain);
        Domain actTypeDomainNoCallOut = new Domain("ACTIVITY_TYPE_NO_CALL_OUT");
        actTypeDomainNoCallOut.addDomainPair((Object)"T", "generic task");
        actTypeDomainNoCallOut.addDomainPair((Object)"A", "appointment");
        actTypeDomainNoCallOut.addDomainPair((Object)"E", "send email");
        actTypeDomainNoCallOut.addDomainPair((Object)"F", "send fax");
        actTypeDomainNoCallOut.addDomainPair((Object)"M", "meeting");
        actTypeDomainNoCallOut.addDomainPair((Object)"P", "telephone call");
        actTypeDomainNoCallOut.addDomainPair((Object)"B", "absence");
        actTypeDomainNoCallOut.addDomainPair((Object)"H", "holiday");
        actTypeDomainNoCallOut.addDomainPair((Object)"I", "illness");
        this.domains.put(actTypeDomainNoCallOut.getDomainId(), actTypeDomainNoCallOut);
        Domain actStateDomain = new Domain("ACTIVITY_STATE");
        actStateDomain.addDomainPair((Object)"O", "opened");
        actStateDomain.addDomainPair((Object)"D", "closed");
        actStateDomain.addDomainPair((Object)"I", "invoiced");
        this.domains.put(actStateDomain.getDomainId(), actStateDomain);
        Domain absenceTypeDomain = new Domain("ABSENCE_TYPE");
        absenceTypeDomain.addDomainPair((Object)"B", "absence");
        absenceTypeDomain.addDomainPair((Object)"H", "holiday");
        absenceTypeDomain.addDomainPair((Object)"I", "illness");
        this.domains.put(absenceTypeDomain.getDomainId(), absenceTypeDomain);
        Domain propTypeDOC21Domain = new Domain("PROPERTY_TYPE_DOC21");
        propTypeDOC21Domain.addDomainPair((Object)"T", "text");
        propTypeDOC21Domain.addDomainPair((Object)"N", "numeric");
        propTypeDOC21Domain.addDomainPair((Object)"D", "date");
        this.domains.put(propTypeDOC21Domain.getDomainId(), propTypeDOC21Domain);
        Domain manufactureTypeDomain = new Domain("MANUFACTURE_TYPE");
        manufactureTypeDomain.addDomainPair((Object)"I", "internal");
        manufactureTypeDomain.addDomainPair((Object)"E", "external");
        this.domains.put(manufactureTypeDomain.getDomainId(), manufactureTypeDomain);
        Domain prodOrderStateDomain = new Domain("DOC22_STATES");
        prodOrderStateDomain.addDomainPair((Object)"O", "opened");
        prodOrderStateDomain.addDomainPair((Object)"B", "header blocked");
        prodOrderStateDomain.addDomainPair((Object)"C", "confirmed");
        prodOrderStateDomain.addDomainPair((Object)"D", "closed");
        this.domains.put(prodOrderStateDomain.getDomainId(), prodOrderStateDomain);
        Domain colTypeDomain = new Domain("SYS22_COL_TYPES");
        colTypeDomain.addDomainPair((Object)"N", "numeric");
        colTypeDomain.addDomainPair((Object)"T", "text");
        colTypeDomain.addDomainPair((Object)"D", "date");
        colTypeDomain.addDomainPair((Object)"E", "enumeration");
        colTypeDomain.addDomainPair((Object)"P", "progressive");
        colTypeDomain.addDomainPair((Object)"W", "where param");
        this.domains.put(colTypeDomain.getDomainId(), colTypeDomain);
    }

    public void loginSuccessful(Map loginInfo) {
        MDIFrame mdi = new MDIFrame((MDIController)this);
    }

    public void start() {
        this.calledAsApplet = true;
        this.initApplication();
    }

    public void stopApplication() {
        ClientUtils.getData((String)"closeApplication", (Object)Boolean.TRUE);
        if (this.calledAsApplet) {
            this.destroy();
            try {
                JSObject js = JSObject.getWindow((Applet)((Object)this));
                js.call("closeFrame", new Object[0]);
            }
            catch (Throwable ex) {
            }
        } else {
            System.exit(0);
        }
    }

    public boolean viewChangeLanguageInMenuBar() {
        return true;
    }

    public boolean viewFunctionsInMenuBar() {
        return true;
    }

    public boolean viewFunctionsInTreePanel() {
        return true;
    }

    public JDialog viewLoginDialog(JFrame parentFrame) {
        LoginDialog d = new LoginDialog(parentFrame, true, (LoginController)this);
        return d;
    }

    public boolean viewLoginInMenuBar() {
        return true;
    }

    public boolean viewOpenedWindowIcons() {
        return true;
    }
}

