/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.commons.client;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;
import java.util.ArrayList;
import javax.swing.JComboBox;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.domains.java.DomainPair;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.table.columns.client.ComboColumn;

public class CompaniesComboColumn
extends ComboColumn {
    private String functionCode = null;

    public CompaniesComboColumn() {
        this.setEditableOnEdit(false);
    }

    private String getCode(Domain domain, String desc) {
        DomainPair[] list = domain.getDomainPairList();
        int i = 0;
        while (i < list.length) {
            if (list[i].getDescription().equals(desc)) {
                return list[i].getCode().toString();
            }
            ++i;
        }
        return "";
    }

    public final String getFunctionCode() {
        return this.functionCode;
    }

    public final void setFunctionCode(String functionCode) {
        this.functionCode = functionCode;
        if (Beans.isDesignTime()) {
            return;
        }
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
        ArrayList companiesList = bca.getCompaniesList(functionCode);
        final Domain domain = new Domain("DOMAIN_" + functionCode);
        int i = 0;
        while (i < companiesList.size()) {
            domain.addDomainPair(companiesList.get(i), companiesList.get(i).toString());
            ++i;
        }
        super.setDomain(domain);
        super.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ((JComboBox)e.getSource()).getSelectedIndex() != -1) {
                    MDIFrame.getInstance();
                    ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
                    if (!applet.getAuthorizations().getCompanyBa().isInsertEnabled(CompaniesComboColumn.this.functionCode, CompaniesComboColumn.this.getCode(domain, e.getItem().toString()))) {
                        ((JComboBox)e.getSource()).setSelectedIndex(-1);
                    }
                }
            }
        });
        if (applet.getAuthorizations().isOneCompany() && this.getParent() != null) {
            this.getParent().remove((Component)((Object)this));
        }
    }
}

