/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.contacts.client;

import java.util.ArrayList;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.contacts.client.ContactDetailFrame;
import org.jallinone.contacts.client.ContactsGridFrame;
import org.jallinone.contacts.java.GridContactVO;
import org.jallinone.subjects.java.OrganizationVO;
import org.jallinone.subjects.java.PeopleVO;
import org.jallinone.subjects.java.Subject;
import org.jallinone.subjects.java.SubjectPK;
import org.jallinone.subjects.java.SubjectVO;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.receive.java.ValueObjectImpl;
import org.openswing.swing.util.client.ClientUtils;

public class ContactController
extends CompanyFormController {
    private ContactDetailFrame detailFrame = null;
    private ContactsGridFrame gridFrame = null;
    private SubjectPK organization = null;
    private SubjectVO subVO = null;

    public ContactController(ContactsGridFrame gridFrame, SubjectVO subVO, SubjectPK organization) {
        this.gridFrame = gridFrame;
        this.subVO = subVO;
        this.organization = organization;
        this.detailFrame = new ContactDetailFrame(this);
        MDIFrame.add((InternalFrame)this.detailFrame);
        this.detailFrame.setParentFrame(gridFrame);
        gridFrame.pushFrame(this.detailFrame);
        if (subVO != null) {
            this.detailFrame.subjectChanged(subVO.getSubjectTypeREG04());
            this.detailFrame.getCurrentForm().setMode(0);
            this.detailFrame.getCurrentForm().executeReload();
        } else {
            this.detailFrame.getCurrentForm().insert();
        }
        if (organization != null) {
            this.detailFrame.getControlSubjectType().getComboBox().setSelectedIndex(1);
        }
    }

    public ContactController(ContactsGridFrame gridFrame, SubjectVO subVO) {
        this(gridFrame, subVO, null);
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.detailFrame.getReferencesPanel().getGrid().clearData();
            this.detailFrame.getHierarchiesPanel().getGrid().clearData();
            this.detailFrame.getContactsPanel().getGrid().clearData();
            this.detailFrame.setButtonsEnabled(false);
            this.detailFrame.getTabbedPane().setEnabledAt(3, false);
            this.detailFrame.getActivitiesGrid().clearData();
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        if (applet.getAuthorizations().isOneCompany()) {
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("REG04_CONTACTS");
            ((Subject)persistentObject).setCompanyCodeSys01REG04(companiesList.get(0).toString());
        }
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<ValueObject> list = new ArrayList<ValueObject>();
        list.add(persistentObject);
        Response response = ClientUtils.getData((String)"deleteContacts", list);
        if (!response.isError()) {
            this.gridFrame.reloadData();
            this.detailFrame.getReferencesPanel().getGrid().clearData();
            this.detailFrame.getHierarchiesPanel().getGrid().clearData();
            this.detailFrame.getContactsPanel().getGrid().clearData();
            this.detailFrame.getActivitiesGrid().clearData();
        }
        return response;
    }

    public ContactsGridFrame getGridFrame() {
        return this.gridFrame;
    }

    public final SubjectPK getOrganization() {
        return this.organization;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        ValueObjectImpl vo;
        Subject sub = (Subject)newPersistentObject;
        sub.setSubjectTypeREG04((String)this.detailFrame.getControlSubjectType().getValue());
        if (sub.getSubjectTypeREG04().equals("O")) {
            vo = (OrganizationVO)sub;
            if (this.organization != null) {
                vo.setCompanyCodeSys01Reg04REG04(this.organization.getCompanyCodeSys01REG04());
                vo.setProgressiveReg04REG04(this.organization.getProgressiveREG04());
            }
        } else {
            vo = (PeopleVO)sub;
            if (this.organization != null) {
                vo.setCompanyCodeSys01Reg04REG04(this.organization.getCompanyCodeSys01REG04());
                vo.setProgressiveReg04REG04(this.organization.getProgressiveREG04());
            }
        }
        Response response = ClientUtils.getData((String)"insertContact", (Object)newPersistentObject);
        if (!response.isError()) {
            sub = (Subject)((VOResponse)response).getVo();
            this.subVO = new SubjectVO(sub.getCompanyCodeSys01REG04(), sub.getProgressiveREG04(), null, null, sub.getSubjectTypeREG04());
            SubjectPK pk = new SubjectPK(sub.getCompanyCodeSys01REG04(), sub.getProgressiveREG04());
            this.detailFrame.getReferencesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", pk);
            this.detailFrame.getReferencesPanel().getGrid().reloadData();
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", pk);
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "O");
            this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
            this.detailFrame.getContactsPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", pk);
            this.detailFrame.getContactsPanel().getGrid().reloadData();
            this.detailFrame.getActivitiesGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", pk.getCompanyCodeSys01REG04());
            this.detailFrame.getActivitiesGrid().getOtherGridParams().put("PROGRESSIVE_REG04_SUBJECT", pk.getProgressiveREG04());
            this.detailFrame.getActivitiesGrid().reloadData();
            if (this.organization != null || this.subVO.getSubjectTypeREG04().equals("N")) {
                this.detailFrame.getTabbedPane().setEnabledAt(3, false);
            } else {
                this.detailFrame.getTabbedPane().setEnabledAt(3, true);
            }
            this.detailFrame.setButtonsEnabled(true);
        }
        return response;
    }

    public Response loadData(Class valueObjectClass) {
        int row = this.gridFrame.getGrid().getSelectedRow();
        if (row != -1) {
            GridContactVO gridVO = (GridContactVO)this.gridFrame.getGrid().getVOListTableModel().getObjectForRow(row);
            this.subVO = new SubjectVO(gridVO.getCompanyCodeSys01REG04(), gridVO.getProgressiveREG04(), gridVO.getName_1REG04(), gridVO.getName_2REG04(), gridVO.getSubjectTypeREG04());
        }
        this.detailFrame.subjectChanged(this.subVO.getSubjectTypeREG04());
        return ClientUtils.getData((String)"loadContact", (Object)this.subVO);
    }

    public void loadDataCompleted(boolean error) {
        SubjectPK pk = new SubjectPK(this.subVO.getCompanyCodeSys01REG04(), this.subVO.getProgressiveREG04());
        this.detailFrame.getReferencesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", pk);
        this.detailFrame.getReferencesPanel().getGrid().reloadData();
        this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", pk);
        this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "O");
        this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
        this.detailFrame.getContactsPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", pk);
        this.detailFrame.getContactsPanel().getGrid().reloadData();
        this.detailFrame.getActivitiesGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", pk.getCompanyCodeSys01REG04());
        this.detailFrame.getActivitiesGrid().getOtherGridParams().put("PROGRESSIVE_REG04_SUBJECT", pk.getProgressiveREG04());
        this.detailFrame.getActivitiesGrid().reloadData();
        if (this.organization != null || this.subVO.getSubjectTypeREG04().equals("N")) {
            this.detailFrame.getTabbedPane().setEnabledAt(3, false);
        }
        this.detailFrame.setButtonsEnabled(true);
    }

    public void modeChanged(int currentMode) {
        if (currentMode == 1) {
            this.detailFrame.getControlSubjectType().setEnabled(true);
            if (this.organization == null) {
                this.detailFrame.getControlSubjectType().getComboBox().setSelectedIndex(0);
            } else {
                this.detailFrame.getControlSubjectType().getComboBox().setSelectedIndex(1);
            }
        } else if (currentMode == 2 || currentMode == 0) {
            this.detailFrame.getControlSubjectType().setEnabled(false);
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"updateContact", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!response.isError()) {
            // empty if block
        }
        return response;
    }
}

