/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.employees.client;

import java.math.BigDecimal;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.employees.client.EmployeeDetailFrame;
import org.jallinone.employees.client.EmployeesGridFrame;
import org.jallinone.employees.java.DetailEmployeeVO;
import org.jallinone.subjects.java.SubjectPK;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class EmployeeController
extends CompanyFormController {
    private String companyCodeSys01SCH01 = null;
    private EmployeeDetailFrame detailFrame = null;
    private EmployeesGridFrame gridFrame = null;
    private BigDecimal progressiveReg04SCH01 = null;

    public EmployeeController(EmployeesGridFrame gridFrame, String companyCodeSys01SCH01, BigDecimal progressiveReg04SCH01) {
        this.gridFrame = gridFrame;
        this.companyCodeSys01SCH01 = companyCodeSys01SCH01;
        this.progressiveReg04SCH01 = progressiveReg04SCH01;
        this.detailFrame = new EmployeeDetailFrame(this);
        MDIFrame.add((InternalFrame)this.detailFrame);
        this.detailFrame.setParentFrame(gridFrame);
        gridFrame.pushFrame(this.detailFrame);
        if (companyCodeSys01SCH01 != null && progressiveReg04SCH01 != null) {
            this.detailFrame.getForm().setMode(0);
            this.detailFrame.getForm().executeReload();
        } else {
            this.detailFrame.getForm().insert();
        }
    }

    public void afterInsertData(Form form) {
        this.detailFrame.getGrid().clearData();
        this.detailFrame.getAbsGrid().clearData();
        this.detailFrame.getHierarchiesPanel().getGrid().clearData();
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        DetailEmployeeVO vo = (DetailEmployeeVO)persistentObject;
        Response response = ClientUtils.getData((String)"deleteEmployee", (Object)new SubjectPK(vo.getCompanyCodeSys01REG04(), vo.getProgressiveReg04SCH01()));
        if (!response.isError()) {
            this.gridFrame.reloadData();
            this.detailFrame.getGrid().clearData();
            this.detailFrame.getAbsGrid().clearData();
            this.detailFrame.getHierarchiesPanel().getGrid().clearData();
        }
        return response;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"insertEmployee", (Object)newPersistentObject);
        if (!response.isError()) {
            DetailEmployeeVO vo = (DetailEmployeeVO)((VOResponse)response).getVo();
            this.companyCodeSys01SCH01 = vo.getCompanyCodeSys01REG04();
            this.progressiveReg04SCH01 = vo.getProgressiveREG04();
            this.gridFrame.reloadData();
            this.detailFrame.getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", this.companyCodeSys01SCH01);
            this.detailFrame.getGrid().getOtherGridParams().put("PROGRESSIVE_REG04", this.progressiveReg04SCH01);
            this.detailFrame.getGrid().reloadData();
            this.detailFrame.getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", this.companyCodeSys01SCH01);
            this.detailFrame.getGrid().getOtherGridParams().put("PROGRESSIVE_REG04", this.progressiveReg04SCH01);
            this.detailFrame.getAbsGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01SCH01());
            this.detailFrame.getAbsGrid().getOtherGridParams().put("PROGRESSIVE_REG04", vo.getProgressiveReg04SCH01());
            String actTypes = "'B','H','I'";
            this.detailFrame.getAbsGrid().getOtherGridParams().put("ACTIVITY_TYPE", actTypes);
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(vo.getCompanyCodeSys01SCH01(), vo.getProgressiveReg04SCH01()));
            this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "E");
            this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
        }
        return response;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadEmployee", (Object)new SubjectPK(this.companyCodeSys01SCH01, this.progressiveReg04SCH01));
    }

    public void loadDataCompleted(boolean error) {
        this.detailFrame.getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", this.companyCodeSys01SCH01);
        this.detailFrame.getGrid().getOtherGridParams().put("PROGRESSIVE_REG04", this.progressiveReg04SCH01);
        this.detailFrame.getGrid().reloadData();
        DetailEmployeeVO vo = (DetailEmployeeVO)this.detailFrame.getForm().getVOModel().getValueObject();
        this.detailFrame.getAbsGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01SCH01());
        this.detailFrame.getAbsGrid().getOtherGridParams().put("PROGRESSIVE_REG04", vo.getProgressiveReg04SCH01());
        String actTypes = "'B','H','I'";
        this.detailFrame.getAbsGrid().getOtherGridParams().put("ACTIVITY_TYPE", actTypes);
        this.detailFrame.getAbsGrid().reloadData();
        this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_PK", new SubjectPK(vo.getCompanyCodeSys01SCH01(), vo.getProgressiveReg04SCH01()));
        this.detailFrame.getHierarchiesPanel().getGrid().getOtherGridParams().put("SUBJECT_TYPE", "E");
        this.detailFrame.getHierarchiesPanel().getGrid().reloadData();
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"updateEmployee", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!response.isError()) {
            this.gridFrame.reloadData();
        }
        return response;
    }
}

