/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.items.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.items.client.ItemFrame;
import org.jallinone.items.java.DetailItemVO;
import org.jallinone.sales.discounts.java.ItemDiscountVO;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class DiscountsController
extends CompanyGridController {
    private ItemFrame frame = null;

    public DiscountsController(ItemFrame frame) {
        this.frame = frame;
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        ItemDiscountVO vo = (ItemDiscountVO)valueObject;
        vo.setMinQtySAL03(new BigDecimal(1.0));
        vo.setMultipleQtySAL03(Boolean.FALSE);
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response response = ClientUtils.getData((String)"deleteItemDiscounts", (Object)persistentObjects);
        return response;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        ItemDiscountVO vo = null;
        Response response = null;
        DetailItemVO itemVO = (DetailItemVO)this.frame.getFormPanel().getVOModel().getValueObject();
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (ItemDiscountVO)((Object)newValueObjects.get(i));
            response = this.validateDiscount(vo);
            if (response.isError()) {
                return response;
            }
            vo.setCompanyCodeSys01SAL03(itemVO.getCompanyCodeSys01ITM01());
            vo.setItemCodeItm01SAL04(itemVO.getItemCodeITM01());
            ++i;
        }
        response = ClientUtils.getData((String)"insertItemDiscounts", (Object)newValueObjects);
        return response;
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        Response response = null;
        ItemDiscountVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (ItemDiscountVO)((Object)persistentObjects.get(i));
            response = this.validateDiscount(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        response = ClientUtils.getData((String)"updateItemDiscounts", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
        return response;
    }

    private Response validateDiscount(ItemDiscountVO vo) {
        if (vo.getMinValueSAL03() != null && vo.getMaxValueSAL03() == null || vo.getMinValueSAL03() == null && vo.getMaxValueSAL03() != null) {
            return new ErrorResponse("max and min values must be both setted.");
        }
        if (vo.getMinPercSAL03() != null && vo.getMaxPercSAL03() == null || vo.getMinPercSAL03() == null && vo.getMaxPercSAL03() != null) {
            return new ErrorResponse("max and min percentages must be both setted.");
        }
        if (vo.getMinValueSAL03() == null && vo.getMaxValueSAL03() == null && vo.getMinPercSAL03() == null && vo.getMaxPercSAL03() == null) {
            return new ErrorResponse("you must define max and min percentages or max and min values.");
        }
        if (vo.getMinValueSAL03() != null && vo.getMaxValueSAL03() != null) {
            if (vo.getMinPercSAL03() != null || vo.getMaxPercSAL03() != null) {
                return new ErrorResponse("you must define max and min percentages otherwise max and min values.");
            }
            if (vo.getMinValueSAL03().doubleValue() > vo.getMaxValueSAL03().doubleValue()) {
                return new ErrorResponse("min value must be less than or equals to max value.");
            }
        }
        if (vo.getMinPercSAL03() != null && vo.getMaxPercSAL03() != null) {
            if (vo.getMinValueSAL03() != null || vo.getMaxValueSAL03() != null) {
                return new ErrorResponse("you must define max and min percentages otherwise max and min values.");
            }
            if (vo.getMinPercSAL03().doubleValue() > vo.getMaxPercSAL03().doubleValue()) {
                return new ErrorResponse("min percentage must be less than or equals to max percentage.");
            }
        }
        if (vo.getStartDateSAL03().getTime() > vo.getEndDateSAL03().getTime()) {
            return new ErrorResponse("start date must be less than or equals to end date.");
        }
        return new VOResponse((Object)new Boolean(true));
    }
}

