/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.items.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.items.client.ItemFrame;
import org.jallinone.items.client.ItemsFrame;
import org.jallinone.items.java.DetailItemVO;
import org.jallinone.items.java.GridItemVO;
import org.jallinone.items.java.ItemPK;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class ItemController
extends CompanyFormController {
    private ItemFrame frame = null;
    private ItemsFrame parentFrame = null;
    private ItemPK pk = null;

    public ItemController(ItemsFrame parentFrame, ItemPK pk, boolean productsOnly) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new ItemFrame(this, productsOnly);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getFormPanel().setMode(0);
            this.frame.getFormPanel().executeReload();
        } else {
            this.frame.getFormPanel().insert();
        }
    }

    public void afterInsertData() {
        this.frame.getDocsPanel().getDocsGrid().getOtherGridParams().put("ITEM_PK", this.pk);
        this.frame.getDocsPanel().getDocsGrid().reloadData();
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getSmallImage().setImage(null);
            this.frame.getLargeImage().setImage(null);
            this.frame.getDiscountsGrid().clearData();
            this.frame.getPricesGrid().clearData();
            this.frame.getBookedItemsPanel().setEnabled(false);
            this.frame.getOrderedItemsPanel().setEnabled(false);
            this.frame.getBookedItemsPanel().getGrid().clearData();
            this.frame.getOrderedItemsPanel().getGrid().clearData();
            this.frame.getBomTabbedPane().getComponentsGrid().clearData();
            this.frame.getBomTabbedPane().getAltCompsGrid().clearData();
            this.frame.getBomTabbedPane().setCompButtonsEnabled(false);
            this.frame.getBomTabbedPane().setAltButtonsEnabled(false);
            this.frame.getBomTabbedPane().getExplosionPanel().clearTree();
            this.frame.getBomTabbedPane().getImplosionPanel().clearTree();
            this.frame.getSupplierPrices().getPricesGrid().clearData();
            this.frame.getSupplierPrices().setButtonsEnabled(false);
            this.frame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailItemVO vo = (DetailItemVO)persistentObject;
        vo.setStartDateITM01(new Date(System.currentTimeMillis()));
        vo.setVersionITM01(new BigDecimal(1.0));
        vo.setRevisionITM01(new BigDecimal(1.0));
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<ItemPK> pks = new ArrayList<ItemPK>();
        DetailItemVO vo = (DetailItemVO)persistentObject;
        ItemPK pk = new ItemPK(vo.getCompanyCodeSys01ITM01(), vo.getItemCodeITM01());
        pks.add(pk);
        Response res = ClientUtils.getData((String)"deleteItems", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getDiscountsGrid().clearData();
            this.frame.getPricesGrid().clearData();
            this.frame.getBookedItemsPanel().setEnabled(false);
            this.frame.getOrderedItemsPanel().setEnabled(false);
            this.frame.getBookedItemsPanel().getGrid().clearData();
            this.frame.getOrderedItemsPanel().getGrid().clearData();
            this.frame.getDocsPanel().getDocsGrid().clearData();
            this.frame.getSupplierPrices().setButtonsEnabled(false);
            this.frame.getSupplierPrices().getPricesGrid().clearData();
            this.frame.getBomTabbedPane().getComponentsGrid().clearData();
            this.frame.getBomTabbedPane().getAltCompsGrid().clearData();
            this.frame.getBomTabbedPane().getExplosionPanel().clearTree();
            this.frame.getBomTabbedPane().getImplosionPanel().clearTree();
        }
        return res;
    }

    public ItemsFrame getParentFrame() {
        return this.parentFrame;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        DetailItemVO vo = (DetailItemVO)newPersistentObject;
        if (vo.getSerialNumberRequiredITM01() != null && vo.getSerialNumberRequiredITM01().booleanValue() && vo.getManufactureCodePro01ITM01() != null) {
            return new ErrorResponse("a product cannot require serial number definition");
        }
        Response res = ClientUtils.getData((String)"insertItem", (Object)((Object)vo));
        if (!res.isError()) {
            vo = (DetailItemVO)((Object)((VOResponse)res).getVo());
            this.pk = new ItemPK(vo.getCompanyCodeSys01ITM01(), vo.getItemCodeITM01());
            if (this.parentFrame != null) {
                // empty if block
            }
            this.frame.getDiscountsGrid().getOtherGridParams().put("ITEM_PK", this.pk);
            this.frame.getDiscountsGrid().reloadData();
            this.frame.getPricesGrid().getOtherGridParams().put("ITEM", vo);
            this.frame.getPricesGrid().reloadData();
            this.frame.setButtonsEnabled(true);
            this.frame.getSupplierPrices().getPricesGrid().getOtherGridParams().put("ITEM_PK", this.pk);
            this.frame.getSupplierPrices().setButtonsEnabled(true);
            this.frame.getSupplierPrices().getPricesGrid().reloadData();
            this.frame.getBookedItemsPanel().setEnabled(true);
            this.frame.getOrderedItemsPanel().setEnabled(true);
            this.frame.getBookedItemsPanel().getGrid().reloadData();
            this.frame.getOrderedItemsPanel().getGrid().reloadData();
            this.frame.getBookedItemsPanel().getGrid().getOtherGridParams().put("ITEM_PK", new ItemPK(vo.getCompanyCodeSys01ITM01(), vo.getItemCodeITM01()));
            this.frame.getOrderedItemsPanel().getGrid().getOtherGridParams().put("ITEM_PK", new ItemPK(vo.getCompanyCodeSys01ITM01(), vo.getItemCodeITM01()));
            this.frame.getDocsPanel().setItemVO(vo);
            this.frame.getBomTabbedPane().getComponentsGrid().getOtherGridParams().put("ITEM_PK", this.pk);
            this.frame.getBomTabbedPane().getExplosionPanel().getTreeDataLocator().getTreeNodeParams().put("ITEM_PK", this.pk);
            this.frame.getBomTabbedPane().getImplosionPanel().getTreeDataLocator().getTreeNodeParams().put("ITEM_PK", this.pk);
            this.frame.getBomTabbedPane().getAltCompsGrid().getOtherGridParams().put("ITEM_PK", this.pk);
            this.frame.getBomTabbedPane().getComponentsGrid().reloadData();
            this.frame.getBomTabbedPane().getAltCompsGrid().reloadData();
            this.frame.getBomTabbedPane().setCompButtonsEnabled(true);
            this.frame.getBomTabbedPane().setAltButtonsEnabled(true);
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        int row = this.parentFrame.getGrid().getSelectedRow();
        if (row != -1) {
            GridItemVO gridVO = (GridItemVO)this.parentFrame.getGrid().getVOListTableModel().getObjectForRow(row);
            this.pk = new ItemPK(gridVO.getCompanyCodeSys01ITM01(), gridVO.getItemCodeITM01());
        }
        return ClientUtils.getData((String)"loadItem", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        DetailItemVO vo = (DetailItemVO)persistentObject;
        if (vo.getSerialNumberRequiredITM01() != null && vo.getSerialNumberRequiredITM01().booleanValue() && vo.getManufactureCodePro01ITM01() != null) {
            return new ErrorResponse("a product cannot require serial number definition");
        }
        if (this.frame.getBomTabbedPane().getAltCompsGrid().getVOListTableModel().getRowCount() > 0 && vo.getManufactureCodePro01ITM01() != null) {
            return new ErrorResponse("you cannot define this item as a product because there are alternative components defined.");
        }
        Response res = ClientUtils.getData((String)"updateItem", (Object)new ValueObject[]{oldPersistentObject, vo});
        if (res.isError() || this.parentFrame != null) {
            // empty if block
        }
        return res;
    }
}

