/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.items.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.hierarchies.client.HierarTreePanel;
import org.jallinone.items.client.ItemsController;
import org.jallinone.items.java.ItemTypeVO;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ItemsFrame
extends InternalFrame {
    JPanel buttonsPanel = new JPanel();
    TextColumn colCod;
    TextColumn colCompany;
    TextColumn colDescr;
    ComboBoxControl comboBoxControl1;
    DeleteButton deleteButton1;
    ExportButton exportButton1;
    GridControl grid;
    GridBagLayout gridBagLayout1;
    private ServerGridDataLocator gridDataLocator;
    HierarTreePanel hierarTreePanel;
    InsertButton insertButton1;
    LabelControl labelItemType;
    NavigatorBar navigatorBar1;
    private boolean productsOnly;
    ReloadButton reloadButton1;
    JSplitPane split = new JSplitPane();

    public ItemsFrame(ItemsController itemsController, boolean productsOnly) {
        this.labelItemType = new LabelControl();
        this.insertButton1 = new InsertButton();
        this.reloadButton1 = new ReloadButton();
        this.deleteButton1 = new DeleteButton();
        this.exportButton1 = new ExportButton();
        this.navigatorBar1 = new NavigatorBar();
        this.gridBagLayout1 = new GridBagLayout();
        this.comboBoxControl1 = new ComboBoxControl();
        this.hierarTreePanel = new HierarTreePanel();
        this.grid = new GridControl();
        this.colCod = new TextColumn();
        this.colDescr = new TextColumn();
        this.colCompany = new TextColumn();
        this.gridDataLocator = new ServerGridDataLocator();
        this.productsOnly = productsOnly;
        try {
            this.jbInit();
            this.setSize(750, 550);
            this.setMinimumSize(new Dimension(750, 500));
            this.grid.setController((GridController)itemsController);
            this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
            this.gridDataLocator.setServerMethodName("loadItems");
            this.hierarTreePanel.setFunctionId("ITM02");
            this.hierarTreePanel.setTreeController(itemsController);
            this.grid.enableDrag(ApplicationConsts.ID_ITEMS_GRID.toString());
            this.init();
            this.grid.getOtherGridParams().put("PRODUCTS_ONLY", new Boolean(productsOnly));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GridControl getGrid() {
        return this.grid;
    }

    public ServerGridDataLocator getGridDataLocator() {
        return this.gridDataLocator;
    }

    public HierarTreePanel getHierarTreePanel() {
        return this.hierarTreePanel;
    }

    private void init() {
        Response res = ClientUtils.getData((String)"loadItemTypes", (Object)new GridParams());
        Domain d = new Domain("ITEM_TYPES");
        if (!res.isError()) {
            ItemTypeVO vo = null;
            List list = ((VOListResponse)res).getRows();
            int i = 0;
            while (i < list.size()) {
                vo = (ItemTypeVO)((Object)list.get(i));
                d.addDomainPair((Object)vo.getProgressiveHie02ITM02(), vo.getDescriptionSYS10());
                ++i;
            }
        }
        this.comboBoxControl1.setDomain(d);
        this.comboBoxControl1.getComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ItemsFrame.this.hierarTreePanel.setProgressiveHIE02((BigDecimal)ItemsFrame.this.comboBoxControl1.getValue());
                    ItemsFrame.this.hierarTreePanel.reloadTree();
                    ItemsFrame.this.grid.clearData();
                }
            }
        });
        if (d.getDomainPairList().length >= 1) {
            this.comboBoxControl1.getComboBox().setSelectedIndex(0);
        } else {
            this.comboBoxControl1.getComboBox().setSelectedIndex(-1);
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(ClientSettings.getInstance().getResources().getResource("items"));
        this.grid.setValueObjectClassName("org.jallinone.items.java.GridItemVO");
        this.labelItemType.setText("item type");
        this.insertButton1.setText("insertButton1");
        this.reloadButton1.setText("reloadButton1");
        this.deleteButton1.setText("deleteButton1");
        this.exportButton1.setText("exportButton1");
        this.buttonsPanel.setLayout(this.gridBagLayout1);
        this.grid.setSelectionMode(2);
        this.colCod.setColumnFilterable(true);
        this.colCod.setColumnName("itemCodeITM01");
        this.colCod.setColumnSortable(true);
        this.colCod.setPreferredWidth(120);
        this.colCod.setSortVersus("ASC");
        this.colCod.setSortingOrder(2);
        this.colDescr.setColumnFilterable(true);
        this.colDescr.setColumnName("descriptionSYS10");
        this.colDescr.setColumnSortable(true);
        this.colDescr.setPreferredWidth(250);
        this.colDescr.setSortingOrder(0);
        this.colCompany.setColumnFilterable(true);
        this.colCompany.setColumnName("companyCodeSys01ITM01");
        this.colCompany.setColumnSortable(true);
        this.colCompany.setSortVersus("ASC");
        this.colCompany.setSortingOrder(1);
        this.grid.setAutoLoadData(false);
        this.grid.setDeleteButton(this.deleteButton1);
        this.grid.setExportButton(this.exportButton1);
        this.grid.setFunctionId("ITM01");
        this.grid.setMaxSortedColumns(3);
        this.grid.setInsertButton(this.insertButton1);
        this.grid.setNavBar(this.navigatorBar1);
        this.grid.setReloadButton(this.reloadButton1);
        this.getContentPane().add((Component)this.buttonsPanel, "North");
        this.getContentPane().add((Component)this.split, "Center");
        this.buttonsPanel.add((Component)this.labelItemType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.buttonsPanel.add((Component)this.insertButton1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.reloadButton1, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.deleteButton1, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.exportButton1, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.navigatorBar1, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.buttonsPanel.add((Component)this.comboBoxControl1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 100, 0));
        this.split.add((Component)((Object)this.hierarTreePanel), "left");
        this.split.add((Component)this.grid, "right");
        this.grid.getColumnContainer().add((Component)this.colCompany, null);
        this.grid.getColumnContainer().add((Component)this.colCod, null);
        this.grid.getColumnContainer().add((Component)this.colDescr, null);
        this.split.setDividerLocation(210);
    }
}

