/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.production.manufactures.client;

import java.util.ArrayList;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.production.manufactures.client.OperationsGridFrame;
import org.jallinone.production.manufactures.java.OperationVO;
import org.jallinone.registers.currency.java.CurrencyVO;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class OperationsController
extends CompanyGridController {
    private OperationsGridFrame gridFrame = new OperationsGridFrame(this);

    public OperationsController() {
        MDIFrame.add((InternalFrame)this.gridFrame, (boolean)true);
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        Response res;
        OperationVO vo = (OperationVO)valueObject;
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
        ArrayList companiesList = bca.getCompaniesList("PRO04");
        if (companiesList.size() > 0 && vo.getCompanyCodeSys01PRO04() == null) {
            vo.setCompanyCodeSys01PRO04((String)companiesList.get(0));
        }
        if ((res = ClientUtils.getData((String)"loadCompanyCurrency", (Object)vo.getCompanyCodeSys01PRO04())).isError()) {
            throw new Exception(res.getErrorMessage());
        }
        this.gridFrame.setCurrencyVO((CurrencyVO)((Object)((VOResponse)res).getVo()));
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response response = ClientUtils.getData((String)"deleteOperations", (Object)persistentObjects);
        return response;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        OperationVO vo = null;
        Response response = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (OperationVO)((Object)newValueObjects.get(i));
            response = this.validatePhase(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertOperations", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        OperationVO vo = null;
        Response response = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (OperationVO)((Object)persistentObjects.get(i));
            response = this.validatePhase(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateOperations", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    private Response validatePhase(OperationVO vo) {
        if (vo.getMachineryCodePro03PRO04() == null && vo.getTaskCodeReg07PRO04() == null) {
            return new ErrorResponse("you must define either a machinery or a duty");
        }
        if (vo.getTaskCodeReg07PRO04() != null && vo.getQtyPRO04() == null) {
            return new ErrorResponse("you must define the resources number");
        }
        return new VOResponse((Object)Boolean.TRUE);
    }
}

