/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.documents.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jallinone.purchases.documents.client.PurchaseDiscChargesPanel_controlChargePerc_focusAdapter;
import org.jallinone.purchases.documents.client.PurchaseDiscChargesPanel_controlChargeValue_focusAdapter;
import org.jallinone.purchases.documents.client.PurchaseDiscChargesPanel_controlDiscPerc_focusAdapter;
import org.jallinone.purchases.documents.client.PurchaseDiscChargesPanel_controlDiscValue_focusAdapter;
import org.jallinone.purchases.documents.java.DetailPurchaseDocVO;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class PurchaseDiscChargesPanel
extends JPanel {
    NumericControl controlChargePerc;
    CurrencyControl controlChargeValue;
    NumericControl controlDiscPerc;
    CurrencyControl controlDiscValue;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    LabelControl labelChargePerc;
    LabelControl labelChargeValue;
    LabelControl labelDiscPerc;
    LabelControl labelDiscValue = new LabelControl();
    private Form parentForm = null;
    TitledBorder titledBorder1;

    public PurchaseDiscChargesPanel(Form parentForm) {
        this.controlDiscValue = new CurrencyControl();
        this.labelDiscPerc = new LabelControl();
        this.controlDiscPerc = new NumericControl();
        this.labelChargeValue = new LabelControl();
        this.labelChargePerc = new LabelControl();
        this.controlChargeValue = new CurrencyControl();
        this.controlChargePerc = new NumericControl();
        this.parentForm = parentForm;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void controlChargePerc_focusLost(FocusEvent e) {
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.parentForm.getVOModel().getValueObject();
        if (this.controlChargePerc.getValue() != null && this.controlChargeValue.getValue() != null) {
            vo.setChargeValueDOC06(null);
        }
        vo.setChargePercDOC06(this.controlChargePerc.getBigDecimal());
        this.recalculateTotals();
    }

    void controlChargeValue_focusLost(FocusEvent e) {
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.parentForm.getVOModel().getValueObject();
        if (this.controlChargePerc.getValue() != null && this.controlChargeValue.getValue() != null) {
            vo.setChargePercDOC06(null);
        }
        vo.setChargeValueDOC06(this.controlChargeValue.getBigDecimal());
        this.recalculateTotals();
    }

    void controlDiscPerc_focusLost(FocusEvent e) {
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.parentForm.getVOModel().getValueObject();
        if (this.controlDiscPerc.getValue() != null && this.controlDiscValue.getValue() != null) {
            vo.setDiscountValueDOC06(null);
        }
        vo.setDiscountPercDOC06(this.controlDiscPerc.getBigDecimal());
        this.recalculateTotals();
    }

    void controlDiscValue_focusLost(FocusEvent e) {
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.parentForm.getVOModel().getValueObject();
        if (this.controlDiscPerc.getValue() != null && this.controlDiscValue.getValue() != null) {
            vo.setDiscountPercDOC06(null);
        }
        vo.setDiscountValueDOC06(this.controlDiscValue.getBigDecimal());
        this.recalculateTotals();
    }

    public CurrencyControl getControlChargeValue() {
        return this.controlChargeValue;
    }

    public CurrencyControl getControlDiscValue() {
        return this.controlDiscValue;
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.labelDiscValue.setText("discount value");
        this.titledBorder1.setTitle(ClientSettings.getInstance().getResources().getResource("discounts and charges"));
        this.titledBorder1.setBorder(BorderFactory.createEtchedBorder());
        this.titledBorder1.setTitleColor(Color.blue);
        this.setBorder(this.titledBorder1);
        this.setLayout(this.gridBagLayout1);
        this.labelDiscPerc.setText("discount perc");
        this.labelChargeValue.setText("charge value");
        this.labelChargePerc.setText("charge perc");
        this.controlDiscValue.setLinkLabel(this.labelDiscValue);
        this.controlDiscValue.addFocusListener((FocusListener)new PurchaseDiscChargesPanel_controlDiscValue_focusAdapter(this));
        this.controlDiscValue.setAttributeName("discountValueDOC06");
        this.controlDiscValue.setCanCopy(true);
        this.controlDiscValue.setDecimals(5);
        this.controlDiscPerc.addFocusListener((FocusListener)new PurchaseDiscChargesPanel_controlDiscPerc_focusAdapter(this));
        this.controlDiscPerc.setAttributeName("discountPercDOC06");
        this.controlDiscPerc.setCanCopy(true);
        this.controlDiscPerc.setDecimals(2);
        this.controlDiscPerc.setLinkLabel(this.labelDiscPerc);
        this.controlDiscPerc.setMaxValue(100.0);
        this.controlDiscPerc.setMinValue(0.0);
        this.controlChargeValue.addFocusListener((FocusListener)new PurchaseDiscChargesPanel_controlChargeValue_focusAdapter(this));
        this.controlChargeValue.setAttributeName("chargeValueDOC06");
        this.controlChargeValue.setCanCopy(true);
        this.controlChargeValue.setDecimals(5);
        this.controlChargeValue.setLinkLabel(this.labelChargeValue);
        this.controlChargePerc.addFocusListener((FocusListener)new PurchaseDiscChargesPanel_controlChargePerc_focusAdapter(this));
        this.controlChargePerc.setAttributeName("chargePercDOC06");
        this.controlChargePerc.setCanCopy(true);
        this.controlChargePerc.setDecimals(2);
        this.controlChargePerc.setLinkLabel(this.labelChargePerc);
        this.controlChargePerc.setMaxValue(100.0);
        this.controlChargePerc.setMinValue(0.0);
        this.add((Component)this.labelDiscValue, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlDiscValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelDiscPerc, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlDiscPerc, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelChargeValue, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelChargePerc, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlChargeValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlChargePerc, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void recalculateTotals() {
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.parentForm.getVOModel().getValueObject();
        Response res = ClientUtils.getData((String)"getPurchaseDocTotals", (Object)((Object)vo));
        if (res.isError()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)this), ClientSettings.getInstance().getResources().getResource("Error while loading data") + ":\n" + res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Loading Data Error"), 0);
        } else {
            DetailPurchaseDocVO newVO = (DetailPurchaseDocVO)((Object)((VOResponse)res).getVo());
            vo.setTotalDOC06(newVO.getTotalDOC06());
            vo.setTaxableIncomeDOC06(newVO.getTaxableIncomeDOC06());
            vo.setTotalVatDOC06(newVO.getTotalVatDOC06());
            this.parentForm.pull();
        }
    }
}

