/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.documents.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.purchases.documents.client.PurchaseDocFrame;
import org.jallinone.purchases.documents.client.PurchaseDocsFrame;
import org.jallinone.purchases.documents.java.DetailPurchaseDocRowVO;
import org.jallinone.purchases.documents.java.DetailPurchaseDocVO;
import org.jallinone.purchases.documents.java.GridPurchaseDocVO;
import org.jallinone.purchases.documents.java.PurchaseDocPK;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class PurchaseDocController
extends CompanyFormController {
    private PurchaseDocFrame frame = null;
    private PurchaseDocsFrame parentFrame = null;
    private PurchaseDocPK pk = null;

    public PurchaseDocController(PurchaseDocsFrame parentFrame, PurchaseDocPK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new PurchaseDocFrame(this);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getHeaderFormPanel().setMode(0);
            this.frame.getHeaderFormPanel().executeReload();
        } else {
            this.frame.getHeaderFormPanel().insert();
        }
    }

    public void afterInsertData() {
        if (this.parentFrame != null) {
            // empty if block
        }
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        this.frame.getRowsPanel().setParentVO(vo);
        this.frame.getRowsPanel().getGrid().getOtherGridParams().put("PURCHASE_DOC_PK", this.pk);
        this.frame.getRowsPanel().getGrid().reloadData();
        this.frame.setButtonsEnabled(true);
    }

    public boolean beforeDeleteData(Form form) {
        if (!super.beforeDeleteData(form)) {
            return false;
        }
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC06().equals("C");
    }

    public boolean beforeEditData(Form form) {
        if (!super.beforeEditData(form)) {
            return false;
        }
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC06().equals("C");
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getRowsPanel().getGrid().clearData();
            this.frame.getRowsPanel().getDetailPanel().getVOModel().setValueObject((ValueObject)new DetailPurchaseDocRowVO());
            this.frame.getRowsPanel().getDetailPanel().pull();
            this.frame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)persistentObject;
        Calendar cal = Calendar.getInstance();
        vo.setDocYearDOC06(new BigDecimal((double)cal.get(1)));
        vo.setDocDateDOC06(new Date(System.currentTimeMillis()));
        vo.setDocTypeDOC06("P");
        vo.setDocStateDOC06("O");
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<PurchaseDocPK> pks = new ArrayList<PurchaseDocPK>();
        DetailPurchaseDocVO vo = (DetailPurchaseDocVO)persistentObject;
        pks.add(this.pk);
        Response res = ClientUtils.getData((String)"deletePurchaseDocs", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getRowsPanel().getGrid().clearData();
        }
        return res;
    }

    public PurchaseDocsFrame getParentFrame() {
        return this.parentFrame;
    }

    public PurchaseDocPK getPk() {
        return this.pk;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"insertPurchaseDoc", (Object)newPersistentObject);
        if (!res.isError()) {
            DetailPurchaseDocVO vo = (DetailPurchaseDocVO)((Object)((VOResponse)res).getVo());
            this.pk = new PurchaseDocPK(vo.getCompanyCodeSys01DOC06(), vo.getDocTypeDOC06(), vo.getDocYearDOC06(), vo.getDocNumberDOC06());
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        int row = this.parentFrame.getGrid().getSelectedRow();
        if (row != -1) {
            GridPurchaseDocVO gridVO = (GridPurchaseDocVO)this.parentFrame.getGrid().getVOListTableModel().getObjectForRow(row);
            this.pk = new PurchaseDocPK(gridVO.getCompanyCodeSys01DOC06(), gridVO.getDocTypeDOC06(), gridVO.getDocYearDOC06(), gridVO.getDocNumberDOC06());
        }
        return ClientUtils.getData((String)"loadPurchaseDoc", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updatePurchaseDoc", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (res.isError() || this.parentFrame != null) {
            // empty if block
        }
        return res;
    }
}

