/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.pricelist.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.purchases.pricelist.client.SupplierPricelistPanel;
import org.jallinone.purchases.pricelist.java.SupplierPricelistVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class SupplierPricelistController
extends CompanyGridController {
    private boolean firstTime = true;
    private String oldCompanyCodeSys01PUR03 = null;
    private String oldPricelistCodePUR03 = null;
    private BigDecimal oldProgressiveReg04PUR03 = null;
    private SupplierPricelistPanel panel = null;

    public SupplierPricelistController(SupplierPricelistPanel panel) {
        this.panel = panel;
    }

    public boolean beforeCopyGrid(GridControl grid) {
        boolean ok = super.beforeCopyGrid(grid);
        if (!ok) {
            return false;
        }
        SupplierPricelistVO vo = (SupplierPricelistVO)this.panel.getGrid().getVOListTableModel().getObjectForRow(this.panel.getGrid().getSelectedRow());
        this.oldCompanyCodeSys01PUR03 = vo.getCompanyCodeSys01PUR03();
        this.oldPricelistCodePUR03 = vo.getPricelistCodePUR03();
        this.oldProgressiveReg04PUR03 = vo.getProgressiveReg04PUR03();
        return true;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response res = ClientUtils.getData((String)"deleteSupplierPricelist", (Object)persistentObjects);
        if (!res.isError()) {
            this.panel.getPricesGrid().clearData();
            this.panel.setPricesPanelEnabled(false);
        }
        return res;
    }

    public void doubleClick(int rowNumber, ValueObject persistentObject) {
        SupplierPricelistVO vo = (SupplierPricelistVO)persistentObject;
        this.panel.setPricesPanelEnabled(true);
        this.panel.getPricesGrid().getOtherGridParams().put("PRICELIST", vo);
        this.panel.getTreeLevelDataLocator().getTreeNodeParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01PUR03());
        this.panel.getPricesGrid().reloadData();
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        SupplierPricelistVO vo = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (SupplierPricelistVO)((Object)newValueObjects.get(i));
            vo.setOldPricelistCodePur03PUR04(this.oldPricelistCodePUR03);
            vo.setOldProgressiveReg04PUR03(this.oldProgressiveReg04PUR03);
            vo.setCompanyCodeSys01PUR03(this.panel.getSupplierVO().getCompanyCodeSys01REG04());
            vo.setProgressiveReg04PUR03(this.panel.getSupplierVO().getProgressiveREG04());
            ++i;
        }
        Response res = ClientUtils.getData((String)"insertSupplierPricelists", (Object)newValueObjects);
        if (!res.isError()) {
            this.doubleClick(0, (ValueObject)((VOListResponse)res).getRows().get(0));
        }
        this.oldCompanyCodeSys01PUR03 = null;
        this.oldPricelistCodePUR03 = null;
        this.oldProgressiveReg04PUR03 = null;
        return res;
    }

    public void loadDataCompleted(boolean error) {
        if (this.firstTime && !error) {
            this.firstTime = false;
            if (this.panel.getGrid().getVOListTableModel().getRowCount() > 0) {
                this.doubleClick(0, this.panel.getGrid().getVOListTableModel().getObjectForRow(0));
            }
        }
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updateSupplierPricelists", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

