/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.pricelist.client;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.purchases.items.java.SupplierItemVO;
import org.jallinone.purchases.pricelist.client.SupplierImportItems;
import org.jallinone.purchases.pricelist.client.SupplierImportItemsDialog;
import org.jallinone.purchases.pricelist.client.SupplierPricelistPanel;
import org.jallinone.purchases.pricelist.java.SupplierPriceVO;
import org.jallinone.purchases.pricelist.java.SupplierPricelistVO;
import org.jallinone.purchases.suppliers.client.SupplierDetailFrame;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class SupplierPricesController
extends CompanyGridController
implements SupplierImportItems {
    private SupplierPricelistPanel panel = null;

    public SupplierPricesController(SupplierPricelistPanel panel) {
        this.panel = panel;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deleteSupplierPrices", (Object)persistentObjects);
    }

    public boolean dropEnabled(String gridId) {
        if (!this.beforeInsertGrid(this.panel.getPricesGrid())) {
            return false;
        }
        if (gridId.equals(ApplicationConsts.ID_SUPPLIER_ITEMS_GRID.toString()) && this.panel.getGrid().getSelectedRow() != -1) {
            SupplierDetailFrame f = (SupplierDetailFrame)MDIFrame.getSelectedFrame();
            int[] rows = f.getItemsGrid().getSelectedRows();
            SupplierItemVO vo = null;
            ArrayList<SupplierItemVO> list = new ArrayList<SupplierItemVO>();
            int i = 0;
            while (i < rows.length) {
                vo = (SupplierItemVO)f.getItemsGrid().getVOListTableModel().getObjectForRow(rows[i]);
                list.add(vo);
                ++i;
            }
            new SupplierImportItemsDialog(list, this);
            return true;
        }
        return false;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        SupplierPriceVO vo = null;
        SupplierPricelistVO pricelistVO = null;
        Response response = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (SupplierPriceVO)((Object)newValueObjects.get(i));
            pricelistVO = (SupplierPricelistVO)this.panel.getGrid().getVOListTableModel().getObjectForRow(this.panel.getGrid().getSelectedRow());
            vo.setCompanyCodeSys01PUR04(pricelistVO.getCompanyCodeSys01PUR03());
            vo.setPricelistCodePur03PUR04(pricelistVO.getPricelistCodePUR03());
            vo.setProgressiveReg04PUR04(pricelistVO.getProgressiveReg04PUR03());
            response = this.validateDates(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertSupplierPrices", (Object)newValueObjects);
    }

    public void saveItems(ArrayList items, java.util.Date startDate, java.util.Date endDate, BigDecimal price) {
        SupplierPricelistVO pricelistVO = (SupplierPricelistVO)this.panel.getGrid().getVOListTableModel().getObjectForRow(this.panel.getGrid().getSelectedRow());
        ArrayList<SupplierPriceVO> persistentObjects = new ArrayList<SupplierPriceVO>();
        SupplierItemVO vo = null;
        SupplierPriceVO priceVO = null;
        int i = 0;
        while (i < items.size()) {
            vo = (SupplierItemVO)((Object)items.get(i));
            priceVO = new SupplierPriceVO();
            priceVO.setCompanyCodeSys01PUR04(vo.getCompanyCodeSys01PUR02());
            priceVO.setEndDatePUR04(new Date(endDate.getTime()));
            priceVO.setItemCodeItm01PUR04(vo.getItemCodeItm01PUR02());
            priceVO.setItemDescriptionSYS10(vo.getDescriptionSYS10());
            priceVO.setPricelistCodePur03PUR04(pricelistVO.getPricelistCodePUR03());
            priceVO.setPricelistDescriptionSYS10(pricelistVO.getDescriptionSYS10());
            priceVO.setProgressiveHie02ITM01(vo.getProgressiveHie02PUR02());
            priceVO.setStartDatePUR04(new Date(startDate.getTime()));
            priceVO.setProgressiveReg04PUR04(vo.getProgressiveReg04PUR02());
            priceVO.setValuePUR04(price);
            persistentObjects.add(priceVO);
            ++i;
        }
        Response res = ClientUtils.getData((String)"insertSupplierPrices", persistentObjects);
        if (res.isError()) {
            JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource("Error while saving") + "\n" + res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Saving Error"), 0);
        } else {
            this.panel.getPricesGrid().reloadData();
        }
        try {
            Container parent = this.panel.getParent();
            while (parent != null && !(parent instanceof InternalFrame)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                ((InternalFrame)parent).setSelected(true);
                ((InternalFrame)parent).toFront();
            }
        }
        catch (PropertyVetoException ex) {
        }
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        Response response = null;
        SupplierPriceVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (SupplierPriceVO)((Object)persistentObjects.get(i));
            response = this.validateDates(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateSupplierPrices", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    private Response validateDates(SupplierPriceVO vo) {
        if (vo.getStartDatePUR04().getTime() > vo.getEndDatePUR04().getTime()) {
            return new ErrorResponse("start date must be less than or equals to end date.");
        }
        return new VOResponse((Object)new Boolean(true));
    }
}

