/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.purchases.suppliers.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.items.client.ItemsFrame;
import org.jallinone.items.java.GridItemVO;
import org.jallinone.purchases.items.java.SupplierItemPK;
import org.jallinone.purchases.items.java.SupplierItemVO;
import org.jallinone.purchases.suppliers.client.SupplierDetailFrame;
import org.jallinone.purchases.suppliers.java.DetailSupplierVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class SupplierItemsController
extends CompanyGridController {
    private SupplierDetailFrame frame = null;

    public SupplierItemsController(SupplierDetailFrame frame) {
        this.frame = frame;
    }

    public boolean beforeInsertGrid(GridControl grid) {
        boolean ok = super.beforeInsertGrid(grid);
        if (!ok) {
            return false;
        }
        if (this.frame.getTreePanel().getSelectedNode() == null || !this.frame.getTreePanel().getSelectedNode().isLeaf()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)grid), ClientSettings.getInstance().getResources().getResource("you are allowed to insert data only on a leaf node."), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return false;
        }
        return ok;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        SupplierItemVO vo = null;
        ArrayList<SupplierItemPK> pks = new ArrayList<SupplierItemPK>();
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (SupplierItemVO)((Object)persistentObjects.get(i));
            pks.add(new SupplierItemPK(vo.getCompanyCodeSys01PUR02(), vo.getItemCodeItm01PUR02(), vo.getProgressiveReg04PUR02()));
            ++i;
        }
        Response response = ClientUtils.getData((String)"deleteSupplierItems", pks);
        return response;
    }

    public boolean dropEnabled(String gridId) {
        if (!this.beforeInsertGrid(this.frame.getItemsGrid())) {
            return false;
        }
        if (gridId.equals(ApplicationConsts.ID_ITEMS_GRID.toString()) && this.frame.getCurrentForm().getVOModel().getValueObject() != null && ((DetailSupplierVO)this.frame.getCurrentForm().getVOModel().getValueObject()).getProgressiveREG04() != null) {
            ItemsFrame f = (ItemsFrame)MDIFrame.getSelectedFrame();
            int[] rows = f.getGrid().getSelectedRows();
            GridItemVO vo = null;
            SupplierItemVO suppItemVO = null;
            ArrayList<SupplierItemVO> list = new ArrayList<SupplierItemVO>();
            DetailSupplierVO supplierVO = (DetailSupplierVO)this.frame.getCurrentForm().getVOModel().getValueObject();
            int i = 0;
            while (i < rows.length) {
                vo = (GridItemVO)f.getGrid().getVOListTableModel().getObjectForRow(rows[i]);
                suppItemVO = new SupplierItemVO();
                suppItemVO.setCompanyCodeSys01PUR02(vo.getCompanyCodeSys01ITM01());
                suppItemVO.setDescriptionSYS10(vo.getDescriptionSYS10());
                suppItemVO.setItemCodeItm01PUR02(vo.getItemCodeITM01());
                suppItemVO.setMinPurchaseQtyPUR02(new BigDecimal(1.0));
                suppItemVO.setMultipleQtyPUR02(new BigDecimal(1.0));
                suppItemVO.setProgressiveHie01PUR02(vo.getProgressiveHie01ITM01());
                suppItemVO.setProgressiveHie02PUR02(vo.getProgressiveHie02ITM01());
                suppItemVO.setProgressiveReg04PUR02(supplierVO.getProgressiveREG04());
                suppItemVO.setSupplierItemCodePUR02(vo.getItemCodeITM01());
                suppItemVO.setUmCodeReg02PUR02(vo.getMinSellingQtyUmCodeReg02ITM01());
                list.add(suppItemVO);
                ++i;
            }
            Response res = ClientUtils.getData((String)"insertSupplierItems", list);
            this.frame.getItemsGrid().reloadData();
            return true;
        }
        return false;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        SupplierItemVO vo = null;
        DefaultMutableTreeNode selNode = this.frame.getTreePanel().getSelectedNode();
        HierarchyLevelVO levelVO = (HierarchyLevelVO)((Object)selNode.getUserObject());
        DetailSupplierVO supplierVO = (DetailSupplierVO)this.frame.getCurrentForm().getVOModel().getValueObject();
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (SupplierItemVO)((Object)newValueObjects.get(i));
            vo.setProgressiveHie02PUR02(levelVO.getProgressiveHie02HIE01());
            vo.setProgressiveHie01PUR02(levelVO.getProgressiveHIE01());
            vo.setProgressiveReg04PUR02(supplierVO.getProgressiveREG04());
            ++i;
        }
        return ClientUtils.getData((String)"insertSupplierItems", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"updateSupplierItems", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }
}

