/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.activities.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.util.Collection;
import javax.swing.JPanel;
import org.jallinone.commons.client.CompaniesComboColumn;
import org.jallinone.commons.client.CustomizedColumns;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.sales.activities.java.SaleActivityVO;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.CurrencyColumn;
import org.openswing.swing.table.columns.client.CurrencyColumnSettings;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.DecimalColumnSettings;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;

public class SaleActivitiesGridFrame
extends InternalFrame
implements CurrencyColumnSettings {
    JPanel buttonsPanel = new JPanel();
    CompaniesComboColumn colCompanycode;
    CodLookupColumn colCurrencyCod;
    TextColumn colDescr;
    TextColumn colSaleActivity;
    CurrencyColumn colValue;
    CodLookupColumn colVatCode;
    DecimalColumn colVatDeductible;
    TextColumn colVatDesc;
    DecimalColumn colVatValue;
    LookupController currencyController;
    LookupServerDataLocator currencyDataLocator;
    DeleteButton deleteButton;
    EditButton editButton;
    ExportButton exportButton;
    FlowLayout flowLayout1 = new FlowLayout();
    GridControl grid;
    private ServerGridDataLocator gridDataLocator;
    InsertButton insertButton = new InsertButton();
    NavigatorBar navigatorBar;
    ReloadButton reloadButton = new ReloadButton();
    SaveButton saveButton;
    LookupController vatController;
    LookupServerDataLocator vatDataLocator;

    public SaleActivitiesGridFrame(GridController controller) {
        this.deleteButton = new DeleteButton();
        this.navigatorBar = new NavigatorBar();
        this.grid = new GridControl();
        this.editButton = new EditButton();
        this.saveButton = new SaveButton();
        this.gridDataLocator = new ServerGridDataLocator();
        this.colSaleActivity = new TextColumn();
        this.colDescr = new TextColumn();
        this.exportButton = new ExportButton();
        this.colValue = new CurrencyColumn();
        this.colCurrencyCod = new CodLookupColumn();
        this.colVatCode = new CodLookupColumn();
        this.colVatDesc = new TextColumn();
        this.colVatValue = new DecimalColumn();
        this.colCompanycode = new CompaniesComboColumn();
        this.currencyController = new LookupController();
        this.currencyDataLocator = new LookupServerDataLocator();
        this.vatController = new LookupController();
        this.vatDataLocator = new LookupServerDataLocator();
        this.colVatDeductible = new DecimalColumn();
        this.grid.setController(controller);
        this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
        this.gridDataLocator.setServerMethodName("loadSaleActivities");
        try {
            this.jbInit();
            this.setSize(750, 500);
            this.setMinimumSize(new Dimension(750, 500));
            this.currencyDataLocator.setGridMethodName("loadCurrencies");
            this.currencyDataLocator.setValidationMethodName("validateCurrencyCode");
            this.colCurrencyCod.setLookupController(this.currencyController);
            this.colCurrencyCod.setControllerMethodName("getCurrenciesList");
            this.currencyController.setLookupDataLocator((LookupDataLocator)this.currencyDataLocator);
            this.currencyController.setFrameTitle("currencies");
            this.currencyController.setLookupValueObjectClassName("org.jallinone.registers.currency.java.CurrencyVO");
            this.currencyController.addLookup2ParentLink("currencyCodeREG03", "currencyCodeReg03SAL09");
            this.currencyController.setAllColumnVisible(false);
            this.currencyController.setVisibleColumn("currencyCodeREG03", true);
            this.currencyController.setVisibleColumn("currencySymbolREG03", true);
            this.currencyController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    SaleActivityVO vo = (SaleActivityVO)parentVO;
                    if (vo.getCurrencyCodeReg03SAL09() == null || vo.getCurrencyCodeReg03SAL09().equals("")) {
                        vo.setValueSAL09(null);
                        SaleActivitiesGridFrame.this.grid.repaint();
                    } else {
                        SaleActivitiesGridFrame.this.grid.repaint();
                    }
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            new CustomizedColumns(new BigDecimal(182.0), this.currencyController);
            this.vatDataLocator.setGridMethodName("loadVats");
            this.vatDataLocator.setValidationMethodName("validateVatCode");
            this.colVatCode.setLookupController(this.vatController);
            this.colVatCode.setControllerMethodName("getVatsList");
            this.vatController.setLookupDataLocator((LookupDataLocator)this.vatDataLocator);
            this.vatController.setFrameTitle("vats");
            this.vatController.setLookupValueObjectClassName("org.jallinone.registers.vat.java.VatVO");
            this.vatController.addLookup2ParentLink("vatCodeREG01", "vatCodeReg01SAL09");
            this.vatController.addLookup2ParentLink("descriptionSYS10", "vatDescriptionSYS10");
            this.vatController.addLookup2ParentLink("valueREG01", "vatValueREG01");
            this.vatController.addLookup2ParentLink("deductibleREG01", "vatDeductibleREG01");
            this.vatController.setAllColumnVisible(false);
            this.vatController.setVisibleColumn("vatCodeREG01", true);
            this.vatController.setVisibleColumn("descriptionSYS10", true);
            this.vatController.setVisibleColumn("valueREG01", true);
            CustomizedColumns vatCust = new CustomizedColumns(new BigDecimal(162.0), this.vatController);
            this.colValue.setDynamicSettings((DecimalColumnSettings)this);
            CustomizedColumns cust = new CustomizedColumns(ApplicationConsts.ID_SALE_ACTIVITIES, this.grid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCurrencySymbol(int row) {
        SaleActivityVO vo = (SaleActivityVO)this.grid.getVOListTableModel().getObjectForRow(row);
        if (vo.getCurrencySymbolREG03() != null) {
            return vo.getCurrencySymbolREG03();
        }
        return "E";
    }

    public int getDecimals(int row) {
        SaleActivityVO vo = (SaleActivityVO)this.grid.getVOListTableModel().getObjectForRow(row);
        if (vo.getDecimalsREG03() != null) {
            return vo.getDecimalsREG03().intValue();
        }
        return 0;
    }

    public GridControl getGrid() {
        return this.grid;
    }

    public double getMaxValue(int row) {
        return Double.MAX_VALUE;
    }

    public double getMinValue(int row) {
        return 0.0;
    }

    public boolean isGrouping(int row) {
        return true;
    }

    private void jbInit() throws Exception {
        this.grid.setMaxNumberOfRowsOnInsert(50);
        this.grid.setSelectionMode(2);
        this.saveButton.setExecuteAsThread(true);
        this.grid.setValueObjectClassName("org.jallinone.sales.activities.java.SaleActivityVO");
        this.grid.setSelectionMode(2);
        this.setTitle(ClientSettings.getInstance().getResources().getResource("sale activities"));
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.grid.setDeleteButton(this.deleteButton);
        this.grid.setEditButton(this.editButton);
        this.grid.setExportButton(this.exportButton);
        this.grid.setFunctionId("SAL09");
        this.grid.setMaxSortedColumns(3);
        this.grid.setInsertButton(this.insertButton);
        this.grid.setNavBar(this.navigatorBar);
        this.grid.setReloadButton(this.reloadButton);
        this.grid.setSaveButton(this.saveButton);
        this.colSaleActivity.setMaxCharacters(20);
        this.colSaleActivity.setTrimText(true);
        this.colSaleActivity.setUpperCase(true);
        this.colSaleActivity.setColumnFilterable(true);
        this.colSaleActivity.setColumnName("activityCodeSAL09");
        this.colSaleActivity.setColumnSortable(true);
        this.colSaleActivity.setEditableOnInsert(true);
        this.colSaleActivity.setPreferredWidth(90);
        this.colSaleActivity.setSortVersus("ASC");
        this.colSaleActivity.setSortingOrder(1);
        this.colDescr.setColumnFilterable(false);
        this.colDescr.setColumnName("descriptionSYS10");
        this.colDescr.setColumnSortable(true);
        this.colDescr.setEditableOnEdit(true);
        this.colDescr.setEditableOnInsert(true);
        this.colDescr.setPreferredWidth(180);
        this.colValue.setDecimals(5);
        this.colValue.setMinValue(0.0);
        this.colValue.setColumnDuplicable(true);
        this.colValue.setColumnFilterable(true);
        this.colValue.setColumnName("valueSAL09");
        this.colValue.setColumnRequired(false);
        this.colValue.setColumnSortable(true);
        this.colValue.setEditableOnEdit(true);
        this.colValue.setEditableOnInsert(true);
        this.colValue.setPreferredWidth(70);
        this.colCurrencyCod.setColumnDuplicable(true);
        this.colCurrencyCod.setColumnFilterable(true);
        this.colCurrencyCod.setColumnName("currencyCodeReg03SAL09");
        this.colCurrencyCod.setEditableOnEdit(true);
        this.colCurrencyCod.setEditableOnInsert(true);
        this.colCurrencyCod.setHeaderColumnName("currencyCodeReg03SAL09");
        this.colCurrencyCod.setPreferredWidth(90);
        this.colCurrencyCod.setMaxCharacters(20);
        this.colVatCode.setColumnDuplicable(true);
        this.colVatCode.setColumnFilterable(true);
        this.colVatCode.setColumnName("vatCodeReg01SAL09");
        this.colVatCode.setColumnRequired(false);
        this.colVatCode.setColumnSortable(true);
        this.colVatCode.setEditableOnEdit(true);
        this.colVatCode.setEditableOnInsert(true);
        this.colVatCode.setPreferredWidth(70);
        this.colVatCode.setMaxCharacters(20);
        this.colVatDesc.setColumnDuplicable(true);
        this.colVatDesc.setColumnName("vatDescriptionSYS10");
        this.colVatDesc.setColumnRequired(false);
        this.colVatDesc.setColumnSortable(false);
        this.colVatDesc.setEditableOnInsert(false);
        this.colVatDesc.setPreferredWidth(150);
        this.colVatValue.setColumnDuplicable(true);
        this.colVatValue.setColumnFilterable(true);
        this.colVatValue.setColumnName("vatValueREG01");
        this.colVatValue.setColumnRequired(false);
        this.colVatValue.setColumnSortable(true);
        this.colVatValue.setEditableOnEdit(false);
        this.colVatValue.setPreferredWidth(80);
        this.colCompanycode.setColumnDuplicable(true);
        this.colCompanycode.setColumnFilterable(true);
        this.colCompanycode.setColumnName("companyCodeSys01SAL09");
        this.colCompanycode.setColumnSortable(true);
        this.colCompanycode.setEditableOnInsert(true);
        this.colCompanycode.setPreferredWidth(100);
        this.colCompanycode.setSortVersus("ASC");
        this.colCompanycode.setSortingOrder(0);
        this.colCompanycode.setFunctionCode("SAL09");
        this.colVatDeductible.setColumnDuplicable(true);
        this.colVatDeductible.setColumnFilterable(true);
        this.colVatDeductible.setColumnName("vatDeductibleREG01");
        this.colVatDeductible.setColumnRequired(false);
        this.colVatDeductible.setColumnSortable(true);
        this.colVatDeductible.setPreferredWidth(80);
        this.getContentPane().add((Component)this.buttonsPanel, "North");
        this.buttonsPanel.add((Component)this.insertButton, null);
        this.buttonsPanel.add((Component)this.editButton, null);
        this.buttonsPanel.add((Component)this.saveButton, null);
        this.buttonsPanel.add((Component)this.reloadButton, null);
        this.buttonsPanel.add((Component)this.deleteButton, null);
        this.buttonsPanel.add((Component)this.exportButton, null);
        this.buttonsPanel.add((Component)this.navigatorBar, null);
        this.getContentPane().add((Component)this.grid, "Center");
        this.grid.getColumnContainer().add((Component)((Object)this.colCompanycode), null);
        this.grid.getColumnContainer().add((Component)this.colSaleActivity, null);
        this.grid.getColumnContainer().add((Component)this.colDescr, null);
        this.grid.getColumnContainer().add((Component)this.colCurrencyCod, null);
        this.grid.getColumnContainer().add((Component)this.colValue, null);
        this.grid.getColumnContainer().add((Component)this.colVatCode, null);
        this.grid.getColumnContainer().add((Component)this.colVatDesc, null);
        this.grid.getColumnContainer().add((Component)this.colVatValue, null);
        this.grid.getColumnContainer().add((Component)this.colVatDeductible, null);
    }

    public final void reloadData() {
        this.grid.reloadData();
    }
}

