/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.charges.client;

import java.util.ArrayList;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.sales.charges.client.ChargesGridFrame;
import org.jallinone.sales.charges.java.ChargeVO;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.util.client.ClientUtils;

public class ChargesController
extends CompanyGridController {
    private ChargesGridFrame gridFrame = new ChargesGridFrame(this);

    public ChargesController() {
        MDIFrame.add((InternalFrame)this.gridFrame, (boolean)true);
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deleteCharges", (Object)persistentObjects);
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        ChargeVO vo = null;
        Response res = null;
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
        ArrayList companiesList = bca.getCompaniesList("SAL06");
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (ChargeVO)((Object)newValueObjects.get(i));
            res = this.validateCharge(vo);
            if (res.isError()) {
                return res;
            }
            if (vo.getCompanyCodeSys01SAL06() == null) {
                vo.setCompanyCodeSys01SAL06(companiesList.get(0).toString());
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertCharges", (Object)newValueObjects);
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        ChargeVO vo = null;
        Response res = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (ChargeVO)((Object)persistentObjects.get(i));
            res = this.validateCharge(vo);
            if (res.isError()) {
                return res;
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateCharges", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        ChargeVO vo = (ChargeVO)this.gridFrame.getGrid().getVOListTableModel().getObjectForRow(rowNumber);
        if (attributeName.equals("percSAL06") && newValue != null) {
            vo.setVatCodeReg01SAL06(null);
            vo.setVatDeductibleREG01(null);
            vo.setVatDescriptionSYS10(null);
            vo.setVatValueREG01(null);
        }
        return true;
    }

    private Response validateCharge(ChargeVO vo) {
        if (vo.getPercSAL06() == null && vo.getValueSAL06() == null) {
            return new ErrorResponse("you must define a value or a percentage charge.");
        }
        if (vo.getPercSAL06() != null && vo.getValueSAL06() != null) {
            return new ErrorResponse("a charge must be define as a value or as a percentage.");
        }
        if (vo.getValueSAL06() != null && vo.getVatCodeReg01SAL06() == null) {
            return new ErrorResponse("vat code is required for a charge expressed as a value.");
        }
        return new VOResponse((Object)Boolean.TRUE);
    }
}

