/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.discounts.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.sales.discounts.client.HierarItemDiscountsFrame;
import org.jallinone.sales.discounts.java.HierarItemDiscountVO;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.tree.client.TreeController;
import org.openswing.swing.util.client.ClientUtils;

public class HierarItemDiscountsController
extends CompanyGridController
implements TreeController {
    private HierarItemDiscountsFrame frame = new HierarItemDiscountsFrame(this);

    public HierarItemDiscountsController() {
        MDIFrame.add((InternalFrame)this.frame, (boolean)true);
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        HierarItemDiscountVO vo = (HierarItemDiscountVO)valueObject;
        vo.setMinQtySAL03(new BigDecimal(1.0));
        vo.setMultipleQtySAL03(Boolean.FALSE);
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        Response response = ClientUtils.getData((String)"deleteHierarItemDiscounts", (Object)persistentObjects);
        return response;
    }

    public void doubleClick(DefaultMutableTreeNode node) {
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        HierarItemDiscountVO vo = null;
        DefaultMutableTreeNode node = this.frame.getHierarTreePanel().getSelectedNode();
        HierarchyLevelVO levelVO = (HierarchyLevelVO)((Object)node.getUserObject());
        HierarchyLevelVO root = (HierarchyLevelVO)((Object)((DefaultMutableTreeNode)node.getRoot()).getUserObject());
        Response response = null;
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (HierarItemDiscountVO)((Object)newValueObjects.get(i));
            vo.setProgressiveHie01SAL05(levelVO.getProgressiveHIE01());
            response = this.validateDiscount(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        response = ClientUtils.getData((String)"insertHierarItemDiscounts", (Object)newValueObjects);
        return response;
    }

    public void leftClick(DefaultMutableTreeNode node) {
        HierarchyLevelVO vo = (HierarchyLevelVO)((Object)node.getUserObject());
        HierarchyLevelVO root = (HierarchyLevelVO)((Object)((DefaultMutableTreeNode)node.getRoot()).getUserObject());
        this.frame.getGrid().getOtherGridParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02HIE01());
        this.frame.getGrid().getOtherGridParams().put("PROGRESSIVE_HIE01", vo.getProgressiveHIE01());
        this.frame.getGrid().getOtherGridParams().put("ROOT_PROGRESSIVE_HIE01", root.getProgressiveHIE01());
        this.frame.getGrid().reloadData();
    }

    public boolean rightClick(DefaultMutableTreeNode node) {
        return true;
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        Response response = null;
        HierarItemDiscountVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (HierarItemDiscountVO)((Object)persistentObjects.get(i));
            response = this.validateDiscount(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        response = ClientUtils.getData((String)"updateHierarItemDiscounts", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
        return response;
    }

    private Response validateDiscount(HierarItemDiscountVO vo) {
        if (vo.getMinValueSAL03() != null && vo.getMaxValueSAL03() == null || vo.getMinValueSAL03() == null && vo.getMaxValueSAL03() != null) {
            return new ErrorResponse("max and min values must be both setted.");
        }
        if (vo.getMinPercSAL03() != null && vo.getMaxPercSAL03() == null || vo.getMinPercSAL03() == null && vo.getMaxPercSAL03() != null) {
            return new ErrorResponse("max and min percentages must be both setted.");
        }
        if (vo.getMinValueSAL03() == null && vo.getMaxValueSAL03() == null && vo.getMinPercSAL03() == null && vo.getMaxPercSAL03() == null) {
            return new ErrorResponse("you must define max and min percentages or max and min values.");
        }
        if (vo.getMinValueSAL03() != null && vo.getMaxValueSAL03() != null) {
            if (vo.getMinPercSAL03() != null || vo.getMaxPercSAL03() != null) {
                return new ErrorResponse("you must define max and min percentages otherwise max and min values.");
            }
            if (vo.getMinValueSAL03().doubleValue() > vo.getMaxValueSAL03().doubleValue()) {
                return new ErrorResponse("min value must be less than or equals to max value.");
            }
        }
        if (vo.getMinPercSAL03() != null && vo.getMaxPercSAL03() != null) {
            if (vo.getMinValueSAL03() != null || vo.getMaxValueSAL03() != null) {
                return new ErrorResponse("you must define max and min percentages otherwise max and min values.");
            }
            if (vo.getMinPercSAL03().doubleValue() > vo.getMaxPercSAL03().doubleValue()) {
                return new ErrorResponse("min percentage must be less than or equals to max percentage.");
            }
        }
        if (vo.getStartDateSAL03().getTime() > vo.getEndDateSAL03().getTime()) {
            return new ErrorResponse("start date must be less than or equals to end date.");
        }
        return new VOResponse((Object)new Boolean(true));
    }
}

