/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jallinone.sales.documents.client.SaleDeskHeadDiscountPanel_controlDiscPerc_focusAdapter;
import org.jallinone.sales.documents.client.SaleDeskHeadDiscountPanel_controlDiscValue_focusAdapter;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.openswing.swing.client.CurrencyControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.NumericControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class SaleDeskHeadDiscountPanel
extends JPanel {
    NumericControl controlDiscPerc;
    CurrencyControl controlDiscValue = new CurrencyControl();
    GridBagLayout gridBagLayout1;
    LabelControl labelDiscPerc;
    LabelControl labelDiscValue = new LabelControl();
    private Form parentForm = null;
    TitledBorder titledBorder1;

    public SaleDeskHeadDiscountPanel(Form parentForm) {
        this.labelDiscPerc = new LabelControl();
        this.controlDiscPerc = new NumericControl();
        this.gridBagLayout1 = new GridBagLayout();
        this.parentForm = parentForm;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void controlDiscPerc_focusLost(FocusEvent e) {
        DetailSaleDocVO vo = (DetailSaleDocVO)this.parentForm.getVOModel().getValueObject();
        if (this.controlDiscPerc.getValue() != null && this.controlDiscValue.getValue() != null) {
            vo.setDiscountValueDOC01(null);
        }
        vo.setDiscountPercDOC01(this.controlDiscPerc.getBigDecimal());
        this.recalculateTotals();
    }

    void controlDiscValue_focusLost(FocusEvent e) {
        DetailSaleDocVO vo = (DetailSaleDocVO)this.parentForm.getVOModel().getValueObject();
        if (this.controlDiscPerc.getValue() != null && this.controlDiscValue.getValue() != null) {
            vo.setDiscountPercDOC01(null);
        }
        vo.setDiscountValueDOC01(this.controlDiscValue.getBigDecimal());
        this.recalculateTotals();
    }

    public CurrencyControl getControlDiscValue() {
        return this.controlDiscValue;
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.controlDiscPerc.setMinValue(0.0);
        this.controlDiscPerc.setMaxValue(100.0);
        this.controlDiscPerc.setLinkLabel(this.labelDiscPerc);
        this.controlDiscPerc.setDecimals(2);
        this.controlDiscPerc.setCanCopy(true);
        this.controlDiscPerc.setAttributeName("discountPercDOC01");
        this.controlDiscPerc.addFocusListener((FocusListener)new SaleDeskHeadDiscountPanel_controlDiscPerc_focusAdapter(this));
        this.labelDiscPerc.setText("discount perc");
        this.labelDiscValue.setText("discount value");
        this.controlDiscValue.setDecimals(5);
        this.controlDiscValue.setCanCopy(true);
        this.controlDiscValue.setAttributeName("discountValueDOC01");
        this.controlDiscValue.addFocusListener((FocusListener)new SaleDeskHeadDiscountPanel_controlDiscValue_focusAdapter(this));
        this.controlDiscValue.setLinkLabel(this.labelDiscValue);
        this.titledBorder1.setTitle(ClientSettings.getInstance().getResources().getResource("discounts"));
        this.titledBorder1.setTitleColor(Color.blue);
        this.setBorder(this.titledBorder1);
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.controlDiscValue, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelDiscValue, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelDiscPerc, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlDiscPerc, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void recalculateTotals() {
        DetailSaleDocVO vo = (DetailSaleDocVO)this.parentForm.getVOModel().getValueObject();
        Response res = ClientUtils.getData((String)"getSaleDocTotals", (Object)((Object)vo));
        if (res.isError()) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)this), ClientSettings.getInstance().getResources().getResource("Error while loading data") + ":\n" + res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Loading Data Error"), 0);
        } else {
            DetailSaleDocVO newVO = (DetailSaleDocVO)((Object)((VOResponse)res).getVo());
            vo.setTotalDOC01(newVO.getTotalDOC01());
            vo.setTaxableIncomeDOC01(newVO.getTaxableIncomeDOC01());
            vo.setTotalVatDOC01(newVO.getTotalVatDOC01());
            this.parentForm.pull();
        }
    }
}

