/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.documents.invoices.client;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.sales.documents.invoices.client.SaleInvoiceDocFrame;
import org.jallinone.sales.documents.invoices.client.SaleInvoiceDocsFrame;
import org.jallinone.sales.documents.java.DetailSaleDocRowVO;
import org.jallinone.sales.documents.java.DetailSaleDocVO;
import org.jallinone.sales.documents.java.SaleDocPK;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class SaleInvoiceDocController
extends CompanyFormController {
    private SaleInvoiceDocFrame frame = null;
    private SaleInvoiceDocsFrame parentFrame = null;
    private SaleDocPK pk = null;

    public SaleInvoiceDocController(SaleInvoiceDocsFrame parentFrame, SaleDocPK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new SaleInvoiceDocFrame(this);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getHeaderFormPanel().setMode(0);
            this.frame.getHeaderFormPanel().executeReload();
        } else {
            this.frame.getHeaderFormPanel().insert();
        }
    }

    public void afterInsertData() {
        if (this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        DetailSaleDocVO vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        this.frame.getRowsPanel().setParentVO(vo);
        this.frame.getRowsPanel().getGrid().getOtherGridParams().put("SALE_DOC_PK", this.pk);
        this.frame.getRowsPanel().getGrid().reloadData();
        this.frame.getDiscPanel().setParentVO(vo);
        this.frame.getDiscPanel().getGrid().getOtherGridParams().put("SALE_DOC_PK", this.pk);
        this.frame.getDiscPanel().getGrid().reloadData();
        this.frame.getChargePanel().setParentVO(vo);
        this.frame.getChargePanel().getGrid().getOtherGridParams().put("SALE_DOC_PK", this.pk);
        this.frame.getChargePanel().getGrid().reloadData();
        this.frame.getActPanel().setParentVO(vo);
        this.frame.getActPanel().getGrid().getOtherGridParams().put("SALE_DOC_PK", this.pk);
        this.frame.getActPanel().getGrid().reloadData();
        this.frame.setButtonsEnabled(true);
    }

    public boolean beforeDeleteData(Form form) {
        if (!super.beforeDeleteData(form)) {
            return false;
        }
        DetailSaleDocVO vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC01().equals("D");
    }

    public boolean beforeEditData(Form form) {
        if (!super.beforeEditData(form)) {
            return false;
        }
        DetailSaleDocVO vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject();
        return !vo.getDocStateDOC01().equals("D");
    }

    public boolean beforeInsertData(Form form) {
        boolean ok = super.beforeInsertData(form);
        if (ok) {
            this.frame.getRowsPanel().getGrid().clearData();
            this.frame.getRowsPanel().getDetailPanel().getVOModel().setValueObject((ValueObject)new DetailSaleDocRowVO());
            this.frame.getRowsPanel().getDetailPanel().pull();
            this.frame.getDiscPanel().getGrid().clearData();
            this.frame.getChargePanel().getGrid().clearData();
            this.frame.getActPanel().getGrid().clearData();
            this.frame.setButtonsEnabled(false);
        }
        return ok;
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailSaleDocVO vo = (DetailSaleDocVO)persistentObject;
        Calendar cal = Calendar.getInstance();
        vo.setDocYearDOC01(new BigDecimal((double)cal.get(1)));
        vo.setDocDateDOC01(new Date(System.currentTimeMillis()));
        vo.setDocTypeDOC01("I");
        vo.setDocStateDOC01("O");
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
        ArrayList companiesList = bca.getCompaniesList("DOC01_INV");
        if (companiesList.size() > 0) {
            String warCode;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("COMPANY_CODE_SYS01", companiesList.get(0));
            map.put("PARAM_CODE", "WAREHOUSE_CODE");
            Response res = ClientUtils.getData((String)"loadUserParam", map);
            if (!res.isError() && (warCode = (String)((VOResponse)res).getVo()) != null) {
                vo.setWarehouseCodeWar01DOC01(warCode);
            }
        }
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<SaleDocPK> pks = new ArrayList<SaleDocPK>();
        DetailSaleDocVO vo = (DetailSaleDocVO)persistentObject;
        pks.add(this.pk);
        Response res = ClientUtils.getData((String)"deleteSaleDocs", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.getRowsPanel().getGrid().clearData();
            this.frame.getDiscPanel().getGrid().clearData();
            this.frame.getChargePanel().getGrid().clearData();
            this.frame.getActPanel().getGrid().clearData();
        }
        return res;
    }

    public SaleInvoiceDocsFrame getParentFrame() {
        return this.parentFrame;
    }

    public SaleDocPK getPk() {
        return this.pk;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"insertSaleDoc", (Object)newPersistentObject);
        if (!res.isError()) {
            DetailSaleDocVO vo = (DetailSaleDocVO)((Object)((VOResponse)res).getVo());
            this.pk = new SaleDocPK(vo.getCompanyCodeSys01DOC01(), vo.getDocTypeDOC01(), vo.getDocYearDOC01(), vo.getDocNumberDOC01());
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadSaleDoc", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public void modeChanged(int currentMode) {
        DetailSaleDocVO vo;
        if (currentMode == 1 && (vo = (DetailSaleDocVO)this.frame.getHeaderFormPanel().getVOModel().getValueObject()).getWarehouseCodeWar01DOC01() != null) {
            this.frame.getWarePanel().getWareController().forceValidate();
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updateSaleDoc", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError() && this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        return res;
    }
}

