/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sales.pricelist.client;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.commons.java.ApplicationConsts;
import org.jallinone.items.client.ItemsFrame;
import org.jallinone.items.java.GridItemVO;
import org.jallinone.sales.pricelist.client.ImportItems;
import org.jallinone.sales.pricelist.client.ImportItemsDialog;
import org.jallinone.sales.pricelist.client.PricelistFrame;
import org.jallinone.sales.pricelist.java.PriceVO;
import org.jallinone.sales.pricelist.java.PricelistVO;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class PricesController
extends CompanyGridController
implements ImportItems {
    private PricelistFrame frame = null;

    public PricesController(PricelistFrame frame) {
        this.frame = frame;
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        return ClientUtils.getData((String)"deletePrices", (Object)persistentObjects);
    }

    public boolean dropEnabled(String gridId) {
        if (!this.beforeInsertGrid(this.frame.getPricesGrid())) {
            return false;
        }
        if (gridId.equals(ApplicationConsts.ID_ITEMS_GRID.toString()) && this.frame.getGrid().getSelectedRow() != -1) {
            ItemsFrame f = (ItemsFrame)MDIFrame.getSelectedFrame();
            int[] rows = f.getGrid().getSelectedRows();
            GridItemVO vo = null;
            ArrayList<GridItemVO> list = new ArrayList<GridItemVO>();
            int i = 0;
            while (i < rows.length) {
                vo = (GridItemVO)f.getGrid().getVOListTableModel().getObjectForRow(rows[i]);
                list.add(vo);
                ++i;
            }
            new ImportItemsDialog(list, this);
            return true;
        }
        return false;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        PriceVO vo = null;
        Response response = null;
        PricelistVO pricelistVO = (PricelistVO)this.frame.getGrid().getVOListTableModel().getObjectForRow(this.frame.getGrid().getSelectedRow());
        int i = 0;
        while (i < newValueObjects.size()) {
            vo = (PriceVO)((Object)newValueObjects.get(i));
            if (vo.getCompanyCodeSys01SAL02() == null) {
                vo.setCompanyCodeSys01SAL02(pricelistVO.getCompanyCodeSys01SAL01());
            }
            if (vo.getPricelistCodeSal01SAL02() == null) {
                vo.setPricelistCodeSal01SAL02(pricelistVO.getPricelistCodeSAL01());
            }
            if ((response = this.validateDates(vo)).isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"insertPrices", (Object)newValueObjects);
    }

    public void saveItems(ArrayList items, java.util.Date startDate, java.util.Date endDate, BigDecimal price) {
        PricelistVO pricelistVO = (PricelistVO)this.frame.getGrid().getVOListTableModel().getObjectForRow(this.frame.getGrid().getSelectedRow());
        ArrayList<PriceVO> persistentObjects = new ArrayList<PriceVO>();
        GridItemVO vo = null;
        PriceVO priceVO = null;
        int i = 0;
        while (i < items.size()) {
            vo = (GridItemVO)((Object)items.get(i));
            priceVO = new PriceVO();
            priceVO.setCompanyCodeSys01SAL02(vo.getCompanyCodeSys01ITM01());
            priceVO.setEndDateSAL02(new Date(endDate.getTime()));
            priceVO.setItemCodeItm01SAL02(vo.getItemCodeITM01());
            priceVO.setItemDescriptionSYS10(vo.getDescriptionSYS10());
            priceVO.setPricelistCodeSal01SAL02(pricelistVO.getPricelistCodeSAL01());
            priceVO.setPricelistDescriptionSYS10(pricelistVO.getDescriptionSYS10());
            priceVO.setProgressiveHie02ITM01(vo.getProgressiveHie02ITM01());
            priceVO.setStartDateSAL02(new Date(startDate.getTime()));
            priceVO.setValueSAL02(price);
            persistentObjects.add(priceVO);
            ++i;
        }
        Response res = ClientUtils.getData((String)"insertPrices", persistentObjects);
        if (res.isError()) {
            JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource("Error while saving") + "\n" + res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("Saving Error"), 0);
        } else {
            this.frame.getPricesGrid().reloadData();
        }
        try {
            this.frame.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            // empty catch block
        }
        this.frame.toFront();
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        Response response = null;
        PriceVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (PriceVO)((Object)persistentObjects.get(i));
            response = this.validateDates(vo);
            if (response.isError()) {
                return response;
            }
            ++i;
        }
        return ClientUtils.getData((String)"updatePrices", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    private Response validateDates(PriceVO vo) {
        if (vo.getStartDateSAL02().getTime() > vo.getEndDateSAL02().getTime()) {
            return new ErrorResponse("start date must be less than or equals to end date.");
        }
        return new VOResponse((Object)new Boolean(true));
    }
}

