/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.activities.client;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.scheduler.activities.client.ScheduledActivitiesGridFrame;
import org.jallinone.scheduler.activities.client.ScheduledActivityDetailFrame;
import org.jallinone.scheduler.activities.java.ScheduledActivityPK;
import org.jallinone.scheduler.activities.java.ScheduledActivityVO;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.form.model.client.VOModel;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class ScheduledActivityController
extends CompanyFormController {
    private ScheduledActivityDetailFrame detailFrame = null;
    private GridControl grid = null;
    private ScheduledActivitiesGridFrame gridFrame = null;
    private ScheduledActivityPK pk = null;

    public ScheduledActivityController(GridControl grid, ScheduledActivitiesGridFrame gridFrame, ScheduledActivityPK pk, boolean crm) {
        this.grid = grid;
        this.gridFrame = gridFrame;
        this.pk = pk;
        this.detailFrame = new ScheduledActivityDetailFrame(this, gridFrame, crm);
        MDIFrame.add((InternalFrame)this.detailFrame);
        if (gridFrame != null) {
            this.detailFrame.setParentFrame(gridFrame);
            gridFrame.pushFrame(this.detailFrame);
        }
        if (pk != null) {
            this.detailFrame.getMainForm().setMode(0);
            this.detailFrame.getMainForm().getForm().executeReload();
        } else {
            this.detailFrame.getMainForm().insert();
        }
    }

    public void afterInsertData() {
        this.detailFrame.getTabbedPane().setEnabledAt(1, true);
        ScheduledActivityVO vo = (ScheduledActivityVO)this.detailFrame.getMainForm().getVOModel().getValueObject();
        ScheduledActivityPK pk = new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06());
        this.detailFrame.getResPanel().getItemsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getMacsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getDocsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getTasksGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getItemsGrid().reloadData();
        this.detailFrame.getResPanel().getMacsGrid().reloadData();
        this.detailFrame.getResPanel().getDocsGrid().reloadData();
        this.detailFrame.getResPanel().getTasksGrid().reloadData();
        this.detailFrame.getMainForm().getConfirmButton().setEnabled(true);
    }

    public void afterReloadData() {
    }

    public void createPersistentObject(ValueObject PersistentObject) throws Exception {
        ScheduledActivityVO vo = (ScheduledActivityVO)this.detailFrame.getMainForm().getVOModel().getValueObject();
        this.detailFrame.getMainForm().getControlCompaniesControl().getComboBox().setSelectedIndex(0);
        vo.setCompanyCodeSys01SCH06((String)this.detailFrame.getMainForm().getControlCompaniesControl().getValue());
        vo.setPrioritySCH06("N");
        vo.setCompletionPercSCH06(new BigDecimal(0.0));
        Calendar cal = Calendar.getInstance();
        vo.setEstimatedDurationSCH06(new BigDecimal(60.0));
        vo.setEstimatedEndDateSCH06(new Timestamp(cal.getTimeInMillis() + 3600000L));
        vo.setStartDateSCH06(new Timestamp(cal.getTimeInMillis()));
        vo.setActivityStateSCH06("O");
        vo.setActivityTypeSCH06("A");
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ScheduledActivityVO vo = (ScheduledActivityVO)persistentObject;
        ArrayList<ScheduledActivityPK> pks = new ArrayList<ScheduledActivityPK>();
        ScheduledActivityPK pk = new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06());
        pks.add(pk);
        Response response = ClientUtils.getData((String)"deleteScheduledActivities", pks);
        if (!response.isError()) {
            this.detailFrame.getTabbedPane().setEnabledAt(1, false);
            this.detailFrame.getResPanel().getItemsGrid().clearData();
            this.detailFrame.getResPanel().getMacsGrid().clearData();
            this.detailFrame.getResPanel().getDocsGrid().clearData();
            this.detailFrame.getResPanel().getTasksGrid().clearData();
            if (this.grid != null) {
                this.grid.reloadData();
            }
        }
        return response;
    }

    public TextControl getControlName_1Subject() {
        return this.detailFrame.getControlName_1Subject();
    }

    public TextControl getControlName_2Subject() {
        return this.detailFrame.getControlName_2Subject();
    }

    public ComboBoxControl getControlSubjectType() {
        return this.detailFrame.getControlSubjectType();
    }

    public ScheduledActivityDetailFrame getDetailFrame() {
        return this.detailFrame;
    }

    public VOModel getVOModel() {
        return this.detailFrame.getMainForm().getVOModel();
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        ScheduledActivityVO vo = (ScheduledActivityVO)newPersistentObject;
        vo.setEmailAddressSCH06((String)this.detailFrame.getMainForm().getControlEmail().getValue());
        vo.setFaxNumberSCH06((String)this.detailFrame.getMainForm().getControlFax().getValue());
        vo.setPhoneNumberSCH06((String)this.detailFrame.getMainForm().getControlPhone().getValue());
        Response response = ClientUtils.getData((String)"insertScheduledActivity", (Object)((Object)vo));
        if (!response.isError()) {
            vo = (ScheduledActivityVO)((Object)((VOResponse)response).getVo());
            this.detailFrame.getResPanel().setActVO(vo);
            if (this.grid != null) {
                this.grid.reloadData();
            }
        }
        return response;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadScheduledActivity", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        ScheduledActivityVO vo = (ScheduledActivityVO)this.detailFrame.getMainForm().getVOModel().getValueObject();
        this.detailFrame.getMainForm().getControlEmail().setValue((Object)vo.getEmailAddressSCH06());
        this.detailFrame.getMainForm().getControlFax().setValue((Object)vo.getFaxNumberSCH06());
        this.detailFrame.getMainForm().getControlPhone().setValue((Object)vo.getPhoneNumberSCH06());
        this.detailFrame.getResPanel().setActVO(vo);
        ScheduledActivityPK pk = new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06());
        this.detailFrame.getTabbedPane().setEnabledAt(1, true);
        this.detailFrame.getResPanel().getItemsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getItemsGrid().reloadData();
        this.detailFrame.getResPanel().getMacsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getMacsGrid().reloadData();
        this.detailFrame.getResPanel().getDocsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getDocsGrid().reloadData();
        this.detailFrame.getResPanel().getTasksGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.detailFrame.getResPanel().getTasksGrid().reloadData();
        if (!vo.getActivityStateSCH06().equals("D") && !vo.getActivityStateSCH06().equals("I")) {
            this.detailFrame.getMainForm().getConfirmButton().setEnabled(true);
        }
    }

    public void modeChanged(int currentMode) {
        if (currentMode == 0) {
            this.detailFrame.getMainForm().getControlEmail().setEnabled(false);
            this.detailFrame.getMainForm().getControlFax().setEnabled(false);
            this.detailFrame.getMainForm().getControlPhone().setEnabled(false);
        } else {
            this.detailFrame.getMainForm().getControlEmail().setEnabled(true);
            this.detailFrame.getMainForm().getControlFax().setEnabled(true);
            this.detailFrame.getMainForm().getControlPhone().setEnabled(true);
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        ScheduledActivityVO vo = (ScheduledActivityVO)persistentObject;
        vo.setEmailAddressSCH06((String)this.detailFrame.getMainForm().getControlEmail().getValue());
        vo.setFaxNumberSCH06((String)this.detailFrame.getMainForm().getControlFax().getValue());
        vo.setPhoneNumberSCH06((String)this.detailFrame.getMainForm().getControlPhone().getValue());
        Response response = ClientUtils.getData((String)"updateScheduledActivity", (Object)new ValueObject[]{oldPersistentObject, vo});
        if (!response.isError() && this.grid != null) {
            this.grid.reloadData();
        }
        return response;
    }
}

