/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.appointments.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jallinone.employees.java.DetailEmployeeVO;
import org.jallinone.employees.java.EmployeeCalendarVO;
import org.jallinone.scheduler.activities.client.ScheduledActivityController;
import org.jallinone.scheduler.activities.java.EmployeeActivityVO;
import org.jallinone.scheduler.activities.java.ScheduledActivityPK;
import org.jallinone.scheduler.activities.java.ScheduledActivityVO;
import org.jallinone.scheduler.activities.java.ScheduledEmployeeVO;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.message.send.java.GridParams;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class Day
extends JPanel {
    private final int appW = 400;
    private Hashtable appointments;
    private Date currentDay = Calendar.getInstance().getTime();
    private EmployeeCalendarVO empCalVO = null;
    private ArrayList empCalendar;
    private DetailEmployeeVO empVO = null;
    public final int hourH = 50;
    private final int hourW = 40;
    private int[] newApp = null;
    private ArrayList rows = new ArrayList();
    private int[] selectedApp = null;

    public Day() {
        this.appointments = new Hashtable();
        this.empCalendar = new ArrayList();
        this.setSize(4000, 1200);
        this.setPreferredSize(new Dimension(4000, 1200));
        this.setMinimumSize(new Dimension(4000, 1200));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (Day.this.newApp != null) {
                    ((Day)Day.this).newApp[2] = e.getX();
                    ((Day)Day.this).newApp[3] = e.getY();
                }
                Day.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            static /* synthetic */ Day access$100(2 x0) {
                return x0.Day.this;
            }

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && (e.getClickCount() == 1 || e.getClickCount() == 2)) {
                    Enumeration en = Day.this.appointments.keys();
                    int[] app = null;
                    Day.access$502(Day.this, null);
                    while (en.hasMoreElements()) {
                        app = (int[])en.nextElement();
                        if (e.getX() < app[0] || e.getX() > app[2] || e.getY() < app[1] || e.getY() > app[3]) continue;
                        Day.access$502(Day.this, app);
                        break;
                    }
                    Day.this.repaint();
                    if (Day.this.selectedApp != null && e.getClickCount() == 2) {
                        EmployeeActivityVO vo = (EmployeeActivityVO)((Object)Day.this.appointments.get(Day.this.selectedApp));
                        ScheduledActivityController c = new ScheduledActivityController(this, null, null, new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06()), false){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void afterDeleteData() {
                                super.afterDeleteData();
                                2.access$100(this.this$1).setEmployeeVO(Day.access$200(2.access$100(this.this$1)));
                            }

                            public void afterEditData() {
                                super.afterEditData();
                                2.access$100(this.this$1).setEmployeeVO(Day.access$200(2.access$100(this.this$1)));
                            }

                            public void afterInsertData() {
                                super.afterInsertData();
                                2.access$100(this.this$1).setEmployeeVO(Day.access$200(2.access$100(this.this$1)));
                            }
                        };
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                if (Day.this.newApp == null) {
                    Day.access$002(Day.this, new int[]{e.getX(), e.getY(), e.getX(), e.getY()});
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (Day.this.newApp == null || Day.this.newApp[1] >= Day.this.newApp[3]) {
                    Day.access$002(Day.this, null);
                    return;
                }
                ScheduledActivityController c = new ScheduledActivityController(this, null, null, null, false){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
                        Response response = super.insertRecord(newPersistentObject);
                        if (!response.isError()) {
                            ScheduledActivityVO vo = (ScheduledActivityVO)((Object)((VOResponse)response).getVo());
                            ScheduledEmployeeVO schEmpVO = new ScheduledEmployeeVO();
                            schEmpVO.setCompanyCodeSys01SCH07(vo.getCompanyCodeSys01SCH06());
                            schEmpVO.setDescriptionSYS10(Day.access$200(2.access$100(this.this$1)).getTaskDescriptionSYS10());
                            schEmpVO.setDurationSCH07(vo.getEstimatedDurationSCH06());
                            schEmpVO.setEmployeeCodeSCH01(Day.access$200(2.access$100(this.this$1)).getEmployeeCodeSCH01());
                            schEmpVO.setEndDateSCH07(vo.getEstimatedEndDateSCH06());
                            schEmpVO.setProgressiveReg04SCH07(Day.access$200(2.access$100(this.this$1)).getProgressiveReg04SCH01());
                            schEmpVO.setProgressiveSch06SCH07(vo.getProgressiveSCH06());
                            schEmpVO.setStartDateSCH07(vo.getStartDateSCH06());
                            schEmpVO.setTaskCodeREG07(Day.access$200(2.access$100(this.this$1)).getTaskCodeReg07SCH01());
                            ArrayList<ScheduledEmployeeVO> list = new ArrayList<ScheduledEmployeeVO>();
                            list.add(schEmpVO);
                            Response res = ClientUtils.getData((String)"insertScheduledEmployees", list);
                            if (res.isError()) {
                                return res;
                            }
                            2.access$100(this.this$1).setEmployeeVO(Day.access$200(2.access$100(this.this$1)));
                        }
                        return response;
                    }
                };
                ScheduledActivityVO vo = (ScheduledActivityVO)c.getDetailFrame().getMainForm().getVOModel().getValueObject();
                int h = Day.this.newApp[1] / 50;
                int m = (Day.this.newApp[1] - h * 50) * 69 / 50;
                Calendar cal = Calendar.getInstance();
                cal.setTime(Day.this.currentDay);
                cal.set(11, h);
                cal.set(12, m);
                vo.setStartDateSCH06(new Timestamp(cal.getTimeInMillis()));
                h = Day.this.newApp[3] / 50;
                m = (Day.this.newApp[3] - h * 50) * 60 / 50;
                cal.setTime(Day.this.currentDay);
                cal.set(11, h);
                cal.set(12, m);
                vo.setEstimatedEndDateSCH06(new Timestamp(cal.getTimeInMillis()));
                vo.setEstimatedDurationSCH06(new BigDecimal((double)((vo.getEstimatedEndDateSCH06().getTime() - vo.getStartDateSCH06().getTime()) / 60000L)));
                c.getDetailFrame().getMainForm().getForm().pull();
                Day.access$002(Day.this, null);
                Day.this.repaint();
            }
        });
    }

    static /* synthetic */ int[] access$002(Day x0, int[] x1) {
        x0.newApp = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(Day x0, int[] x1) {
        x0.selectedApp = x1;
        return x1;
    }

    public EmployeeCalendarVO getEmpCalVO() {
        return this.empCalVO;
    }

    private int getNextW(int startW, int start, int end) {
        Enumeration en = this.appointments.keys();
        int[] app = null;
        boolean found = false;
        while (en.hasMoreElements()) {
            app = (int[])en.nextElement();
            if ((start < app[1] || start > app[3]) && (end < app[1] || end > app[3])) continue;
            startW += 402;
            found = true;
            break;
        }
        if (found) {
            return startW;
        }
        return 0;
    }

    public void paint(Graphics g) {
        super.paint(g);
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(ClientSettings.getInstance().getResources().getDateMask(3));
        }
        catch (Exception ex) {
            // empty catch block
        }
        int startH = 0;
        int endH = 0;
        int startM = 0;
        int endM = 0;
        Calendar cal = Calendar.getInstance();
        g.setColor(ClientSettings.GRID_EDITABLE_CELL_BACKGROUND);
        g.fillRect(40, 0, this.getWidth() - 40, this.getHeight());
        if (this.empCalVO != null) {
            g.setColor(Color.lightGray);
            cal.setTime(this.empCalVO.getMorningStartHourSCH02() == null ? this.empCalVO.getAfternoonStartHourSCH02() : this.empCalVO.getMorningStartHourSCH02());
            startH = cal.get(11);
            startM = cal.get(12);
            g.fillRect(40, 0, this.getWidth() - 40, startH * 50 + startM * 50 / 60);
            cal.setTime(this.empCalVO.getMorningEndHourSCH02() == null ? this.empCalVO.getAfternoonStartHourSCH02() : this.empCalVO.getMorningEndHourSCH02());
            startH = cal.get(11);
            startM = cal.get(12);
            cal.setTime(this.empCalVO.getAfternoonStartHourSCH02() == null ? this.empCalVO.getMorningEndHourSCH02() : this.empCalVO.getAfternoonStartHourSCH02());
            endH = cal.get(11);
            endM = cal.get(12);
            g.fillRect(40, startH * 50 + startM * 50 / 60, this.getWidth() - 40, (endH - startH) * 50 + (endM - startM) * 50 / 60);
            g.setColor(Color.lightGray);
            cal.setTime(this.empCalVO.getAfternoonEndHourSCH02() == null ? this.empCalVO.getMorningEndHourSCH02() : this.empCalVO.getAfternoonEndHourSCH02());
            startH = cal.get(11);
            startM = cal.get(12);
            g.fillRect(40, startH * 50 + startM * 50 / 60, this.getWidth() - 40, this.getHeight() - (startH * 50 + startM * 50 / 60));
        }
        int i = 0;
        while (i < 24) {
            g.setColor(Color.lightGray);
            g.fill3DRect(0, i * 50, 40, 50, true);
            g.setColor(Color.gray);
            g.drawRect(40, i * 50, this.getWidth() - 40, 50);
            g.setColor(Color.black);
            g.drawString(String.valueOf(i) + ":00", 2, i * 50 + 12);
            ++i;
        }
        EmployeeActivityVO vo = null;
        int startW = 0;
        Calendar day = Calendar.getInstance();
        day.setTime(this.currentDay);
        this.appointments.clear();
        int i2 = 0;
        while (i2 < this.rows.size()) {
            vo = (EmployeeActivityVO)((Object)this.rows.get(i2));
            if (vo.getActivityTypeSCH06().equals("B") || vo.getActivityTypeSCH06().equals("H") || vo.getActivityTypeSCH06().equals("I")) {
                if (vo.getActivityTypeSCH06().equals("C")) {
                    g.setColor(new Color(240, 200, 200));
                } else if (vo.getActivityTypeSCH06().equals("A")) {
                    g.setColor(new Color(250, 210, 200));
                } else if (vo.getActivityTypeSCH06().equals("P")) {
                    g.setColor(new Color(240, 210, 200));
                } else if (vo.getActivityTypeSCH06().equals("M")) {
                    g.setColor(new Color(250, 220, 200));
                } else if (vo.getActivityTypeSCH06().equals("E")) {
                    g.setColor(new Color(240, 220, 200));
                } else if (vo.getActivityTypeSCH06().equals("F")) {
                    g.setColor(new Color(250, 230, 200));
                } else if (vo.getActivityTypeSCH06().equals("B")) {
                    g.setColor(new Color(230, 230, 230));
                } else if (vo.getActivityTypeSCH06().equals("H")) {
                    g.setColor(new Color(220, 220, 220));
                } else if (vo.getActivityTypeSCH06().equals("I")) {
                    g.setColor(new Color(225, 225, 225));
                } else {
                    g.setColor(new Color(240, 230, 200));
                }
                cal.setTime(vo.getStartDateSCH07());
                startH = 0;
                startM = 0;
                if (cal.get(5) == day.get(5)) {
                    startH = cal.get(11);
                    startM = cal.get(12);
                }
                cal.setTime(vo.getEndDateSCH07());
                endH = 24;
                endM = 60;
                if (cal.get(5) == day.get(5)) {
                    endH = cal.get(11);
                    endM = cal.get(12);
                }
                g.fillRect(40, startH * 50 + startM * 50 / 60, this.getWidth() - 40, (endH - startH) * 50 - startM * 50 / 60 + endM * 50 / 60);
                g.setColor(Color.gray);
                g.drawRect(40, startH * 50 + startM * 50 / 60, this.getWidth() - 40, (endH - startH) * 50 - startM * 50 / 60 + endM * 50 / 60);
                g.setColor(Color.black);
                g.drawString(sdf.format(vo.getStartDateSCH07()) + " - " + vo.getDescriptionSCH06(), 43, startH * 50 + startM * 50 / 60 + 14);
                this.appointments.put(new int[]{40, startH * 50 + startM * 50 / 60, this.getWidth() - 40, endH * 50 + endM * 50 / 60}, vo);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.rows.size()) {
            vo = (EmployeeActivityVO)((Object)this.rows.get(i3));
            if (!(vo.getActivityTypeSCH06().equals("B") || vo.getActivityTypeSCH06().equals("H") || vo.getActivityTypeSCH06().equals("I"))) {
                if (vo.getActivityTypeSCH06().equals("C")) {
                    g.setColor(new Color(240, 200, 200));
                } else if (vo.getActivityTypeSCH06().equals("A")) {
                    g.setColor(new Color(250, 210, 200));
                } else if (vo.getActivityTypeSCH06().equals("P")) {
                    g.setColor(new Color(240, 210, 200));
                } else if (vo.getActivityTypeSCH06().equals("M")) {
                    g.setColor(new Color(250, 220, 200));
                } else if (vo.getActivityTypeSCH06().equals("E")) {
                    g.setColor(new Color(240, 220, 200));
                } else if (vo.getActivityTypeSCH06().equals("F")) {
                    g.setColor(new Color(250, 230, 200));
                } else if (vo.getActivityTypeSCH06().equals("B")) {
                    g.setColor(new Color(230, 230, 230));
                } else if (vo.getActivityTypeSCH06().equals("H")) {
                    g.setColor(new Color(220, 220, 220));
                } else if (vo.getActivityTypeSCH06().equals("I")) {
                    g.setColor(new Color(225, 225, 225));
                } else {
                    g.setColor(new Color(240, 230, 200));
                }
                cal.setTime(vo.getStartDateSCH07());
                startH = 0;
                startM = 0;
                if (cal.get(5) == day.get(5)) {
                    startH = cal.get(11);
                    startM = cal.get(12);
                }
                cal.setTime(vo.getEndDateSCH07());
                endH = 24;
                endM = 60;
                if (cal.get(5) == day.get(5)) {
                    endH = cal.get(11);
                    endM = cal.get(12);
                }
                startW = this.getNextW(startW, startH * 50 + startM * 50 / 60, endH * 50 + endM * 50 / 60);
                g.fillRect(40 + startW, startH * 50 + startM * 50 / 60, 400, (endH - startH) * 50 - startM * 50 / 60 + endM * 50 / 60);
                g.setColor(Color.gray);
                g.drawRect(40 + startW, startH * 50 + startM * 50 / 60, 400, (endH - startH) * 50 - startM * 50 / 60 + endM * 50 / 60);
                g.setColor(Color.black);
                g.drawString(sdf.format(vo.getStartDateSCH07()) + " - " + vo.getDescriptionSCH06(), 40 + startW + 3, startH * 50 + startM * 50 / 60 + 14);
                this.appointments.put(new int[]{40 + startW, startH * 50 + startM * 50 / 60, 40 + startW + 400, endH * 50 + endM * 50 / 60}, vo);
            }
            ++i3;
        }
        if (this.selectedApp != null) {
            g.setColor(Color.black);
            g.drawRect(this.selectedApp[0], this.selectedApp[1], this.selectedApp[2] - this.selectedApp[0], this.selectedApp[3] - this.selectedApp[1]);
            g.drawRect(this.selectedApp[0] + 1, this.selectedApp[1] + 1, this.selectedApp[2] - this.selectedApp[0] - 2, this.selectedApp[3] - this.selectedApp[1] - 2);
        }
        if (this.newApp != null) {
            g.setColor(Color.gray);
            g.drawRect(this.newApp[0], this.newApp[1], this.newApp[2] - this.newApp[0], this.newApp[3] - this.newApp[1]);
        }
    }

    public void setCurrentDay(Date currentDay) {
        this.currentDay = currentDay;
        EmployeeCalendarVO vo = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDay);
        int i = 0;
        while (i < this.empCalendar.size()) {
            vo = (EmployeeCalendarVO)((Object)this.empCalendar.get(i));
            if (vo.getDayOfWeekSCH02().equals(String.valueOf(cal.get(7)))) {
                this.empCalVO = vo;
                break;
            }
            ++i;
        }
        if (this.empVO != null) {
            this.setEmployeeVO(this.empVO);
        }
    }

    public void setEmpCalendar(ArrayList empCalendar) {
        this.empCalendar = empCalendar;
        EmployeeCalendarVO vo = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.currentDay);
        int i = 0;
        while (i < empCalendar.size()) {
            vo = (EmployeeCalendarVO)((Object)empCalendar.get(i));
            if (vo.getDayOfWeekSCH02().equals(String.valueOf(cal.get(7)))) {
                this.empCalVO = vo;
                break;
            }
            ++i;
        }
    }

    public final void setEmployeeVO(DetailEmployeeVO empVO) {
        this.empVO = empVO;
        new Thread(){

            public void run() {
                GridParams gridParams = new GridParams();
                gridParams.getCurrentSortedColumns().add("startDateSCH07");
                gridParams.getCurrentSortedVersusColumns().add("ASC");
                gridParams.getOtherGridParams().put("DATE_FILTER", Day.this.currentDay);
                gridParams.getOtherGridParams().put("PROGRESSIVE_REG04", Day.this.empVO.getProgressiveReg04SCH01());
                Response res = ClientUtils.getData((String)"loadEmployeeActivities", (Object)gridParams);
                if (res.isError()) {
                    JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource(res.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 2);
                } else {
                    Day.access$502(Day.this, null);
                    Day.this.rows = new ArrayList(((VOListResponse)res).getRows());
                }
                Day.this.repaint();
            }
        }.start();
    }
}

