/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.callouts.client;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.scheduler.activities.java.ScheduledActivityPK;
import org.jallinone.scheduler.activities.java.ScheduledActivityVO;
import org.jallinone.scheduler.callouts.client.CallOutRequestFrame;
import org.jallinone.scheduler.callouts.java.DetailCallOutRequestVO;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class CallOutActivityController
extends CompanyFormController {
    private CallOutRequestFrame frame = null;

    public CallOutActivityController(CallOutRequestFrame frame) {
        this.frame = frame;
    }

    public void afterInsertData() {
        this.frame.getTab().setEnabledAt(3, true);
        ScheduledActivityVO vo = (ScheduledActivityVO)this.frame.getActPanel().getVOModel().getValueObject();
        ScheduledActivityPK pk = new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06());
        this.frame.getResourcesPanel().getItemsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getMacsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getDocsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getTasksGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getItemsGrid().reloadData();
        this.frame.getResourcesPanel().getMacsGrid().reloadData();
        this.frame.getResourcesPanel().getDocsGrid().reloadData();
        this.frame.getResourcesPanel().getTasksGrid().reloadData();
        this.frame.getActPanel().getConfirmButton().setEnabled(true);
        this.frame.getInvoiceButton().setEnabled(false);
    }

    public void afterReloadData() {
    }

    public void createPersistentObject(ValueObject PersistentObject) throws Exception {
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)this.frame.getCalloutPanel().getVOModel().getValueObject();
        ScheduledActivityVO actVO = (ScheduledActivityVO)this.frame.getActPanel().getVOModel().getValueObject();
        actVO.setCompanyCodeSys01SCH06(vo.getCompanyCodeSys01SCH03());
        actVO.setPrioritySCH06("N");
        actVO.setCompletionPercSCH06(new BigDecimal(0.0));
        Calendar cal = Calendar.getInstance();
        actVO.setEstimatedDurationSCH06(new BigDecimal(60.0));
        actVO.setEstimatedEndDateSCH06(new Timestamp(cal.getTimeInMillis() + 3600000L));
        actVO.setProgressiveReg04SubjectSCH06(vo.getProgressiveReg04SCH03());
        actVO.setStartDateSCH06(new Timestamp(cal.getTimeInMillis()));
        actVO.setActivityStateSCH06("O");
        actVO.setActivityTypeSCH06("C");
        actVO.setDescriptionSCH06(vo.getDescriptionSCH03());
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ScheduledActivityVO vo = (ScheduledActivityVO)persistentObject;
        ArrayList<ScheduledActivityPK> pks = new ArrayList<ScheduledActivityPK>();
        ScheduledActivityPK pk = new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06());
        pks.add(pk);
        Response response = ClientUtils.getData((String)"deleteScheduledActivities", pks);
        if (!response.isError()) {
            this.frame.getTab().setEnabledAt(3, false);
            this.frame.getResourcesPanel().getItemsGrid().clearData();
            this.frame.getResourcesPanel().getMacsGrid().clearData();
            this.frame.getResourcesPanel().getDocsGrid().clearData();
            this.frame.getResourcesPanel().getTasksGrid().clearData();
            DetailCallOutRequestVO detVO = (DetailCallOutRequestVO)this.frame.getCalloutPanel().getVOModel().getValueObject();
            detVO.setProgressiveSch06SCH03(null);
            this.frame.getConfirmButton().setEnabled(true);
            this.frame.getActPanel().getConfirmButton().setEnabled(false);
            this.frame.getInvoiceButton().setEnabled(false);
        }
        return response;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)this.frame.getCalloutPanel().getVOModel().getValueObject();
        vo.setScheduledActivityVO((ScheduledActivityVO)newPersistentObject);
        Response response = ClientUtils.getData((String)"linkScheduledActivityToCallOutRequest", (Object)((Object)vo));
        if (!response.isError()) {
            vo = (DetailCallOutRequestVO)((Object)((VOResponse)response).getVo());
            response = new VOResponse((Object)vo.getScheduledActivityVO());
            this.frame.getResourcesPanel().setActVO(vo.getScheduledActivityVO());
            this.frame.getCalloutPanel().getVOModel().setValueObject((ValueObject)vo);
            this.frame.getConfirmButton().setEnabled(false);
            this.frame.getInvoiceButton().setEnabled(false);
        }
        return response;
    }

    public Response loadData(Class valueObjectClass) {
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)this.frame.getCalloutPanel().getVOModel().getValueObject();
        return ClientUtils.getData((String)"loadScheduledActivity", (Object)new ScheduledActivityPK(vo.getCompanyCodeSys01SCH03(), vo.getProgressiveSch06SCH03()));
    }

    public void loadDataCompleted(boolean error) {
        ScheduledActivityVO vo = (ScheduledActivityVO)this.frame.getActPanel().getVOModel().getValueObject();
        this.frame.getResourcesPanel().setActVO(vo);
        ScheduledActivityPK pk = new ScheduledActivityPK(vo.getCompanyCodeSys01SCH06(), vo.getProgressiveSCH06());
        this.frame.getTab().setEnabledAt(3, true);
        this.frame.getResourcesPanel().getItemsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getItemsGrid().reloadData();
        this.frame.getResourcesPanel().getMacsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getMacsGrid().reloadData();
        this.frame.getResourcesPanel().getDocsGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getDocsGrid().reloadData();
        this.frame.getResourcesPanel().getTasksGrid().getOtherGridParams().put("SCHEDULED_ACTIVITY_PK", pk);
        this.frame.getResourcesPanel().getTasksGrid().reloadData();
        if (!vo.getActivityStateSCH06().equals("D") && !vo.getActivityStateSCH06().equals("I")) {
            this.frame.getActPanel().getConfirmButton().setEnabled(true);
            this.frame.getInvoiceButton().setEnabled(false);
        } else if (vo.getActivityStateSCH06().equals("D")) {
            this.frame.getInvoiceButton().setEnabled(true);
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response response = ClientUtils.getData((String)"updateScheduledActivity", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        return response;
    }
}

