/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.callouts.client;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.commons.client.CompanyFormController;
import org.jallinone.scheduler.activities.java.ScheduledActivityVO;
import org.jallinone.scheduler.callouts.client.CallOutRequestFrame;
import org.jallinone.scheduler.callouts.client.CallOutRequestsFrame;
import org.jallinone.scheduler.callouts.java.CallOutRequestPK;
import org.jallinone.scheduler.callouts.java.DetailCallOutRequestVO;
import org.jallinone.subjects.java.Subject;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class CallOutRequestController
extends CompanyFormController {
    private CallOutRequestFrame frame = null;
    private CallOutRequestsFrame parentFrame = null;
    private CallOutRequestPK pk = null;

    public CallOutRequestController(CallOutRequestsFrame parentFrame, CallOutRequestPK pk) {
        this.parentFrame = parentFrame;
        this.pk = pk;
        this.frame = new CallOutRequestFrame(this, parentFrame);
        MDIFrame.add((InternalFrame)this.frame);
        if (parentFrame != null) {
            this.frame.setParentFrame(parentFrame);
            parentFrame.pushFrame(this.frame);
        }
        if (pk != null) {
            this.frame.getCalloutPanel().setMode(0);
            this.frame.getCalloutPanel().executeReload();
        } else {
            this.frame.getCalloutPanel().insert();
            this.frame.getControlCompaniesCombo().getComboBox().setSelectedIndex(0);
            int i = 1;
            while (i < this.frame.getTab().getTabCount()) {
                this.frame.getTab().setEnabledAt(i, false);
                ++i;
            }
            this.frame.getControlSubjectType().getComboBox().setSelectedIndex(0);
            this.frame.getSubjectForm().insert();
        }
    }

    public void createPersistentObject(ValueObject persistentObject) throws Exception {
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)persistentObject;
        MDIFrame.getInstance();
        ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
        vo.setSubjectTypeReg04SCH03((String)this.frame.getControlSubjectType().getValue());
        vo.setRequestDateSCH03(new Timestamp(System.currentTimeMillis()));
        vo.setCallOutStateSCH03("O");
        vo.setPrioritySCH03("N");
        vo.setRequestYearSCH03(new BigDecimal((double)(vo.getRequestDateSCH03().getYear() + 1900)));
        vo.setUsernameSys03SCH03(applet.getUsername());
        this.frame.getControlCallOutType().getComboBox().setSelectedIndex(0);
        vo.setProgressiveHie02SCH10((BigDecimal)this.frame.getControlCallOutType().getValue());
    }

    public Response deleteRecord(ValueObject persistentObject) throws Exception {
        ArrayList<CallOutRequestPK> pks = new ArrayList<CallOutRequestPK>();
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)persistentObject;
        CallOutRequestPK pk = new CallOutRequestPK(vo.getCompanyCodeSys01SCH03(), vo.getRequestYearSCH03(), vo.getProgressiveSCH03());
        pks.add(pk);
        Response res = ClientUtils.getData((String)"deleteCallOutRequests", pks);
        if (!res.isError()) {
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.setButtonsEnabled(false);
        }
        return res;
    }

    public Response insertRecord(ValueObject newPersistentObject) throws Exception {
        DetailCallOutRequestVO vo = (DetailCallOutRequestVO)newPersistentObject;
        Subject subVO = (Subject)this.frame.getSubjectForm().getVOModel().getValueObject();
        vo.setCompanyCodeSys01SCH03(subVO.getCompanyCodeSys01REG04());
        vo.setProgressiveReg04SCH03(subVO.getProgressiveREG04());
        Response res = ClientUtils.getData((String)"insertCallOutRequest", (Object)newPersistentObject);
        if (!res.isError()) {
            vo = (DetailCallOutRequestVO)((Object)((VOResponse)res).getVo());
            this.pk = new CallOutRequestPK(vo.getCompanyCodeSys01SCH03(), vo.getRequestYearSCH03(), vo.getProgressiveSCH03());
            if (this.parentFrame != null) {
                this.parentFrame.getGrid().reloadData();
            }
            this.frame.setButtonsEnabled(true);
            this.frame.getTab().setEnabledAt(2, true);
            this.frame.getActPanel().insert();
            this.frame.getActPanel().getControlActType().setValue((Object)"C");
            this.frame.getActPanel().getControlDescr().setValue((Object)vo.getDescriptionSCH03());
            ScheduledActivityVO actVO = (ScheduledActivityVO)this.frame.getActPanel().getVOModel().getValueObject();
            actVO.setCompanyCodeSys01SCH06(vo.getCompanyCodeSys01SCH03());
            this.frame.getConfirmButton().setEnabled(true);
            this.frame.getInvoiceButton().setEnabled(false);
            this.frame.getViewInvoiceButton().setEnabled(false);
        }
        return res;
    }

    public Response loadData(Class valueObjectClass) {
        return ClientUtils.getData((String)"loadCallOutRequest", (Object)this.pk);
    }

    public void loadDataCompleted(boolean error) {
        this.frame.loadDataCompleted(error, this.pk);
    }

    public void modeChanged(int currentMode) {
        if (currentMode == 1) {
            this.frame.getConfirmButton().setEnabled(false);
            this.frame.getInvoiceButton().setEnabled(false);
            this.frame.getViewInvoiceButton().setEnabled(false);
        }
    }

    public Response updateRecord(ValueObject oldPersistentObject, ValueObject persistentObject) throws Exception {
        Response res = ClientUtils.getData((String)"updateCallOutRequest", (Object)new ValueObject[]{oldPersistentObject, persistentObject});
        if (!res.isError() && this.parentFrame != null) {
            this.parentFrame.getGrid().reloadData();
        }
        return res;
    }
}

