/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.scheduler.gantt.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jallinone.scheduler.gantt.client.ActivityGanttController;
import org.jallinone.scheduler.gantt.client.ActivityGanttFrame_controlFrom_focusAdapter;
import org.jallinone.scheduler.gantt.client.ActivityGanttFrame_controlTo_focusAdapter;
import org.jallinone.scheduler.gantt.client.ActivityGanttFrame_viewButton_actionAdapter;
import org.openswing.swing.client.DateControl;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.gantt.client.AppointmentChangeListener;
import org.openswing.swing.gantt.client.GanttControl;
import org.openswing.swing.gantt.client.GanttDataLocator;
import org.openswing.swing.gantt.client.ServerGanttDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class ActivityGanttFrame
extends InternalFrame {
    DateControl controlFrom;
    DateControl controlTo;
    private ActivityGanttController controller = null;
    JPanel filterPanel;
    GanttControl gantt = new GanttControl();
    private ServerGanttDataLocator ganttDataLocator;
    GridBagLayout gridBagLayout1;
    LabelControl labelFrom;
    LabelControl labelTo;
    GenericButton viewButton;

    public ActivityGanttFrame(boolean canInsert, Date startDate, Date endDate, ActivityGanttController controller) {
        this.filterPanel = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.labelFrom = new LabelControl();
        this.controlFrom = new DateControl();
        this.labelTo = new LabelControl();
        this.controlTo = new DateControl();
        this.ganttDataLocator = new ServerGanttDataLocator();
        this.viewButton = new GenericButton(new ImageIcon(ClientUtils.getImage((String)"gantt.gif")));
        this.controller = controller;
        try {
            this.jbInit();
            this.gantt.init(new String[]{"", "", ClientSettings.getInstance().getResources().getResource("employees")});
            this.gantt.setGridColumnVisible(0, false);
            this.gantt.setGridColumnVisible(0, false);
            this.gantt.setGridEnabled(false);
            this.gantt.setEnableInsert(canInsert);
            this.gantt.setEnableEdit(!canInsert);
            this.gantt.setEnableDelete(false);
            this.gantt.setGanttDataLocator((GanttDataLocator)this.ganttDataLocator);
            this.ganttDataLocator.setServerMethodName("loadScheduledEmployeesOnGantt");
            this.gantt.addAppointmentChangeListener((AppointmentChangeListener)controller);
            this.controlFrom.setValue((Object)startDate);
            this.controlTo.setValue((Object)endDate);
            this.gantt.setStartDate(startDate);
            this.gantt.setEndDate(endDate);
            this.gantt.getGanttParameters().put("SCHEDULED_EMPLOYEE", controller.getEmpVO());
            this.gantt.getGanttParameters().put("START_DATE", this.controlFrom.getValue());
            this.gantt.getGanttParameters().put("END_DATE", this.controlTo.getValue());
            this.setSize(750, 500);
            this.setMinimumSize(new Dimension(750, 500));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void controlFrom_focusLost(FocusEvent e) {
        if (this.controlFrom.getValue() == null || this.controlFrom.getValue().equals(this.gantt.getStartDate())) {
            return;
        }
        this.gantt.setStartDate((Date)this.controlFrom.getValue());
    }

    void controlTo_focusLost(FocusEvent e) {
        if (this.controlTo.getValue() == null || this.controlTo.getValue().equals(this.gantt.getEndDate())) {
            return;
        }
        this.gantt.setEndDate((Date)this.controlTo.getValue());
    }

    public GanttControl getGantt() {
        return this.gantt;
    }

    private void jbInit() throws Exception {
        this.viewButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("reload data"));
        this.viewButton.addActionListener((ActionListener)new ActivityGanttFrame_viewButton_actionAdapter(this));
        this.filterPanel.setLayout(this.gridBagLayout1);
        this.labelFrom.setText("from date");
        this.labelTo.setText("to date");
        this.setTitle(ClientSettings.getInstance().getResources().getResource("gantt diagram") + " - " + ClientSettings.getInstance().getResources().getResource("employees having task") + " '" + this.controller.getEmpVO().getDescriptionSYS10() + "'");
        this.controlFrom.addFocusListener((FocusListener)new ActivityGanttFrame_controlFrom_focusAdapter(this));
        this.controlTo.addFocusListener((FocusListener)new ActivityGanttFrame_controlTo_focusAdapter(this));
        this.getContentPane().add((Component)this.gantt, "Center");
        this.getContentPane().add((Component)this.filterPanel, "North");
        this.filterPanel.add((Component)this.labelFrom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.labelTo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.controlTo, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.viewButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    void viewButton_actionPerformed(ActionEvent e) {
        if (this.controlFrom.getValue() == null || this.controlTo.getValue() == null) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("you must specify both dates"), ClientSettings.getInstance().getResources().getResource("Attention"), 0);
            return;
        }
        this.gantt.reloadData();
    }
}

