/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sqltool.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jallinone.sqltool.client.EntitiesListPanel_reloadButton_actionAdapter;
import org.jallinone.sqltool.client.TablePanel;
import org.jallinone.sqltool.java.TableVO;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CheckBoxColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class EntitiesListPanel
extends JPanel
implements ListSelectionListener,
GridDataLocator {
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2;
    BorderLayout borderLayout3;
    JPanel buttonsPanel = new JPanel();
    TextColumn colName;
    CheckBoxColumn colObl;
    CheckBoxColumn colPk;
    TextColumn colType;
    JPanel dataPanel;
    JTabbedPane detailTabbedPane;
    JTabbedPane entitiesTabbedPane;
    FlowLayout flowLayout1;
    GridControl grid;
    ReloadButton reloadButton;
    JList sinList;
    JScrollPane sinScrollPane;
    private boolean sinsAlreadyLoaded = false;
    JSplitPane splitPane = new JSplitPane();
    JPanel structurePanel;
    private TablePanel tablePanel = null;
    private boolean tablesAlreadyLoaded = false;
    JList tablesList;
    JScrollPane tablesScrollPane;
    private boolean viewsAlreadyLoaded = false;
    JList viewsList;
    JScrollPane viewsScrollPane;

    public EntitiesListPanel() {
        this.entitiesTabbedPane = new JTabbedPane(){

            public void setSelectedIndex(int index) {
                super.setSelectedIndex(index);
                EntitiesListPanel.this.entitiesTabbedPane_componentShown();
            }
        };
        this.detailTabbedPane = new JTabbedPane();
        this.tablesScrollPane = new JScrollPane();
        this.viewsScrollPane = new JScrollPane();
        this.sinScrollPane = new JScrollPane();
        this.tablesList = new JList();
        this.viewsList = new JList();
        this.sinList = new JList();
        this.structurePanel = new JPanel();
        this.dataPanel = new JPanel();
        this.borderLayout2 = new BorderLayout();
        this.borderLayout3 = new BorderLayout();
        this.flowLayout1 = new FlowLayout();
        this.reloadButton = new ReloadButton();
        this.grid = new GridControl();
        this.colName = new TextColumn();
        this.colType = new TextColumn();
        this.colPk = new CheckBoxColumn();
        this.colObl = new CheckBoxColumn();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void entitiesTabbedPane_componentShown() {
        if (this.entitiesTabbedPane.getSelectedIndex() == 0 && !this.tablesAlreadyLoaded) {
            this.tablesAlreadyLoaded = true;
            new LoadEntities("TABLE", this.tablesList);
        } else if (this.entitiesTabbedPane.getSelectedIndex() == 1 && !this.viewsAlreadyLoaded) {
            this.viewsAlreadyLoaded = true;
            new LoadEntities("VIEW", this.viewsList);
        } else if (this.entitiesTabbedPane.getSelectedIndex() == 2 && !this.sinsAlreadyLoaded) {
            this.sinsAlreadyLoaded = true;
            new LoadEntities("SYNONYM", this.sinList);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.tablesList.setSelectionMode(0);
        this.viewsList.setSelectionMode(0);
        this.sinList.setSelectionMode(0);
        this.structurePanel.setLayout(this.borderLayout2);
        this.dataPanel.setLayout(this.borderLayout3);
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.reloadButton.addActionListener((ActionListener)new EntitiesListPanel_reloadButton_actionAdapter(this));
        this.grid.setAutoLoadData(false);
        this.grid.setFunctionId("SQL");
        this.grid.setMaxSortedColumns(0);
        this.grid.setValueObjectClassName("org.jallinone.sqltool.java.ColumnVO");
        this.colName.setColumnName("columnNameWithoutTable");
        this.colName.setPreferredWidth(200);
        this.colType.setColumnName("columnType");
        this.colType.setPreferredWidth(150);
        this.colPk.setColumnName("primaryKey");
        this.colPk.setPreferredWidth(50);
        this.colObl.setColumnName("columnRequired");
        this.colObl.setPreferredWidth(50);
        this.add((Component)this.buttonsPanel, "North");
        this.add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.entitiesTabbedPane, "left");
        this.splitPane.add((Component)this.detailTabbedPane, "right");
        this.entitiesTabbedPane.add((Component)this.tablesScrollPane, "tables");
        this.entitiesTabbedPane.add((Component)this.viewsScrollPane, "views");
        this.entitiesTabbedPane.add((Component)this.sinScrollPane, "synonyms");
        this.tablesScrollPane.getViewport().add((Component)this.tablesList, null);
        this.viewsScrollPane.getViewport().add((Component)this.viewsList, null);
        this.sinScrollPane.getViewport().add((Component)this.sinList, null);
        this.detailTabbedPane.add((Component)this.structurePanel, "structure");
        this.structurePanel.add((Component)this.grid, "Center");
        this.detailTabbedPane.add((Component)this.dataPanel, "data");
        this.buttonsPanel.add((Component)this.reloadButton, null);
        this.grid.getColumnContainer().add((Component)this.colName, null);
        this.grid.getColumnContainer().add((Component)this.colType, null);
        this.grid.getColumnContainer().add((Component)this.colPk, null);
        this.grid.getColumnContainer().add((Component)this.colObl, null);
        this.splitPane.setDividerLocation(200);
        this.entitiesTabbedPane.setTitleAt(0, ClientSettings.getInstance().getResources().getResource("tables"));
        this.entitiesTabbedPane.setTitleAt(1, ClientSettings.getInstance().getResources().getResource("views"));
        this.entitiesTabbedPane.setTitleAt(2, ClientSettings.getInstance().getResources().getResource("synonyms"));
        this.detailTabbedPane.setTitleAt(0, ClientSettings.getInstance().getResources().getResource("structure"));
        this.detailTabbedPane.setTitleAt(1, ClientSettings.getInstance().getResources().getResource("data"));
        this.tablesList.addListSelectionListener(this);
        this.viewsList.addListSelectionListener(this);
        this.sinList.addListSelectionListener(this);
        this.grid.setController(new GridController());
        this.grid.setGridDataLocator((GridDataLocator)this);
    }

    public Response loadData(int action, int startIndex, Map filteredColumns, ArrayList currentSortedColumns, ArrayList currentSortedVersusColumns, Class valueObjectType, Map otherGridParams) {
        TableVO tableVO = this.tablePanel.getTableVO();
        ArrayList rows = tableVO.getColumns();
        return new VOListResponse((List)rows, false, rows.size());
    }

    void reloadButton_actionPerformed(ActionEvent e) {
        if (this.entitiesTabbedPane.getSelectedIndex() == 0) {
            new LoadEntities("TABLE", this.tablesList);
        } else if (this.entitiesTabbedPane.getSelectedIndex() == 1) {
            new LoadEntities("VIEW", this.viewsList);
        } else if (this.entitiesTabbedPane.getSelectedIndex() == 2) {
            new LoadEntities("SYNONYM", this.sinList);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            if (this.entitiesTabbedPane.getSelectedIndex() == 0 && this.tablesList.getSelectedValue() != null) {
                new LoadEntity(this.tablesList.getSelectedValue().toString());
            } else if (this.entitiesTabbedPane.getSelectedIndex() == 1 && this.viewsList.getSelectedValue() != null) {
                new LoadEntity(this.viewsList.getSelectedValue().toString());
            } else if (this.entitiesTabbedPane.getSelectedIndex() == 2 && this.sinList.getSelectedValue() != null) {
                new LoadEntity(this.sinList.getSelectedValue().toString());
            }
        }
    }

    class LoadEntity
    extends Thread {
        private String entity = null;

        public LoadEntity(String entity) {
            this.entity = entity;
            this.start();
        }

        public void run() {
            try {
                EntitiesListPanel.this.dataPanel.removeAll();
                ArrayList<String> mainTables = new ArrayList<String>();
                mainTables.add(this.entity);
                EntitiesListPanel.this.tablePanel = new TablePanel("select * from " + this.entity, mainTables, false, false, true);
                EntitiesListPanel.this.dataPanel.add((Component)EntitiesListPanel.this.tablePanel, "Center");
                EntitiesListPanel.this.dataPanel.revalidate();
                EntitiesListPanel.this.dataPanel.repaint();
                if (EntitiesListPanel.this.tablePanel.getTableVO() != null) {
                    EntitiesListPanel.this.grid.reloadData();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
            }
        }
    }

    class LoadEntities
    extends Thread {
        private JList entitiesList = null;
        private String entityType = null;

        public LoadEntities(String entityType, JList entitiesList) {
            this.entityType = entityType;
            this.entitiesList = entitiesList;
            this.start();
        }

        public void run() {
            try {
                Response res = ClientUtils.getData((String)"loadEntities", (Object)this.entityType);
                if (res.isError()) {
                    JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource(res.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 0);
                } else {
                    DefaultListModel model = new DefaultListModel();
                    List list = ((VOListResponse)res).getRows();
                    int i = 0;
                    while (i < list.size()) {
                        model.addElement(list.get(i));
                        ++i;
                    }
                    this.entitiesList.setModel(model);
                    this.entitiesList.revalidate();
                    this.entitiesList.repaint();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ex.getMessage(), ClientSettings.getInstance().getResources().getResource("Error"), 0);
            }
        }
    }
}

