/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.sqltool.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jallinone.sqltool.client.TablesController;
import org.jallinone.sqltool.java.ColumnVO;
import org.jallinone.sqltool.java.ForeignKeyVO;
import org.jallinone.sqltool.java.TableVO;
import org.openswing.swing.client.CopyButton;
import org.openswing.swing.client.DeleteButton;
import org.openswing.swing.client.EditButton;
import org.openswing.swing.client.ExportButton;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.client.InsertButton;
import org.openswing.swing.client.NavigatorBar;
import org.openswing.swing.client.ReloadButton;
import org.openswing.swing.client.SaveButton;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.table.client.GridController;
import org.openswing.swing.table.columns.client.CodLookupColumn;
import org.openswing.swing.table.columns.client.ComboColumn;
import org.openswing.swing.table.columns.client.DateColumn;
import org.openswing.swing.table.columns.client.DecimalColumn;
import org.openswing.swing.table.columns.client.IntegerColumn;
import org.openswing.swing.table.columns.client.TextColumn;
import org.openswing.swing.table.java.GridDataLocator;
import org.openswing.swing.table.java.ServerGridDataLocator;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class TablePanel
extends JPanel {
    BorderLayout borderLayout1;
    JPanel buttonsPanel = new JPanel();
    CopyButton copyButton;
    DeleteButton deleteButton;
    EditButton editButton;
    ExportButton exportButton;
    FlowLayout flowLayout1;
    GridControl grid;
    private ServerGridDataLocator gridDataLocator;
    InsertButton insertButton;
    NavigatorBar navigatorBar;
    ReloadButton reloadButton;
    SaveButton saveButton;
    private TableVO tableVO = null;

    public TablePanel(TableVO tableVO, boolean disableGrid, boolean autoLoadData) {
        this.borderLayout1 = new BorderLayout();
        this.flowLayout1 = new FlowLayout();
        this.insertButton = new InsertButton();
        this.copyButton = new CopyButton();
        this.reloadButton = new ReloadButton();
        this.deleteButton = new DeleteButton();
        this.navigatorBar = new NavigatorBar();
        this.grid = new GridControl();
        this.editButton = new EditButton();
        this.saveButton = new SaveButton();
        this.exportButton = new ExportButton();
        this.gridDataLocator = new ServerGridDataLocator();
        this.tableVO = tableVO;
        this.grid.setAutoLoadData(autoLoadData);
        this.init(disableGrid);
    }

    public TablePanel(String sql, ArrayList mainTables, boolean convertColumnHeaders, boolean disableGrid, boolean autoLoadData) {
        this.borderLayout1 = new BorderLayout();
        this.flowLayout1 = new FlowLayout();
        this.insertButton = new InsertButton();
        this.copyButton = new CopyButton();
        this.reloadButton = new ReloadButton();
        this.deleteButton = new DeleteButton();
        this.navigatorBar = new NavigatorBar();
        this.grid = new GridControl();
        this.editButton = new EditButton();
        this.saveButton = new SaveButton();
        this.exportButton = new ExportButton();
        this.gridDataLocator = new ServerGridDataLocator();
        try {
            this.grid.setAutoLoadData(autoLoadData);
            this.tableVO = new TableVO(sql, mainTables, convertColumnHeaders);
            Response res = ClientUtils.getData((String)"getQueryInfo", (Object)((Object)this.tableVO));
            if (res.isError()) {
                JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource(res.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 0);
            } else {
                this.tableVO = (TableVO)((Object)((VOResponse)res).getVo());
                this.init(disableGrid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource(e.getMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 0);
        }
    }

    public GridControl getGrid() {
        return this.grid;
    }

    public final TableVO getTableVO() {
        return this.tableVO;
    }

    private void init(boolean disableGrid) {
        try {
            Iterator it = this.tableVO.getForeingKeys().values().iterator();
            ForeignKeyVO fk = null;
            String colName = null;
            Hashtable<String, ForeignKeyVO> fks = new Hashtable<String, ForeignKeyVO>();
            HashSet<String> colsToDisable = new HashSet<String>();
            while (it.hasNext()) {
                fk = (ForeignKeyVO)((Object)it.next());
                colName = fk.getFkTableName() + "." + fk.getFkFieldNames().get(fk.getFkFieldNames().size() - 1);
                fks.put(colName, fk);
                int i = 0;
                while (i < fk.getFkFieldNames().size() - 1) {
                    colsToDisable.add(fk.getFkTableName() + "." + fk.getFkFieldNames().get(i));
                    ++i;
                }
            }
            this.jbInit();
            ArrayList cols = this.tableVO.getColumns();
            this.grid.setMaxSortedColumns(cols.size());
            ColumnVO vo = null;
            ComboColumn col = null;
            int i = 0;
            while (i < cols.size()) {
                vo = (ColumnVO)((Object)cols.get(i));
                int t = vo.getColumnSqlType();
                if (vo.getColumnValues() != null && vo.getColumnValues().size() > 0) {
                    col = new ComboColumn();
                    Domain domain = new Domain(vo.getColumnName());
                    int j = 0;
                    while (j < vo.getColumnValues().size()) {
                        domain.addDomainPair(vo.getColumnValues().get(j), vo.getColumnValues().get(j).toString());
                        ++j;
                    }
                    col.setDomain(domain);
                } else if (fks.containsKey(vo.getColumnName()) && t != 91 && t != 93 && t != 92) {
                    col = new CodLookupColumn();
                    ((CodLookupColumn)col).setMaxCharacters(vo.getColumnSize().intValue());
                    ((CodLookupColumn)col).setAllowOnlyNumbers(t != 12 && t != 1);
                    if (t == 1) {
                        ((CodLookupColumn)col).setCodePadding(true);
                    }
                    fk = (ForeignKeyVO)((Object)fks.get(vo.getColumnName()));
                    ((CodLookupColumn)col).setEnableCodBox(fk.getFkFieldNames().size() == 1);
                    String sql = "select * from " + fk.getPkTableName();
                    TableVO auxVO = new TableVO(sql, new ArrayList(), false);
                    Response res = ClientUtils.getData((String)"getQueryInfo", (Object)((Object)auxVO));
                    if (res.isError()) {
                        JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource(res.getErrorMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 0);
                    } else {
                        auxVO = (TableVO)((Object)((VOResponse)res).getVo());
                        this.setupLookup(auxVO, (CodLookupColumn)col, fk);
                    }
                } else if (t == 91 || t == 93 || t == 92) {
                    col = new DateColumn();
                } else if (t == -5 || t == 4 || t == 2 || t == 5 && vo.getColumnDec().equals(new BigDecimal(0.0))) {
                    col = new IntegerColumn();
                    ((IntegerColumn)col).setMaxValue((int)Math.pow(10.0, vo.getColumnSize().doubleValue()));
                } else if (t == -5 || t == 3 || t == 8 || t == 6 || t == 4 || t == 2 || t == 7 || t == 5) {
                    col = new DecimalColumn();
                    ((DecimalColumn)col).setMaxValue(Math.pow(10.0, vo.getColumnSize().doubleValue()));
                    ((DecimalColumn)col).setDecimals(vo.getColumnDec().intValue());
                } else {
                    col = new TextColumn();
                    ((TextColumn)col).setMaxCharacters(vo.getColumnSize().intValue());
                    if (t == 1) {
                        ((TextColumn)col).setRpadding(true);
                    }
                }
                col.setColumnName(vo.getAttributeName());
                col.setHeaderColumnName(vo.getColumnHeaderName());
                col.setColumnRequired(vo.getColumnRequired() && vo.getColumnVisible());
                col.setColumnFilterable(true);
                col.setColumnDuplicable(!vo.getProgressive());
                col.setColumnSortable(true);
                col.setColumnVisible(vo.getColumnVisible());
                col.setEditableOnInsert(!colsToDisable.contains(vo.getColumnName()) && !vo.getProgressive());
                col.setEditableOnEdit(!colsToDisable.contains(vo.getColumnName()) && !vo.getProgressive() && !vo.getPrimaryKey());
                col.setPreferredWidth(Math.max(vo.getColumnSize().intValue(), col.getHeaderColumnName().length() * 9));
                this.grid.getColumnContainer().add((Component)col);
                this.grid.setController((GridController)new TablesController(this.tableVO, this.grid));
                this.grid.setGridDataLocator((GridDataLocator)this.gridDataLocator);
                this.gridDataLocator.setServerMethodName("executeQuery");
                this.grid.getOtherGridParams().put("QUERY_INFO", this.tableVO);
                ++i;
            }
            if (disableGrid) {
                this.buttonsPanel.add((Component)this.reloadButton, null);
                this.buttonsPanel.add((Component)this.exportButton, null);
                this.buttonsPanel.add((Component)this.navigatorBar, null);
            } else {
                this.buttonsPanel.add((Component)this.insertButton, null);
                this.buttonsPanel.add((Component)this.copyButton, null);
                this.buttonsPanel.add((Component)this.editButton, null);
                this.buttonsPanel.add((Component)this.saveButton, null);
                this.buttonsPanel.add((Component)this.reloadButton, null);
                this.buttonsPanel.add((Component)this.deleteButton, null);
                this.buttonsPanel.add((Component)this.exportButton, null);
                this.buttonsPanel.add((Component)this.navigatorBar, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)MDIFrame.getInstance(), ClientSettings.getInstance().getResources().getResource(e.getMessage()), ClientSettings.getInstance().getResources().getResource("Error"), 0);
        }
    }

    private void jbInit() throws Exception {
        this.grid.setMaxNumberOfRowsOnInsert(50);
        this.grid.setSelectionMode(2);
        this.saveButton.setExecuteAsThread(true);
        this.grid.setValueObjectClassName("org.jallinone.sqltool.java.RowVO");
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.grid.setDeleteButton(this.deleteButton);
        this.grid.setEditButton(this.editButton);
        this.grid.setExportButton(this.exportButton);
        this.grid.setFunctionId("SQL");
        this.grid.setInsertButton(this.insertButton);
        this.grid.setCopyButton(this.copyButton);
        this.grid.setNavBar(this.navigatorBar);
        this.grid.setReloadButton(this.reloadButton);
        this.grid.setSaveButton(this.saveButton);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.buttonsPanel, "North");
        this.add((Component)this.grid, "Center");
    }

    public final void reloadData() {
        this.grid.reloadData();
    }

    private void setupLookup(final TableVO auxVO, CodLookupColumn col, final ForeignKeyVO fk) {
        LookupController lookupController = new LookupController();
        final LookupServerDataLocator lookupDataLocator = new LookupServerDataLocator();
        lookupDataLocator.setGridMethodName("executeQuery");
        lookupDataLocator.setValidationMethodName("executeValidateQuery");
        col.setLookupController(lookupController);
        lookupController.setAllColumnVisible(false);
        lookupController.setLookupDataLocator((LookupDataLocator)lookupDataLocator);
        lookupController.setFrameTitle(fk.getPkTableName());
        lookupController.setLookupValueObjectClassName("org.jallinone.sqltool.java.RowVO");
        ColumnVO vo = null;
        int colWidth = 0;
        int width = 0;
        int j = 0;
        while (j < auxVO.getColumns().size()) {
            vo = (ColumnVO)((Object)auxVO.getColumns().get(j));
            lookupController.setVisibleColumn(vo.getAttributeName(), true);
            lookupController.setHeaderColumnName(vo.getAttributeName(), vo.getColumnHeaderName());
            lookupController.setSortableColumn(vo.getAttributeName(), true);
            lookupController.setFilterableColumn(vo.getAttributeName(), true);
            colWidth = Math.max(vo.getColumnSize().intValue(), vo.getColumnHeaderName().length() * 9);
            lookupController.setPreferredWidthColumn(vo.getAttributeName(), colWidth);
            width += colWidth;
            int i = 0;
            while (i < fk.getFkFieldNames().size()) {
                if (vo.getColumnName().equals(fk.getPkTableName() + "." + fk.getPkFieldNames().get(i))) {
                    lookupController.addLookup2ParentLink(vo.getAttributeName(), this.tableVO.getAttributeName(fk.getFkTableName() + "." + fk.getFkFieldNames().get(i)));
                }
                ++i;
            }
            ++j;
        }
        lookupController.setFramePreferedSize(new Dimension(Math.min(750, width + 30), 500));
        lookupController.addLookupListener(new LookupListener(){

            public void beforeLookupAction(ValueObject parentVO) {
                lookupDataLocator.getLookupFrameParams().put("QUERY_INFO", auxVO);
                lookupDataLocator.getLookupValidationParameters().put("QUERY_INFO", auxVO);
                lookupDataLocator.getLookupValidationParameters().put("CODE", fk.getPkFieldNames().get(fk.getPkFieldNames().size() - 1));
            }

            public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
            }

            public void codeValidated(boolean validated) {
            }

            public void forceValidate() {
            }
        });
    }
}

