/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.availability.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jallinone.hierarchies.client.HierarTreePanel;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.warehouse.availability.client.ItemAvailabilityPanel;
import org.jallinone.warehouse.java.WarehouseVO;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;

public class ItemAvailabilityFrame
extends InternalFrame {
    ItemAvailabilityPanel availPanel = new ItemAvailabilityPanel();
    CodLookupControl controlWarehouseCod;
    TextControl controlWarehouseDescr;
    FlowLayout flowLayout1;
    HierarTreePanel hierarTreePanel;
    LabelControl labelWarehouse;
    JSplitPane split;
    LookupController warController;
    LookupServerDataLocator warDataLocator;
    Form warehousePanel = new Form();

    public ItemAvailabilityFrame() {
        this.labelWarehouse = new LabelControl();
        this.controlWarehouseCod = new CodLookupControl();
        this.controlWarehouseDescr = new TextControl();
        this.flowLayout1 = new FlowLayout(0);
        this.warDataLocator = new LookupServerDataLocator();
        this.warController = new LookupController();
        this.split = new JSplitPane();
        this.hierarTreePanel = new HierarTreePanel(){

            public void leftClick(DefaultMutableTreeNode node) {
                if (ItemAvailabilityFrame.this.hierarTreePanel.getSelectedNode() != null) {
                    HierarchyLevelVO levelVO = (HierarchyLevelVO)((Object)ItemAvailabilityFrame.this.hierarTreePanel.getSelectedNode().getUserObject());
                    ItemAvailabilityFrame.this.availPanel.getGrid().getOtherGridParams().put("PROGRESSIVE_HIE01", levelVO.getProgressiveHIE01());
                }
            }
        };
        try {
            this.jbInit();
            this.warDataLocator.setGridMethodName("loadWarehouses");
            this.warDataLocator.setValidationMethodName("validateWarehouseCode");
            this.controlWarehouseCod.setLookupController(this.warController);
            this.warController.setLookupDataLocator((LookupDataLocator)this.warDataLocator);
            this.warController.setFrameTitle("warehouses");
            this.warController.setLookupValueObjectClassName("org.jallinone.warehouse.java.WarehouseVO");
            this.warController.addLookup2ParentLink("companyCodeSys01WAR01", "companyCodeSys01WAR01");
            this.warController.addLookup2ParentLink("warehouseCodeWAR01", "warehouseCodeWAR01");
            this.warController.addLookup2ParentLink("progressiveHie02WAR01", "progressiveHie02WAR01");
            this.warController.addLookup2ParentLink("descriptionWAR01", "descriptionWAR01");
            this.warController.setAllColumnVisible(false);
            this.warController.setVisibleColumn("companyCodeSys01WAR01", true);
            this.warController.setVisibleColumn("warehouseCodeWAR01", true);
            this.warController.setVisibleColumn("descriptionWAR01", true);
            this.warController.setPreferredWidthColumn("descriptionWAR01", 250);
            this.warController.setFramePreferedSize(new Dimension(460, 500));
            this.warController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    WarehouseVO vo = (WarehouseVO)ItemAvailabilityFrame.this.warehousePanel.getVOModel().getValueObject();
                    if (vo.getWarehouseCodeWAR01() == null || vo.getWarehouseCodeWAR01().equals("")) {
                        ItemAvailabilityFrame.this.hierarTreePanel.setEnabled(false);
                        ItemAvailabilityFrame.this.hierarTreePanel.clearTree();
                        ItemAvailabilityFrame.this.availPanel.getGrid().clearData();
                        ItemAvailabilityFrame.this.availPanel.setEnabled(false);
                    } else {
                        ItemAvailabilityFrame.this.hierarTreePanel.setCompanyCode(vo.getCompanyCodeSys01WAR01());
                        ItemAvailabilityFrame.this.hierarTreePanel.setProgressiveHIE02(vo.getProgressiveHie02WAR01());
                        ItemAvailabilityFrame.this.hierarTreePanel.reloadTree();
                        ItemAvailabilityFrame.this.availPanel.setEnabled(true);
                        ItemAvailabilityFrame.this.availPanel.getGrid().getOtherGridParams().put("COMPANY_CODE_SYS01", vo.getCompanyCodeSys01WAR01());
                        ItemAvailabilityFrame.this.availPanel.getGrid().getOtherGridParams().put("WAREHOUSE_CODE", vo.getWarehouseCodeWAR01());
                        ItemAvailabilityFrame.this.availPanel.getGrid().getOtherGridParams().put("PROGRESSIVE_HIE02", vo.getProgressiveHie02WAR01());
                        if (ItemAvailabilityFrame.this.hierarTreePanel.getSelectedNode() != null) {
                            HierarchyLevelVO levelVO = (HierarchyLevelVO)((Object)ItemAvailabilityFrame.this.hierarTreePanel.getSelectedNode().getUserObject());
                            ItemAvailabilityFrame.this.availPanel.getGrid().getOtherGridParams().put("PROGRESSIVE_HIE01", levelVO.getProgressiveHIE01());
                        }
                    }
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            this.setSize(750, 500);
            MDIFrame.getInstance();
            MDIFrame.add((InternalFrame)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(ClientSettings.getInstance().getResources().getResource("item availability"));
        this.hierarTreePanel.setEnabled(false);
        this.availPanel.setEnabled(false);
        this.controlWarehouseDescr.setRequired(true);
        this.controlWarehouseDescr.setColumns(50);
        this.split.setDividerLocation(150);
        this.split.add((Component)((Object)this.hierarTreePanel), "left");
        this.split.add((Component)this.availPanel, "right");
        this.hierarTreePanel.setFunctionId("WAR01");
        this.warehousePanel.setVOClassName("org.jallinone.warehouse.java.WarehouseVO");
        this.labelWarehouse.setText("warehouse");
        this.controlWarehouseCod.setEnabled(true);
        this.controlWarehouseCod.setMaxCharacters(20);
        this.controlWarehouseCod.setAttributeName("warehouseCodeWAR01");
        this.controlWarehouseDescr.setEnabled(false);
        this.controlWarehouseDescr.setAttributeName("descriptionWAR01");
        this.warehousePanel.setLayout((LayoutManager)this.flowLayout1);
        this.warehousePanel.add((Component)this.labelWarehouse, null);
        this.warehousePanel.add((Component)this.controlWarehouseCod, null);
        this.getContentPane().add((Component)this.warehousePanel, "North");
        this.getContentPane().add((Component)this.split, "Center");
        this.warehousePanel.add((Component)this.controlWarehouseDescr, null);
    }
}

