/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import org.jallinone.commons.client.ApplicationClientFacade;
import org.jallinone.commons.client.ClientApplet;
import org.jallinone.system.java.ButtonCompanyAuthorizations;
import org.jallinone.warehouse.client.InventoryFrame_printButton_actionAdapter;
import org.jallinone.warehouse.java.WarehouseVO;
import org.openswing.swing.client.CodLookupControl;
import org.openswing.swing.client.ComboBoxControl;
import org.openswing.swing.client.GenericButton;
import org.openswing.swing.client.LabelControl;
import org.openswing.swing.client.TextControl;
import org.openswing.swing.domains.java.Domain;
import org.openswing.swing.form.client.Form;
import org.openswing.swing.lookup.client.LookupController;
import org.openswing.swing.lookup.client.LookupDataLocator;
import org.openswing.swing.lookup.client.LookupListener;
import org.openswing.swing.lookup.client.LookupServerDataLocator;
import org.openswing.swing.mdi.client.InternalFrame;
import org.openswing.swing.mdi.client.MDIFrame;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientSettings;
import org.openswing.swing.util.client.ClientUtils;

public class InventoryFrame
extends InternalFrame {
    ComboBoxControl controlCompaniesCombo;
    TextControl controlDescr;
    CodLookupControl controlWarehouseCode;
    GridBagLayout gridBagLayout1;
    LabelControl labelCompanyCode;
    LabelControl labelWarehouseCode;
    GenericButton printButton = new GenericButton(new ImageIcon(ClientUtils.getImage((String)"printer.gif")));
    LookupController wareController;
    LookupServerDataLocator wareDataLocator;
    Form warehousePanel;

    public InventoryFrame() {
        this.labelCompanyCode = new LabelControl();
        this.controlCompaniesCombo = new ComboBoxControl();
        this.labelWarehouseCode = new LabelControl();
        this.controlWarehouseCode = new CodLookupControl();
        this.gridBagLayout1 = new GridBagLayout();
        this.wareController = new LookupController();
        this.wareDataLocator = new LookupServerDataLocator();
        this.controlDescr = new TextControl();
        this.warehousePanel = new Form();
        try {
            this.jbInit();
            this.setSize(500, 150);
            this.setMinimumSize(new Dimension(500, 150));
            this.wareDataLocator.setGridMethodName("loadWarehouses");
            this.wareDataLocator.setValidationMethodName("validateWarehouseCode");
            this.controlWarehouseCode.setLookupController(this.wareController);
            this.wareController.setForm(this.warehousePanel);
            this.wareController.setLookupDataLocator((LookupDataLocator)this.wareDataLocator);
            this.wareController.setFrameTitle("warehouses");
            this.wareController.setLookupValueObjectClassName("org.jallinone.warehouse.java.WarehouseVO");
            this.wareController.addLookup2ParentLink("warehouseCodeWAR01", "warehouseCodeWAR01");
            this.wareController.addLookup2ParentLink("descriptionWAR01", "descriptionWAR01");
            this.wareController.setAllColumnVisible(false);
            this.wareController.setVisibleColumn("warehouseCodeWAR01", true);
            this.wareController.setVisibleColumn("descriptionWAR01", true);
            this.wareController.setVisibleColumn("addressWAR01", true);
            this.wareController.setVisibleColumn("cityWAR01", true);
            this.wareController.setVisibleColumn("zipWAR01", true);
            this.wareController.setVisibleColumn("provinceWAR01", true);
            this.wareController.setVisibleColumn("countryWAR01", true);
            this.wareController.setPreferredWidthColumn("descriptionWAR01", 200);
            this.wareController.setFramePreferedSize(new Dimension(750, 500));
            this.wareController.addLookupListener(new LookupListener(){

                public void beforeLookupAction(ValueObject parentVO) {
                    InventoryFrame.this.wareDataLocator.getLookupFrameParams().put("COMPANY_CODE_SYS01", InventoryFrame.this.controlCompaniesCombo.getValue());
                    InventoryFrame.this.wareDataLocator.getLookupValidationParameters().put("COMPANY_CODE_SYS01", InventoryFrame.this.controlCompaniesCombo.getValue());
                }

                public void codeChanged(ValueObject parentVO, Collection parentChangedAttributes) {
                    WarehouseVO vo = (WarehouseVO)InventoryFrame.this.controlWarehouseCode.getLookupController().getLookupVO();
                    InventoryFrame.this.controlDescr.setText(vo.getDescriptionWAR01());
                }

                public void codeValidated(boolean validated) {
                }

                public void forceValidate() {
                }
            });
            MDIFrame.getInstance();
            ClientApplet applet = ((ApplicationClientFacade)MDIFrame.getClientFacade()).getMainClass();
            ButtonCompanyAuthorizations bca = applet.getAuthorizations().getCompanyBa();
            ArrayList companiesList = bca.getCompaniesList("WAR03_INVENTORY");
            Domain domain = new Domain("DOMAIN_WAR03_INVENTORY");
            int i = 0;
            while (i < companiesList.size()) {
                if (applet.getAuthorizations().getCompanyBa().isInsertEnabled("WAR03_INVENTORY", companiesList.get(i).toString())) {
                    domain.addDomainPair(companiesList.get(i), companiesList.get(i).toString());
                }
                ++i;
            }
            this.controlCompaniesCombo.setDomain(domain);
            MDIFrame.add((InternalFrame)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.warehousePanel.setVOClassName("org.jallinone.warehouse.java.WarehouseVO");
        this.warehousePanel.setFunctionId("WAR03_INVENTORY");
        this.printButton.setToolTipText(ClientSettings.getInstance().getResources().getResource("print document"));
        this.printButton.addActionListener((ActionListener)new InventoryFrame_printButton_actionAdapter(this));
        this.setTitle(ClientSettings.getInstance().getResources().getResource("warehouse inventory"));
        this.labelWarehouseCode.setText("warehouseCodeWAR01");
        this.controlWarehouseCode.setAttributeName("warehouseCodeWAR01");
        this.controlWarehouseCode.setMaxCharacters(20);
        this.controlDescr.setAttributeName("descriptionWAR01");
        this.controlDescr.setEnabled(false);
        this.labelCompanyCode.setText("companyCodeSys01WAR01");
        this.controlCompaniesCombo.setAttributeName("companyCodeSys01WAR01");
        this.getContentPane().add((Component)this.warehousePanel, "Center");
        this.warehousePanel.setLayout((LayoutManager)this.gridBagLayout1);
        this.warehousePanel.add((Component)this.labelCompanyCode, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.warehousePanel.add((Component)this.controlCompaniesCombo, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.warehousePanel.add((Component)this.labelWarehouseCode, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.warehousePanel.add((Component)this.controlWarehouseCode, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.warehousePanel.add((Component)this.controlDescr, (Object)new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.warehousePanel.add((Component)this.printButton, (Object)new GridBagConstraints(0, 2, 3, 1, 0.0, 1.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    void printButton_actionPerformed(ActionEvent e) {
        if (this.controlCompaniesCombo.getValue() == null) {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), ClientSettings.getInstance().getResources().getResource("please select a company"), ClientSettings.getInstance().getResources().getResource("Attention"), 2);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("COMPANY_CODE", this.controlCompaniesCombo.getValue());
        if (this.controlWarehouseCode.getValue() != null) {
            params.put("WAREHOUSE_CODE", " and WAREHOUSE_CODE_WAR01='" + this.controlWarehouseCode.getValue() + "'");
        } else {
            params.remove("WAREHOUSE_CODE");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("COMPANY_CODE_SYS01", this.controlCompaniesCombo.getValue());
        map.put("FUNCTION_CODE_SYS06", "WAR03_INVENTORY");
        map.put("EXPORT_PARAMS", params);
        Response res = ClientUtils.getData((String)"getJasperReport", map);
        if (!res.isError()) {
            JasperPrint print = (JasperPrint)((VOResponse)res).getVo();
            JRViewer viewer = new JRViewer(print);
            JFrame frame = new JFrame();
            frame.setSize(MDIFrame.getInstance().getSize());
            frame.setContentPane((Container)viewer);
            frame.setTitle(this.getTitle());
            frame.setIconImage(MDIFrame.getInstance().getIconImage());
            frame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(ClientUtils.getParentFrame((JComponent)((Object)this)), res.getErrorMessage(), ClientSettings.getInstance().getResources().getResource("print document"), 0);
        }
    }
}

