/*
 * Decompiled with CFR 0.152.
 */
package org.jallinone.warehouse.documents.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jallinone.commons.client.CompanyGridController;
import org.jallinone.hierarchies.java.HierarchyLevelVO;
import org.jallinone.warehouse.documents.client.InDeliveryNoteRowsGridPanel;
import org.jallinone.warehouse.documents.client.SerialNumberDialog;
import org.jallinone.warehouse.documents.java.GridInDeliveryNoteRowVO;
import org.jallinone.warehouse.documents.java.InDeliveryNoteRowPK;
import org.openswing.swing.client.GridControl;
import org.openswing.swing.message.receive.java.ErrorResponse;
import org.openswing.swing.message.receive.java.Response;
import org.openswing.swing.message.receive.java.VOListResponse;
import org.openswing.swing.message.receive.java.VOResponse;
import org.openswing.swing.message.receive.java.ValueObject;
import org.openswing.swing.util.client.ClientUtils;

public class InDeliveryNoteRowsController
extends CompanyGridController {
    private InDeliveryNoteRowsGridPanel panel = null;

    public InDeliveryNoteRowsController(InDeliveryNoteRowsGridPanel panel) {
        this.panel = panel;
    }

    public void afterEditGrid(GridControl grid) {
        this.panel.getGrid().reloadData();
        this.panel.getHeaderPanel().setMode(0);
        this.panel.getHeaderPanel().executeReload();
        this.panel.getOrders().reloadData();
    }

    public void afterInsertGrid(GridControl grid) {
        this.panel.getHeaderPanel().setMode(0);
        this.panel.getHeaderPanel().executeReload();
        this.panel.getOrders().reloadData();
        this.panel.getFrame().enabledConfirmButton();
    }

    public boolean beforeDeleteGrid(GridControl grid) {
        if (!super.beforeDeleteGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC08().equals("D");
    }

    public boolean beforeEditGrid(GridControl grid) {
        if (!super.beforeEditGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC08().equals("D");
    }

    public boolean beforeInsertGrid(GridControl grid) {
        if (!super.beforeInsertGrid(grid)) {
            return false;
        }
        return !this.panel.getParentVO().getDocStateDOC08().equals("D");
    }

    public void createValueObject(ValueObject valueObject) throws Exception {
        GridInDeliveryNoteRowVO vo = (GridInDeliveryNoteRowVO)valueObject;
        vo.setCompanyCodeSys01DOC09(this.panel.getParentVO().getCompanyCodeSys01DOC08());
        vo.setDocTypeDOC09(this.panel.getParentVO().getDocTypeDOC08());
        vo.setDocYearDOC09(this.panel.getParentVO().getDocYearDOC08());
        vo.setDocNumberDOC09(this.panel.getParentVO().getDocNumberDOC08());
        vo.setDocTypeDoc06DOC09("P");
        vo.setWarehouseCodeWar01DOC08(this.panel.getParentVO().getWarehouseCodeWar01DOC08());
        Response res = ClientUtils.getData((String)"getRootLevel", (Object)this.panel.getParentVO().getProgressiveHie02WAR01());
        if (!res.isError()) {
            HierarchyLevelVO posVO = (HierarchyLevelVO)((Object)((VOResponse)res).getVo());
            vo.setProgressiveHie01DOC09(posVO.getProgressiveHIE01());
            vo.setLocationDescriptionSYS10(posVO.getDescriptionSYS10());
        }
    }

    public Response deleteRecords(ArrayList persistentObjects) throws Exception {
        ArrayList<InDeliveryNoteRowPK> pks = new ArrayList<InDeliveryNoteRowPK>();
        InDeliveryNoteRowPK pk = null;
        GridInDeliveryNoteRowVO vo = null;
        int i = 0;
        while (i < persistentObjects.size()) {
            vo = (GridInDeliveryNoteRowVO)((Object)persistentObjects.get(i));
            pk = new InDeliveryNoteRowPK(vo.getCompanyCodeSys01DOC09(), vo.getDocTypeDOC09(), vo.getDocYearDOC09(), vo.getDocNumberDOC09(), vo.getDocTypeDoc06DOC09(), vo.getDocYearDoc06DOC09(), vo.getDocNumberDoc06DOC09(), vo.getRowNumberDOC09(), vo.getItemCodeItm01DOC09());
            pks.add(pk);
            ++i;
        }
        Response res = ClientUtils.getData((String)"deleteInDeliveryNoteRows", pks);
        if (!res.isError()) {
            this.panel.getGrid().reloadData();
            this.panel.getHeaderPanel().setMode(0);
            this.panel.getHeaderPanel().executeReload();
            this.panel.getOrders().reloadData();
        }
        return res;
    }

    public Response insertRecords(int[] rowNumbers, ArrayList newValueObjects) throws Exception {
        ValueObject newValueObject = (ValueObject)newValueObjects.get(0);
        if (this.panel.isSerialNumberRequired() && !this.promptSerialNumbers((GridInDeliveryNoteRowVO)newValueObject)) {
            return new ErrorResponse("insert not allowed until serial numbers are not defined");
        }
        Response res = ClientUtils.getData((String)"insertInDeliveryNoteRow", (Object)newValueObject);
        if (res.isError()) {
            return res;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((VOResponse)res).getVo());
        return new VOListResponse(list, false, list.size());
    }

    private boolean promptSerialNumbers(GridInDeliveryNoteRowVO vo) {
        ArrayList list = vo.getSerialNumbers();
        if (list == null) {
            list = new ArrayList(vo.getQtyDOC09().intValue());
            vo.setSerialNumbers(list);
            list = new ArrayList(vo.getQtyDOC09().intValue());
            vo.setBarCodes(list);
        } else if (vo.getSerialNumbers().size() < vo.getQtyDOC09().intValue()) {
            int i = vo.getSerialNumbers().size();
            while (i < vo.getQtyDOC09().intValue()) {
                vo.getSerialNumbers().add(null);
                vo.getBarCodes().add(null);
                ++i;
            }
        } else if (vo.getSerialNumbers().size() > vo.getQtyDOC09().intValue()) {
            while (vo.getSerialNumbers().size() > vo.getQtyDOC09().intValue()) {
                vo.getSerialNumbers().remove(vo.getSerialNumbers().size() - 1);
                vo.getBarCodes().remove(vo.getBarCodes().size() - 1);
            }
        }
        new SerialNumberDialog(vo.getSerialNumbers(), vo.getBarCodes(), vo.getItemCodeItm01DOC09() + " - " + vo.getDescriptionSYS10());
        return true;
    }

    public Response updateRecords(int[] rowNumbers, ArrayList oldPersistentObjects, ArrayList persistentObjects) throws Exception {
        int i = 0;
        while (i < persistentObjects.size()) {
            GridInDeliveryNoteRowVO vo = (GridInDeliveryNoteRowVO)((Object)persistentObjects.get(i));
            if (this.panel.isSerialNumberRequired() && !this.promptSerialNumbers(vo)) {
                return new ErrorResponse("update not allowed until serial numbers are not defined");
            }
            ++i;
        }
        return ClientUtils.getData((String)"updateInDeliveryNoteRows", (Object)new ArrayList[]{oldPersistentObjects, persistentObjects});
    }

    public boolean validateCell(int rowNumber, String attributeName, Object oldValue, Object newValue) {
        GridInDeliveryNoteRowVO vo = (GridInDeliveryNoteRowVO)this.panel.getGrid().getVOListTableModel().getObjectForRow(rowNumber);
        if (attributeName.equals("supplierQtyDOC09")) {
            if (newValue == null) {
                vo.setQtyDOC09(null);
            } else if (vo.getValueREG05() != null) {
                vo.setQtyDOC09(((BigDecimal)newValue).divide(vo.getValueREG05(), vo.getDecimalsREG02().intValue(), 4));
            }
        } else if (attributeName.equals("qtyDOC09")) {
            if (newValue == null) {
                vo.setSupplierQtyDOC09(null);
            } else if (vo.getValueREG05() != null) {
                vo.setSupplierQtyDOC09(((BigDecimal)newValue).multiply(vo.getValueREG05()).setScale(vo.getSupplierQtyDecimalsREG02().intValue(), 4));
            }
        }
        return true;
    }
}

